/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.enumeration.MessageArchiveState;
import kd.bos.message.archive.model.EntitySummaryInfo;
import kd.bos.message.archive.model.PredictArchiveInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.MessageService;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MessageArchiveUtil {
    private static Log logger = LogFactory.getLog(MessageArchiveUtil.class);
    private static final String NUMBER = "number";

    public static String getEntityArchiveScheduleNumber(String entityNumber) {
        return entityNumber.trim().toLowerCase() + "_arch_skdp";
    }

    public static Map<String, Date> getArchiveDates(int startYear, int endYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(startYear, 0, 1);
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        Date archiveStartDate = calendar.getTime();
        calendar.set(endYear + 1, 0, 1);
        Date archiveEndDate = calendar.getTime();
        HashMap<String, Date> dates = new HashMap<String, Date>();
        dates.put("startDate", archiveStartDate);
        dates.put("endDate", archiveEndDate);
        return dates;
    }

    public static void operateScheduleJob() {
        try {
            QFilter[] filters = new QFilter[]{new QFilter("state", "=", (Object)MessageArchiveState.ARCHIVEWILL.getValue())};
            boolean exists = QueryServiceHelper.exists((String)"wf_archiveservice", (QFilter[])filters);
            if (exists) {
                MessageArchiveUtil.enableScheduleJob();
            } else {
                MessageArchiveUtil.disableScheduleJob();
            }
        }
        catch (Exception e) {
            logger.warn("MessageArchiveUtil_enableSchduleJob enableSchedule is fail" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private static void enableScheduleJob() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.enableJob("2+/Z1=ARC3BT");
        scheduleManager.enableSchedule("2+0/ARCHI/0D");
    }

    public static void disableScheduleJob() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("2+/Z1=ARC3BT");
        scheduleManager.disableSchedule("2+0/ARCHI/0D");
    }

    public static void sendArchiveMsg(DynamicObject archiveService) {
        String msg = archiveService.getString("archivemsg");
        if (WfUtils.isEmpty((String)msg)) {
            return;
        }
        try {
            Map msgData = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            String msgChannels = (String)msgData.get("msgChannels");
            Object receivers = msgData.get("msgReceivers");
            ArrayList<Long> userIds = new ArrayList<Long>();
            if (receivers != null) {
                List rs = (List)receivers;
                for (Map map : rs) {
                    Map basedataMap = (Map)map.get("fbasedataid");
                    Long userId = 0L;
                    Object id = basedataMap.get("id");
                    if (id instanceof Long) {
                        userId = (Long)id;
                    } else if (id instanceof Integer) {
                        userId = (long)((Integer)id).intValue() + 0L;
                    } else if (id instanceof String) {
                        userId = Long.valueOf((String)id);
                    }
                    userIds.add(userId);
                }
            }
            String titleContent = (String)msgData.get("titleContent");
            Map tc = (Map)SerializationUtils.fromJsonString((String)titleContent, Map.class);
            MessageService messageService = MessageServiceUtil.getMessageService();
            ILocaleString content = messageService.calcMessageTemplate(archiveService, (Map)tc.get("content"));
            ILocaleString title = messageService.calcMessageTemplate(archiveService, (Map)tc.get("title"));
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setMessageTitle(title);
            messageInfo.setMessageContent(content);
            messageInfo.setBizDataId(Long.valueOf(archiveService.getLong("id")));
            messageInfo.setEntityNumber("wf_archiveservice");
            messageInfo.setMessageSenderName(WfUtils.getPromptWordLocaleString((String)"\u5f52\u6863\u670d\u52a1", (String)"MessageArchiveUtil_0", (String)"bos-wf-archive"));
            messageInfo.setMessageTag(WfUtils.getPromptWordLocaleString((String)"\u5f52\u6863", (String)"MessageArchiveUtil_1", (String)"bos-wf-archive"));
            msgChannels = msgChannels.trim();
            msgChannels = msgChannels.endsWith(",") ? msgChannels.substring(0, msgChannels.length() - 1) : msgChannels;
            msgChannels = msgChannels.startsWith(",") ? msgChannels.substring(1, msgChannels.length()) : msgChannels;
            messageInfo.setNotifyType(msgChannels);
            messageInfo.setType("message");
            messageInfo.setUserIds(userIds);
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            logger.info(String.format("MessageArchiveUtil_sendMsg:archiveService[%s], state[%s], progress[%s], content[%s], userIds[%s]", archiveService.getString(NUMBER), archiveService.getString("state"), archiveService.getString("progress"), content.getLocaleValue(), ((Object)userIds).toString()));
        }
        catch (Exception e) {
            logger.warn(String.format("MessageArchiveUtil_sendMsg has error[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    public static Boolean isHistoricDataRepairDone() {
        QFilter f1 = new QFilter(NUMBER, "=", (Object)"archiveHiparticipantRepair");
        QFilter f11 = new QFilter(NUMBER, "=", (Object)"wfRuleTaskRelationRepair");
        QFilter f2 = new QFilter("enddate", "is not null", null);
        QFilter f3 = new QFilter("state", "=", (Object)"FINISHED");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"wf_repairtask", (String)"id,number,state", (QFilter[])new QFilter[]{f1.or(f11), f2, f3});
        return 2 == query.size();
    }

    public static PredictArchiveInfo getPredictArchiveData(List<EntitySummaryInfo> entitySummaryInfos, String archiveEntity, int scheduleSize) {
        int parentEntitySummary = 0;
        int archiveSummary = 0;
        if (entitySummaryInfos != null && !entitySummaryInfos.isEmpty()) {
            for (int i = 0; i < entitySummaryInfos.size(); ++i) {
                EntitySummaryInfo entitySummaryInfo = entitySummaryInfos.get(i);
                if (entitySummaryInfo.getNumber().equalsIgnoreCase(archiveEntity)) {
                    parentEntitySummary = entitySummaryInfo.getArchiveSummary();
                }
                archiveSummary += entitySummaryInfo.getArchiveSummary();
            }
        }
        double predictArchiveSum = (double)archiveSummary / 10000.0;
        double predictTime = 0.0;
        if (parentEntitySummary > 0) {
            int scheduleTime = 5;
            double ss = Math.ceil((double)parentEntitySummary / ((double)scheduleSize + 0.0));
            DecimalFormat df = new DecimalFormat("0");
            df.setRoundingMode(RoundingMode.HALF_UP);
            predictTime = Double.parseDouble(df.format(ss * (double)scheduleTime));
        }
        return new PredictArchiveInfo(predictTime, predictArchiveSum);
    }

    public static boolean matchPattern(String patternStr, String value) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }
}

