/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.impl.ast.AstBinary;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstIdentifier;
import de.odysseus.el.tree.impl.ast.AstNested;
import de.odysseus.el.tree.impl.ast.AstNumber;
import de.odysseus.el.tree.impl.ast.AstString;
import de.odysseus.el.tree.impl.ast.AstUnary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConditionsConversion {
    public static final String LEFTBRACKET = "leftbracket";
    public static final String EXPRESSION = "expression";
    public static final String COMPARETYPE = "comparetype";
    public static final String VALUETYPE = "valuetype";
    public static final String VALUE = "value";
    public static final String RIGHTBRACKET = "rightbracket";
    public static final String LOGAIC = "logaic";
    protected static final Set<String> astBinaryOperations = new HashSet<String>();
    protected static final Set<String> astUnaryOperations = new HashSet<String>();
    protected static final Set<String> astLogaics = new HashSet<String>();

    public static void createConditionItem(Node root, LinkedList<String> leftbracketDeque, LinkedList<String> logaicDeque, List<Map<String, Object>> conditions) {
        if (root instanceof AstBinary) {
            AstBinary astBinary = (AstBinary)root;
            if (astBinaryOperations.contains(astBinary.getOperator().toString())) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put(COMPARETYPE, astBinary.getOperator().toString());
                Object expression = ConditionsConversion.leavesValue(astBinary.getLeft());
                condition.put(EXPRESSION, expression);
                if (astBinary.getRight() instanceof AstDot || astBinary.getRight() instanceof AstIdentifier) {
                    condition.put(VALUETYPE, "fieldVal");
                } else {
                    condition.put(VALUETYPE, "commVal");
                }
                condition.put(VALUE, ConditionsConversion.leavesValue(astBinary.getRight()));
                ConditionsConversion.setConditionByDeque(leftbracketDeque, logaicDeque, condition);
                conditions.add(condition);
            } else if (astLogaics.contains(astBinary.getOperator().toString())) {
                logaicDeque.addFirst(astBinary.getOperator().toString());
                ConditionsConversion.createConditionItem(astBinary.getLeft(), leftbracketDeque, logaicDeque, conditions);
                ConditionsConversion.createConditionItem(astBinary.getRight(), leftbracketDeque, logaicDeque, conditions);
            }
        } else if (root instanceof AstUnary) {
            if (astUnaryOperations.contains(((AstUnary)root).getOperator().toString())) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put(COMPARETYPE, ((AstUnary)root).getOperator().toString());
                condition.put(EXPRESSION, ConditionsConversion.leavesValue(root.getChild(0)));
                condition.put(VALUETYPE, "commval");
                ConditionsConversion.setConditionByDeque(leftbracketDeque, logaicDeque, condition);
                conditions.add(condition);
            } else if ("!".equals(((AstUnary)root).getOperator().toString())) {
                leftbracketDeque.addFirst("!");
                ConditionsConversion.createConditionItem(root.getChild(0), leftbracketDeque, logaicDeque, conditions);
            }
        } else if (root instanceof AstNested) {
            leftbracketDeque.addFirst("(");
            ConditionsConversion.createConditionItem(root.getChild(0), leftbracketDeque, logaicDeque, conditions);
            String rightBracket = conditions.get(conditions.size() - 1).get(RIGHTBRACKET) == null ? "" : conditions.get(conditions.size() - 1).get(RIGHTBRACKET).toString();
            conditions.get(conditions.size() - 1).put(RIGHTBRACKET, rightBracket + ")");
        }
    }

    private static void setConditionByDeque(LinkedList<String> leftbracketDeque, LinkedList<String> logaicDeque, Map<String, Object> condition) {
        String i;
        while (!leftbracketDeque.isEmpty()) {
            i = leftbracketDeque.removeFirst();
            if (ConditionsConversion.isEmptyString(condition.get(LEFTBRACKET))) {
                condition.put(LEFTBRACKET, i);
                continue;
            }
            condition.put(LEFTBRACKET, i + condition.get(LEFTBRACKET));
        }
        if (!logaicDeque.isEmpty() && ConditionsConversion.isEmptyString(condition.get(LOGAIC))) {
            i = logaicDeque.removeFirst();
            condition.put(LOGAIC, i);
        }
    }

    public static Object leavesValue(Node leave) {
        if (leave instanceof AstDot) {
            AstDot ad = (AstDot)leave;
            if (ad.getPrefix() instanceof AstDot) {
                return ConditionsConversion.leavesValue(ad.getPrefix()) + "." + ad.getProperty();
            }
            return ad.getPrefix() + "." + ad.getProperty();
        }
        if (leave instanceof AstString) {
            return ((AstString)leave).getValue();
        }
        if (leave instanceof AstIdentifier) {
            return ((AstIdentifier)leave).getName();
        }
        if (leave instanceof AstNumber) {
            return ((AstNumber)leave).getValue();
        }
        return null;
    }

    public static boolean isEmptyString(Object value) {
        if (value == null) {
            return true;
        }
        return value.toString().trim().length() <= 0;
    }

    static {
        astBinaryOperations.add("==");
        astBinaryOperations.add(">=");
        astBinaryOperations.add(">");
        astBinaryOperations.add("<=");
        astBinaryOperations.add("<");
        astBinaryOperations.add("!=");
        astBinaryOperations.add("LK");
        astBinaryOperations.add("NL");
        astBinaryOperations.add("BL");
        astBinaryOperations.add("NB");
        astBinaryOperations.add("CL");
        astBinaryOperations.add("NC");
        astBinaryOperations.add("IN");
        astBinaryOperations.add("NI");
        astBinaryOperations.add("BS");
        astBinaryOperations.add("CS");
        astBinaryOperations.add("BO");
        astBinaryOperations.add("BR");
        astBinaryOperations.add("NR");
        astUnaryOperations.add("empty");
        astUnaryOperations.add("notempty");
        astLogaics.add("||");
        astLogaics.add("&&");
    }
}

