/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;

public final class ObjectValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private final TypeConverter converter;
    private final Object object;
    private final Class<?> type;

    public ObjectValueExpression(TypeConverter converter, Object object, Class<?> type) {
        this.converter = converter;
        this.object = object;
        this.type = type;
        if (type == null) {
            throw new NullPointerException(LocalMessages.get("error.value.notype", new Object[0]));
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == ((Object)((Object)this)).getClass()) {
            ObjectValueExpression other = (ObjectValueExpression)((Object)obj);
            if (this.type != other.type) {
                return false;
            }
            return this.object == other.object || this.object != null && this.object.equals(other.object);
        }
        return false;
    }

    public int hashCode() {
        return this.object == null ? 0 : this.object.hashCode();
    }

    public Object getValue(ELContext context) {
        return this.converter.convert(this.object, this.type);
    }

    public String getExpressionString() {
        return null;
    }

    public boolean isLiteralText() {
        return false;
    }

    public Class<?> getType(ELContext context) {
        return null;
    }

    public boolean isReadOnly(ELContext context) {
        return true;
    }

    public void setValue(ELContext context, Object value) {
        throw new ELException(LocalMessages.get("error.value.set.rvalue", "<object value expression>"));
    }

    public String toString() {
        return "ValueExpression(" + this.object + ")";
    }

    public Class<?> getExpectedType() {
        return this.type;
    }
}

