/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.function.collection;

public enum CollectionFunctionType {
    SUM("sum", "sum(number[])", "number"),
    AVG("avg", "avg(number[])", "number"),
    MAX("max", "max(number[])", "number"),
    MIN("min", "min(number[])", "number"),
    COUNT("count", "count(obj[])", "int"),
    FIRST("first", "first(obj[])", "obj");

    private String number;
    private String descName;
    private String returnValType;

    private CollectionFunctionType(String number, String descName, String returnValType) {
        this.number = number;
        this.descName = descName;
        this.returnValType = returnValType;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDescName() {
        return this.descName;
    }

    public String getReturnValType() {
        return this.returnValType;
    }

    public static boolean isContain(String number) {
        if (number == null || "".equals(number)) {
            return false;
        }
        for (CollectionFunctionType funcType : CollectionFunctionType.values()) {
            if (!number.equals(funcType.getNumber())) continue;
            return true;
        }
        return false;
    }

    public static String getDescNameByFuncNumber(String funcNumber) {
        if (funcNumber == null || "".equals(funcNumber)) {
            return "";
        }
        for (CollectionFunctionType funcType : CollectionFunctionType.values()) {
            if (!funcNumber.equals(funcType.getNumber())) continue;
            return funcType.getDescName();
        }
        return "";
    }

    public static String getReturnValTypeByFuncNumber(String funcNumber) {
        if (funcNumber == null || "".equals(funcNumber)) {
            return "";
        }
        for (CollectionFunctionType funcType : CollectionFunctionType.values()) {
            if (!funcNumber.equals(funcType.getNumber())) continue;
            return funcType.getReturnValType();
        }
        return "";
    }
}

