/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.ExpBooleanOperation;
import de.odysseus.el.misc.ExpManagerUtils;
import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BooleanOperations {
    private static final Set<Class<? extends Number>> SIMPLE_INTEGER_TYPES = new HashSet<Class<? extends Number>>();
    private static final Set<Class<? extends Number>> SIMPLE_FLOAT_TYPES = new HashSet<Class<? extends Number>>();
    protected static Log logger = LogFactory.getLog(BooleanOperations.class);

    private static final boolean lt0(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("lt0", o1, o2);
        Class<?> t1 = o1.getClass();
        Class<?> t2 = o2.getClass();
        if (BigDecimal.class.isAssignableFrom(t1) || BigDecimal.class.isAssignableFrom(t2)) {
            return converter.convert(o1, BigDecimal.class).compareTo(converter.convert(o2, BigDecimal.class)) < 0;
        }
        if (SIMPLE_FLOAT_TYPES.contains(t1) || SIMPLE_FLOAT_TYPES.contains(t2)) {
            return converter.convert(o1, Double.class) < converter.convert(o2, Double.class);
        }
        if (BigInteger.class.isAssignableFrom(t1) || BigInteger.class.isAssignableFrom(t2)) {
            return converter.convert(o1, BigInteger.class).compareTo(converter.convert(o2, BigInteger.class)) < 0;
        }
        if (SIMPLE_INTEGER_TYPES.contains(t1) || SIMPLE_INTEGER_TYPES.contains(t2)) {
            return converter.convert(o1, Long.class) < converter.convert(o2, Long.class);
        }
        if (t1 == String.class || t2 == String.class) {
            return converter.convert(o1, String.class).compareTo(converter.convert(o2, String.class)) < 0;
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2) < 0;
        }
        if (o2 instanceof Comparable) {
            return ((Comparable)o2).compareTo(o1) > 0;
        }
        throw new ELException(LocalMessages.get("error.compare.types", o1.getClass(), o2.getClass()));
    }

    private static final boolean gt0(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("gt0", o1, o2);
        Class<?> t1 = o1.getClass();
        Class<?> t2 = o2.getClass();
        if (BigDecimal.class.isAssignableFrom(t1) || BigDecimal.class.isAssignableFrom(t2)) {
            return converter.convert(o1, BigDecimal.class).compareTo(converter.convert(o2, BigDecimal.class)) > 0;
        }
        if (SIMPLE_FLOAT_TYPES.contains(t1) || SIMPLE_FLOAT_TYPES.contains(t2)) {
            return converter.convert(o1, Double.class) > converter.convert(o2, Double.class);
        }
        if (BigInteger.class.isAssignableFrom(t1) || BigInteger.class.isAssignableFrom(t2)) {
            return converter.convert(o1, BigInteger.class).compareTo(converter.convert(o2, BigInteger.class)) > 0;
        }
        if (SIMPLE_INTEGER_TYPES.contains(t1) || SIMPLE_INTEGER_TYPES.contains(t2)) {
            return converter.convert(o1, Long.class) > converter.convert(o2, Long.class);
        }
        if (t1 == String.class || t2 == String.class) {
            return converter.convert(o1, String.class).compareTo(converter.convert(o2, String.class)) > 0;
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2) > 0;
        }
        if (o2 instanceof Comparable) {
            return ((Comparable)o2).compareTo(o1) < 0;
        }
        throw new ELException(LocalMessages.get("error.compare.types", o1.getClass(), o2.getClass()));
    }

    public static final boolean lt(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("lt", o1, o2);
        if (o1 == o2) {
            return false;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return BooleanOperations.lt0(converter, o1, o2);
    }

    public static final boolean gt(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("gt", o1, o2);
        if (o1 == o2) {
            return false;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return BooleanOperations.gt0(converter, o1, o2);
    }

    public static final boolean ge(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("ge", o1, o2);
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return !BooleanOperations.lt0(converter, o1, o2);
    }

    public static final boolean le(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("le", o1, o2);
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return !BooleanOperations.gt0(converter, o1, o2);
    }

    public static final boolean eq(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("eq", o1, o2);
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> t1 = o1.getClass();
        Class<?> t2 = o2.getClass();
        if (BigDecimal.class.isAssignableFrom(t1) || BigDecimal.class.isAssignableFrom(t2)) {
            try {
                return converter.convert(o1, BigDecimal.class).compareTo(converter.convert(o2, BigDecimal.class)) == 0;
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        if (SIMPLE_FLOAT_TYPES.contains(t1) || SIMPLE_FLOAT_TYPES.contains(t2)) {
            try {
                return converter.convert(o1, Double.class).equals(converter.convert(o2, Double.class));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        if (BigInteger.class.isAssignableFrom(t1) || BigInteger.class.isAssignableFrom(t2)) {
            try {
                return converter.convert(o1, BigInteger.class).equals(converter.convert(o2, BigInteger.class));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        if (SIMPLE_INTEGER_TYPES.contains(t1) || SIMPLE_INTEGER_TYPES.contains(t2)) {
            try {
                return converter.convert(o1, Long.class).equals(converter.convert(o2, Long.class));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        if (t1 == Boolean.class || t2 == Boolean.class) {
            return converter.convert(o1, Boolean.class).equals(converter.convert(o2, Boolean.class));
        }
        if (o1 instanceof Enum) {
            return o1 == converter.convert(o2, o1.getClass());
        }
        if (o2 instanceof Enum) {
            return converter.convert(o1, o2.getClass()) == o2;
        }
        if (t1 == String.class || t2 == String.class) {
            String obj1 = converter.convert(o1, String.class);
            String obj2 = converter.convert(o2, String.class);
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null || obj2 == null) {
                return false;
            }
            return obj1.equals(obj2);
        }
        return o1.equals(o2);
    }

    public static final boolean ne(TypeConverter converter, Object o1, Object o2) {
        return !BooleanOperations.eq(converter, o1, o2);
    }

    public static final boolean empty(TypeConverter converter, Object o) {
        Collection c;
        BooleanOperations.dispatchLog("empty", o);
        if (o == null || o.toString() == null || "".equals(o.toString().trim()) || o instanceof Integer && (Integer)o == 0 || o instanceof Long && (Long)o == 0L || o instanceof BigDecimal && ((BigDecimal)o).compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length == 0;
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        return o instanceof Collection && (c = (Collection)o).isEmpty();
    }

    public static final boolean notempty(TypeConverter converter, Object o) {
        BooleanOperations.dispatchLog("notempty", o);
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return !"".equals(o.toString().trim());
        }
        if (o instanceof Integer && (Integer)o != 0 || o instanceof Long && (Long)o != 0L || o instanceof BigDecimal && ((BigDecimal)o).compareTo(BigDecimal.ZERO) != 0) {
            return true;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length != 0;
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            return !c.isEmpty();
        }
        return false;
    }

    public static final boolean like(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("like", o1, o2);
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof List) {
            o1 = BooleanOperations.listToString((List)o1);
        }
        if (o2 instanceof List) {
            o2 = BooleanOperations.listToString((List)o2);
        }
        Class<?> t1 = o1.getClass();
        Class<?> t2 = o2.getClass();
        if (t1 == String.class || t2 == String.class) {
            String obj1 = converter.convert(o1, String.class);
            String obj2 = converter.convert(o2, String.class);
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null || obj2 == null) {
                return false;
            }
            return obj1.contains(obj2);
        }
        return false;
    }

    private static String listToString(List<?> o1) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        for (Object o : o1) {
            sb.append(',').append(String.valueOf(o));
        }
        if (sb.length() > 0) {
            result = sb.substring(1);
        }
        return result;
    }

    public static final boolean notlike(TypeConverter converter, Object o1, Object o2) {
        BooleanOperations.dispatchLog("notlike", o1, o2);
        if (o1 == o2) {
            return false;
        }
        if (o1 == null || o2 == null) {
            return true;
        }
        if (o1 instanceof List) {
            o1 = BooleanOperations.listToString((List)o1);
        }
        if (o2 instanceof List) {
            o2 = BooleanOperations.listToString((List)o2);
        }
        Class<?> t1 = o1.getClass();
        Class<?> t2 = o2.getClass();
        if (t1 == String.class || t2 == String.class) {
            return !converter.convert(o1, String.class).contains(converter.convert(o2, String.class));
        }
        return true;
    }

    public static boolean expOperation(String symbol, TypeConverter converter, Object o1, Object o2) {
        return BooleanOperations.expOperation(symbol, converter, o1, o2, null);
    }

    private static void dispatchLog(Object ... args) {
        List<Object> params;
        if (args != null && (params = Arrays.asList(args)) != null && params.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Boolean-Method:[").append(params.get(0)).append("]Params:[");
            for (int i = 1; i < params.size(); ++i) {
                sb.append(params.get(i)).append(',');
                if (params.get(i) == null) continue;
                sb.append(params.get(i).getClass()).append(',');
            }
            sb.append(']');
            logger.info(sb.toString());
        }
    }

    public static boolean expOperation(String symbol, TypeConverter converter, Object o1, Object o2, ELContext context) {
        ExpBooleanOperation expBooleanOperation = ExpManagerUtils.getExpBooleanOperation();
        if (expBooleanOperation != null) {
            expBooleanOperation.setContext(context);
            return expBooleanOperation.operation(symbol, converter, o1, o2);
        }
        return false;
    }

    static {
        SIMPLE_INTEGER_TYPES.add(Byte.class);
        SIMPLE_INTEGER_TYPES.add(Short.class);
        SIMPLE_INTEGER_TYPES.add(Integer.class);
        SIMPLE_INTEGER_TYPES.add(Long.class);
        SIMPLE_FLOAT_TYPES.add(Float.class);
        SIMPLE_FLOAT_TYPES.add(Double.class);
    }
}

