/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.el.ELException;

public class TypeConverterImpl
implements TypeConverter {
    private static final long serialVersionUID = 1L;
    public static final String TILTE_ERRORTYPE = "error.coerce.type";
    public static final String TILTE_ERRORVALUE = "error.coerce.value";

    protected Boolean coerceToBoolean(Object value) {
        if (value == null || "".equals(value)) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("1".equalsIgnoreCase((String)value) || "0".equalsIgnoreCase((String)value)) {
                return "1".equalsIgnoreCase((String)value) ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Long) {
            return (Long)value == 1L ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), Boolean.class));
    }

    protected Character coerceToCharacter(Object value) {
        if (value == null || "".equals(value)) {
            return Character.valueOf('\u0000');
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof Number) {
            return Character.valueOf((char)((Number)value).shortValue());
        }
        if (value instanceof String) {
            return Character.valueOf(((String)value).charAt(0));
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), Character.class));
    }

    protected BigDecimal coerceToBigDecimal(Object value) {
        if (value == null || "".equals(value)) {
            return BigDecimal.valueOf(0L);
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), BigDecimal.class));
            }
        }
        if (value instanceof Character) {
            return new BigDecimal((short)((Character)value).charValue());
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), BigDecimal.class));
    }

    protected BigInteger coerceToBigInteger(Object value) {
        if (value == null || "".equals(value)) {
            return BigInteger.valueOf(0L);
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                return new BigInteger((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), BigInteger.class));
            }
        }
        if (value instanceof Character) {
            return BigInteger.valueOf((short)((Character)value).charValue());
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), BigInteger.class));
    }

    protected Double coerceToDouble(Object value) {
        if (value == null || "".equals(value)) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), Double.class));
            }
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), Double.class));
    }

    protected Float coerceToFloat(Object value) {
        if (value == null || "".equals(value)) {
            return Float.valueOf(0.0f);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            try {
                return Float.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), Float.class));
            }
        }
        if (value instanceof Character) {
            return Float.valueOf((short)((Character)value).charValue());
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), Float.class));
    }

    protected Long coerceToLong(Object value) {
        if (value == null || "".equals(value)) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), Long.class));
            }
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), Long.class));
    }

    protected Integer coerceToInteger(Object value) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), Integer.class));
            }
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), Integer.class));
    }

    protected Short coerceToShort(Object value) {
        if (value == null || "".equals(value)) {
            return (short)0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            try {
                return Short.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), Short.class));
            }
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), Short.class));
    }

    protected Byte coerceToByte(Object value) {
        if (value == null || "".equals(value)) {
            return (byte)0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), Byte.class));
            }
        }
        if (value instanceof Character) {
            return Byte.valueOf(String.valueOf(value));
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), Byte.class));
    }

    protected String coerceToString(Object value) {
        List vs;
        if (value == null) {
            return "";
        }
        if (value instanceof List && !(vs = (List)value).isEmpty() && vs.get(0) instanceof String) {
            StringBuilder sb = new StringBuilder();
            for (Object o : vs) {
                sb.append(',').append(o);
            }
            if (sb.length() > 0) {
                value = sb.substring(1);
            }
        }
        if (value instanceof String) {
            String valueStr = value.toString();
            if (valueStr.contains(",")) {
                List<String> v = Arrays.asList(valueStr.split(","));
                v.sort(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.hashCode() - o2.hashCode();
                    }
                });
                StringBuilder sb = new StringBuilder();
                for (String s : v) {
                    sb.append(s).append(',');
                }
                if (sb.length() > 0 && sb.toString().endsWith(",")) {
                    valueStr = sb.substring(0, sb.length() - 1);
                }
            }
            return valueStr;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value.toString();
    }

    protected <T extends Enum<T>> T coerceToEnum(Object value, Class<T> type) {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(type, (String)value);
            }
            catch (IllegalArgumentException e) {
                throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), type));
            }
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), type));
    }

    protected Object coerceStringToType(String value, Class<?> type) {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor == null) {
            if ("".equals(value)) {
                return null;
            }
            throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, String.class, type));
        }
        if ("".equals(value)) {
            try {
                editor.setAsText(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        try {
            editor.setAsText(value);
        }
        catch (IllegalArgumentException e) {
            throw new ELException(LocalMessages.get(TILTE_ERRORVALUE, value, value.getClass(), type));
        }
        return editor.getValue();
    }

    protected Object coerceToType(Object value, Class<?> type) {
        if (type == String.class) {
            return this.coerceToString(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return this.coerceToLong(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return this.coerceToDouble(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return this.coerceToBoolean(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return this.coerceToInteger(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return this.coerceToFloat(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return this.coerceToShort(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return this.coerceToByte(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return this.coerceToCharacter(value);
        }
        if (type == BigDecimal.class) {
            return this.coerceToBigDecimal(value);
        }
        if (type == BigInteger.class) {
            return this.coerceToBigInteger(value);
        }
        if (type.getSuperclass() == Enum.class) {
            return this.coerceToEnum(value, type);
        }
        if (value == null || value.getClass() == type || type.isInstance(value)) {
            return value;
        }
        if (value instanceof String) {
            return this.coerceStringToType((String)value, type);
        }
        throw new ELException(LocalMessages.get(TILTE_ERRORTYPE, value, value.getClass(), type));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public <T> T convert(Object value, Class<T> type) throws ELException {
        return (T)this.coerceToType(value, type);
    }
}

