/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.misc.LocalMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Scanner {
    private static final HashMap<String, Token> KEYMAP = new HashMap();
    private static final HashMap<Symbol, Token> FIXMAP = new HashMap();
    private static final List<String> customSymbolVal = new ArrayList<String>();
    private Token ftoken;
    private int position;
    private final String input;
    protected final StringBuilder builder = new StringBuilder();

    public static void setCustomSymbolVal(String val) {
        customSymbolVal.add(val);
    }

    public static List<String> getCustomSymbolVal() {
        return customSymbolVal;
    }

    public static void addFixToken(Token token) {
        FIXMAP.put(token.getSymbol(), token);
    }

    public static void addKeyToken(Token token) {
        KEYMAP.put(token.getImage(), token);
    }

    protected Scanner(String input) {
        this.input = input;
    }

    public String getInput() {
        return this.input;
    }

    public Token getToken() {
        return this.ftoken;
    }

    public int getPosition() {
        return this.position;
    }

    protected boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected Token keyword(String s) {
        return KEYMAP.get(s);
    }

    protected Token fixed(Symbol symbol) {
        return FIXMAP.get((Object)symbol);
    }

    protected Token token(Symbol symbol, String value, int length) {
        return new Token(symbol, value, length);
    }

    protected boolean isEval() {
        return this.ftoken != null && this.ftoken.getSymbol() != Symbol.TEXT && this.ftoken.getSymbol() != Symbol.END_EVAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token nextText() throws ScanException {
        int i;
        this.builder.setLength(0);
        int l = this.input.length();
        boolean escaped = false;
        block4: for (i = this.position; i < l; ++i) {
            char c = this.input.charAt(i);
            switch (c) {
                case '\\': {
                    if (escaped) {
                        this.builder.append('\\');
                        continue block4;
                    }
                    escaped = true;
                    continue block4;
                }
                case '#': 
                case '$': {
                    if (i + 1 < l && this.input.charAt(i + 1) == '{') {
                        if (!escaped) return this.token(Symbol.TEXT, this.builder.toString(), i - this.position);
                        this.builder.append(c);
                    } else {
                        if (escaped) {
                            this.builder.append('\\');
                        }
                        this.builder.append(c);
                    }
                    escaped = false;
                    continue block4;
                }
                default: {
                    if (escaped) {
                        this.builder.append('\\');
                    }
                    this.builder.append(c);
                    escaped = false;
                }
            }
        }
        if (!escaped) return this.token(Symbol.TEXT, this.builder.toString(), i - this.position);
        this.builder.append('\\');
        return this.token(Symbol.TEXT, this.builder.toString(), i - this.position);
    }

    protected Token nextString() throws ScanException {
        this.builder.setLength(0);
        char quote = this.input.charAt(this.position);
        int i = this.position + 1;
        int l = this.input.length();
        while (i < l) {
            char c;
            if ((c = this.input.charAt(i++)) == '\\') {
                if (i == l) {
                    throw new ScanException(this.position, "unterminated string", quote + " or \\");
                }
                if ((c = this.input.charAt(i++)) == '\\' || c == quote) {
                    this.builder.append(c);
                    continue;
                }
                throw new ScanException(this.position, "invalid escape sequence \\" + c, "\\" + quote + " or \\\\");
            }
            if (c == quote) {
                return this.token(Symbol.STRING, this.builder.toString(), i - this.position);
            }
            this.builder.append(c);
        }
        throw new ScanException(this.position, "unterminated string", String.valueOf(quote));
    }

    protected Token nextNumber() throws ScanException {
        int i;
        int l = this.input.length();
        for (i = this.position; i < l && this.isDigit(this.input.charAt(i)); ++i) {
        }
        Symbol symbol = Symbol.INTEGER;
        if (i < l && this.input.charAt(i) == '.') {
            ++i;
            while (i < l && this.isDigit(this.input.charAt(i))) {
                ++i;
            }
            symbol = Symbol.FLOAT;
        }
        if (i < l && (this.input.charAt(i) == 'e' || this.input.charAt(i) == 'E')) {
            int e = i++;
            if (i < l && (this.input.charAt(i) == '+' || this.input.charAt(i) == '-')) {
                ++i;
            }
            if (i < l && this.isDigit(this.input.charAt(i))) {
                ++i;
                while (i < l && this.isDigit(this.input.charAt(i))) {
                    ++i;
                }
                symbol = Symbol.FLOAT;
            } else {
                i = e;
            }
        }
        return this.token(symbol, this.input.substring(this.position, i), i - this.position);
    }

    protected boolean judgeNextIsNumber(int i, int l) throws ScanException {
        while (i < l && this.isDigit(this.input.charAt(i))) {
            ++i;
        }
        if (i < l && this.input.charAt(i) == '.') {
            ++i;
            while (i < l && this.isDigit(this.input.charAt(i))) {
                ++i;
            }
        }
        if (i < l && (this.input.charAt(i) == 'e' || this.input.charAt(i) == 'E')) {
            int e = i++;
            if (i < l && (this.input.charAt(i) == '+' || this.input.charAt(i) == '-')) {
                ++i;
            }
            if (i < l && this.isDigit(this.input.charAt(i))) {
                ++i;
                while (i < l && this.isDigit(this.input.charAt(i))) {
                    ++i;
                }
            } else {
                i = e;
            }
        }
        return i >= l || '.' == this.input.charAt(i) || ' ' == this.input.charAt(i) || '}' == this.input.charAt(i);
    }

    protected Token nextEval() throws ScanException {
        char c1 = this.input.charAt(this.position);
        char c2 = this.position < this.input.length() - 1 ? this.input.charAt(this.position + 1) : (char)'\u0000';
        char c3 = this.position < this.input.length() - 2 ? this.input.charAt(this.position + 2) : (char)'\u0000';
        switch (c1) {
            case '*': {
                return this.fixed(Symbol.MUL);
            }
            case '/': {
                return this.fixed(Symbol.DIV);
            }
            case '%': {
                return this.fixed(Symbol.MOD);
            }
            case '+': {
                return this.fixed(Symbol.PLUS);
            }
            case '-': {
                return this.fixed(Symbol.MINUS);
            }
            case '?': {
                return this.fixed(Symbol.QUESTION);
            }
            case ':': {
                return this.fixed(Symbol.COLON);
            }
            case '[': {
                return this.fixed(Symbol.LBRACK);
            }
            case ']': {
                return this.fixed(Symbol.RBRACK);
            }
            case '(': {
                return this.fixed(Symbol.LPAREN);
            }
            case ')': {
                return this.fixed(Symbol.RPAREN);
            }
            case ',': {
                return this.fixed(Symbol.COMMA);
            }
            case '.': {
                if (this.ftoken.symbol != Symbol.IDENTIFIER) break;
                return this.fixed(Symbol.DOT);
            }
            case '=': {
                if (c2 != '=') break;
                return this.fixed(Symbol.EQ);
            }
            case '&': {
                if (c2 != '&') break;
                return this.fixed(Symbol.AND);
            }
            case '|': {
                if (c2 != '|') break;
                return this.fixed(Symbol.OR);
            }
            case '!': {
                if (c2 == '=') {
                    return this.fixed(Symbol.NE);
                }
                return this.fixed(Symbol.NOT);
            }
            case '<': {
                if (c2 == '=') {
                    return this.fixed(Symbol.LE);
                }
                return this.fixed(Symbol.LT);
            }
            case '>': {
                if (c2 == '=') {
                    return this.fixed(Symbol.GE);
                }
                return this.fixed(Symbol.GT);
            }
            case 'L': {
                if (!this.isCustomCompare(c2, c3, 'K')) break;
                return this.fixed(Symbol.LK);
            }
            case 'I': {
                if (!this.isCustomCompare(c2, c3, 'N')) break;
                return this.fixed(Symbol.CBL);
            }
            case 'N': {
                if (this.isCustomCompare(c2, c3, 'L')) {
                    return this.fixed(Symbol.NL);
                }
                if (this.isCustomCompare(c2, c3, 'B')) {
                    return this.fixed(Symbol.NB);
                }
                if (this.isCustomCompare(c2, c3, 'I')) {
                    return this.fixed(Symbol.CNB);
                }
                if (this.isCustomCompare(c2, c3, 'C')) {
                    return this.fixed(Symbol.CNL);
                }
                if (!this.isCustomCompare(c2, c3, 'R')) break;
                return this.fixed(Symbol.NR);
            }
            case 'B': {
                if (this.isCustomCompare(c2, c3, 'S')) {
                    return this.fixed(Symbol.BS);
                }
                if (this.isCustomCompare(c2, c3, 'O')) {
                    return this.fixed(Symbol.BO);
                }
                if (this.isCustomCompare(c2, c3, 'R')) {
                    return this.fixed(Symbol.BR);
                }
                if (!this.isCustomCompare(c2, c3, 'L')) break;
                return this.fixed(Symbol.BL);
            }
            case 'C': {
                if (this.isCustomCompare(c2, c3, 'S')) {
                    return this.fixed(Symbol.CS);
                }
                if (!this.isCustomCompare(c2, c3, 'L')) break;
                return this.fixed(Symbol.CLK);
            }
            case '\"': 
            case '\'': {
                return this.nextString();
            }
        }
        String customSymbol = this.getSymbolDetail();
        if (!"".equals(customSymbol) && customSymbolVal.contains(customSymbol)) {
            return this.fixed(Symbol.valueOf(customSymbol));
        }
        Boolean isNumber = null;
        if ((this.isDigit(c1) || c1 == '.') && (isNumber = Boolean.valueOf(this.judgeNextIsNumber(this.position, this.input.length()))).booleanValue()) {
            return this.nextNumber();
        }
        if (Character.isJavaIdentifierStart(c1) || isNumber != null && !isNumber.booleanValue()) {
            int i;
            int l = this.input.length();
            for (i = this.position + 1; i < l && Character.isJavaIdentifierPart(this.input.charAt(i)); ++i) {
            }
            String name = this.input.substring(this.position, i);
            Token keyword = this.keyword(name);
            return keyword == null ? this.token(Symbol.IDENTIFIER, name, i - this.position) : keyword;
        }
        throw new ScanException(this.position, "invalid character '" + c1 + "'", "expression token");
    }

    private String getSymbolDetail() {
        String positionString = this.input.substring(this.position, this.input.length());
        String[] symbolDetails = positionString.split("\\s+");
        return symbolDetails.length > 0 ? symbolDetails[0] : "";
    }

    private boolean isCustomCompare(char c2, char c3, char c2Target) {
        return c2 == c2Target && Character.isSpaceChar(c3);
    }

    protected Token nextToken() throws ScanException {
        if (this.isEval()) {
            if (this.input.charAt(this.position) == '}') {
                return this.fixed(Symbol.END_EVAL);
            }
            return this.nextEval();
        }
        if (this.position + 1 < this.input.length() && this.input.charAt(this.position + 1) == '{') {
            switch (this.input.charAt(this.position)) {
                case '#': {
                    return this.fixed(Symbol.START_EVAL_DEFERRED);
                }
                case '$': {
                    return this.fixed(Symbol.START_EVAL_DYNAMIC);
                }
            }
        }
        return this.nextText();
    }

    public Token next() throws ScanException {
        if (this.ftoken != null) {
            this.position += this.ftoken.getSize();
        }
        int length = this.input.length();
        if (this.isEval()) {
            while (this.position < length && Character.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
        }
        if (this.position == length) {
            this.ftoken = this.fixed(Symbol.EOF);
            return this.ftoken;
        }
        this.ftoken = this.nextToken();
        return this.ftoken;
    }

    static {
        Scanner.addFixToken(new Token(Symbol.PLUS, "+"));
        Scanner.addFixToken(new Token(Symbol.MINUS, "-"));
        Scanner.addFixToken(new Token(Symbol.MUL, "*"));
        Scanner.addFixToken(new Token(Symbol.DIV, "/"));
        Scanner.addFixToken(new Token(Symbol.MOD, "%"));
        Scanner.addFixToken(new Token(Symbol.LPAREN, "("));
        Scanner.addFixToken(new Token(Symbol.RPAREN, ")"));
        Scanner.addFixToken(new Token(Symbol.NOT, "!"));
        Scanner.addFixToken(new Token(Symbol.AND, "&&"));
        Scanner.addFixToken(new Token(Symbol.OR, "||"));
        Scanner.addFixToken(new Token(Symbol.EQ, "=="));
        Scanner.addFixToken(new Token(Symbol.NE, "!="));
        Scanner.addFixToken(new Token(Symbol.LT, "<"));
        Scanner.addFixToken(new Token(Symbol.LE, "<="));
        Scanner.addFixToken(new Token(Symbol.GT, ">"));
        Scanner.addFixToken(new Token(Symbol.GE, ">="));
        Scanner.addFixToken(new Token(Symbol.LK, "LK"));
        Scanner.addFixToken(new Token(Symbol.NL, "NL"));
        Scanner.addFixToken(new Token(Symbol.BL, "BL"));
        Scanner.addFixToken(new Token(Symbol.NB, "NB"));
        Scanner.addFixToken(new Token(Symbol.CLK, "CL"));
        Scanner.addFixToken(new Token(Symbol.CNL, "NC"));
        Scanner.addFixToken(new Token(Symbol.CBL, "IN"));
        Scanner.addFixToken(new Token(Symbol.CNB, "NI"));
        Scanner.addFixToken(new Token(Symbol.BS, "BS"));
        Scanner.addFixToken(new Token(Symbol.CS, "CS"));
        Scanner.addFixToken(new Token(Symbol.BO, "BO"));
        Scanner.addFixToken(new Token(Symbol.BR, "BR"));
        Scanner.addFixToken(new Token(Symbol.NR, "NR"));
        Scanner.addFixToken(new Token(Symbol.QUESTION, "?"));
        Scanner.addFixToken(new Token(Symbol.COLON, ":"));
        Scanner.addFixToken(new Token(Symbol.COMMA, ","));
        Scanner.addFixToken(new Token(Symbol.DOT, "."));
        Scanner.addFixToken(new Token(Symbol.LBRACK, "["));
        Scanner.addFixToken(new Token(Symbol.RBRACK, "]"));
        Scanner.addFixToken(new Token(Symbol.START_EVAL_DEFERRED, "#{"));
        Scanner.addFixToken(new Token(Symbol.START_EVAL_DYNAMIC, "${"));
        Scanner.addFixToken(new Token(Symbol.END_EVAL, "}"));
        Scanner.addFixToken(new Token(Symbol.EOF, null, 0));
        Scanner.addFixToken(new Token(Symbol.BXWF, "BXWF"));
        Scanner.addFixToken(new Token(Symbol.NBWF, "NBWF"));
        Scanner.addFixToken(new Token(Symbol.BT, "BT"));
        Scanner.addFixToken(new Token(Symbol.NBT, "NBT"));
        Scanner.addFixToken(new Token(Symbol.CAL, "CAL"));
        Scanner.addFixToken(new Token(Symbol.CAY, "CAY"));
        Scanner.addFixToken(new Token(Symbol.NOTC, "NOTC"));
        Scanner.addFixToken(new Token(Symbol.ANI, "ANI"));
        Scanner.addFixToken(new Token(Symbol.ALEQ, "ALEQ"));
        Scanner.addFixToken(new Token(Symbol.ANEQ, "ANEQ"));
        Scanner.addFixToken(new Token(Symbol.ALGT, "ALGT"));
        Scanner.addFixToken(new Token(Symbol.ANGT, "ANGT"));
        Scanner.addFixToken(new Token(Symbol.ALLT, "ALLT"));
        Scanner.addFixToken(new Token(Symbol.ANLT, "ANLT"));
        Scanner.addKeyToken(new Token(Symbol.NULL, "null"));
        Scanner.addKeyToken(new Token(Symbol.TRUE, "true"));
        Scanner.addKeyToken(new Token(Symbol.FALSE, "false"));
        Scanner.addKeyToken(new Token(Symbol.EMPTY, "empty"));
        Scanner.addKeyToken(new Token(Symbol.NOTEMPTY, "notempty"));
        Scanner.addKeyToken(new Token(Symbol.DIV, "div"));
        Scanner.addKeyToken(new Token(Symbol.MOD, "mod"));
        Scanner.addKeyToken(new Token(Symbol.NOT, "not"));
        Scanner.addKeyToken(new Token(Symbol.AND, "and"));
        Scanner.addKeyToken(new Token(Symbol.OR, "or"));
        Scanner.addKeyToken(new Token(Symbol.LE, "le"));
        Scanner.addKeyToken(new Token(Symbol.LT, "lt"));
        Scanner.addKeyToken(new Token(Symbol.EQ, "eq"));
        Scanner.addKeyToken(new Token(Symbol.NE, "ne"));
        Scanner.addKeyToken(new Token(Symbol.GE, "ge"));
        Scanner.addKeyToken(new Token(Symbol.GT, "gt"));
        Scanner.addKeyToken(new Token(Symbol.INSTANCEOF, "instanceof"));
    }

    public static enum Symbol {
        EOF,
        PLUS("'+'"),
        MINUS("'-'"),
        MUL("'*'"),
        DIV("'/'|'div'"),
        MOD("'%'|'mod'"),
        LPAREN("'('"),
        RPAREN("')'"),
        IDENTIFIER,
        NOT("'!'|'not'"),
        AND("'&&'|'and'"),
        OR("'||'|'or'"),
        NOTEMPTY("'notempty'"),
        EMPTY("'empty'"),
        INSTANCEOF("'instanceof'"),
        INTEGER,
        FLOAT,
        TRUE("'true'"),
        FALSE("'false'"),
        STRING,
        NULL("'null'"),
        LE("'<='|'le'"),
        LT("'<'|'lt'"),
        GE("'>='|'ge'"),
        GT("'>'|'gt'"),
        EQ("'=='|'eq'"),
        NE("'!='|'ne'"),
        LK("'LK'"),
        NL("'NL'"),
        CLK("'CL'"),
        CNL("'NC'"),
        BL("'BL'"),
        NB("'NB'"),
        CBL("'IN'"),
        CNB("'NI'"),
        BS("'BS'"),
        CS("'CS'"),
        BO("'BO'"),
        BR("'BR'"),
        NR("'NR'"),
        QUESTION("'?'"),
        COLON("':'"),
        TEXT,
        DOT("'.'"),
        LBRACK("'['"),
        RBRACK("']'"),
        COMMA("','"),
        BXWF("'BXWF'"),
        NBWF("'NBWF'"),
        BT("'BT'"),
        NBT("'NBT'"),
        CAL("'CAL'"),
        CAY("'CAY'"),
        NOTC("'NOTC'"),
        ANI("'ANI'"),
        ALEQ("'ALEQ'"),
        ANEQ("'ANEQ'"),
        ALGT("'ALGT'"),
        ANGT("'ANGT'"),
        ALLT("'ALLT'"),
        ANLT("'ANLT'"),
        START_EVAL_DEFERRED("'#{'"),
        START_EVAL_DYNAMIC("'${'"),
        END_EVAL("'}'"),
        EXTENSION;

        private final String string;

        private Symbol() {
            this(null);
        }

        private Symbol(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string == null ? "<" + this.name() + ">" : this.string;
        }

        public String getString() {
            return this.string;
        }
    }

    public static class ExtensionToken
    extends Token {
        public ExtensionToken(String image) {
            super(Symbol.EXTENSION, image);
        }
    }

    public static class Token {
        private final Symbol symbol;
        private final String image;
        private final int length;

        public Token(Symbol symbol, String image) {
            this(symbol, image, image.length());
        }

        public Token(Symbol symbol, String image, int length) {
            this.symbol = symbol;
            this.image = image;
            this.length = length;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public String getImage() {
            return this.image;
        }

        public int getSize() {
            return this.length;
        }

        public String toString() {
            return this.symbol.toString();
        }
    }

    public static class ScanException
    extends Exception {
        public final int position;
        public final String encountered;
        public final String expected;

        public ScanException(int position, String encountered, String expected) {
            super(LocalMessages.get("error.scan", position, encountered, expected));
            this.position = position;
            this.encountered = encountered;
            this.expected = expected;
        }
    }
}

