/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.function.collection.CollectionFunctionType;
import de.odysseus.el.misc.BooleanOperations;
import de.odysseus.el.misc.NumberOperations;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.pojo.EntryContextPojo;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstFunction;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstParameters;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import de.odysseus.el.tree.impl.ast.AstString;
import de.odysseus.el.util.ELResolverUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang.exception.ExceptionUtils;

public class AstBinary
extends AstRightValue {
    protected static Log logger = LogFactory.getLog(AstBinary.class);
    public static final Operator ADD = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return NumberOperations.add(converter, o1, o2);
        }

        public String toString() {
            return "+";
        }
    };
    public static final Operator AND = new Operator(){

        @Override
        public Object eval(Bindings bindings, ELContext context, AstNode left, AstNode right) {
            Boolean l = bindings.convert(left.eval(bindings, context), Boolean.class);
            return Boolean.TRUE.equals(l) ? bindings.convert(right.eval(bindings, context), Boolean.class) : Boolean.FALSE;
        }

        public String toString() {
            return "&&";
        }
    };
    public static final Operator DIV = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return NumberOperations.div(converter, o1, o2);
        }

        public String toString() {
            return "/";
        }
    };
    public static final Operator EQ = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.eq(converter, o1, o2);
        }

        public String toString() {
            return "==";
        }
    };
    public static final Operator GE = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.ge(converter, o1, o2);
        }

        public String toString() {
            return ">=";
        }
    };
    public static final Operator GT = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.gt(converter, o1, o2);
        }

        public String toString() {
            return ">";
        }
    };
    public static final Operator LE = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.le(converter, o1, o2);
        }

        public String toString() {
            return "<=";
        }
    };
    public static final Operator LT = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.lt(converter, o1, o2);
        }

        public String toString() {
            return "<";
        }
    };
    public static final Operator MOD = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return NumberOperations.mod(converter, o1, o2);
        }

        public String toString() {
            return "%";
        }
    };
    public static final Operator MUL = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return NumberOperations.mul(converter, o1, o2);
        }

        public String toString() {
            return "*";
        }
    };
    public static final Operator NE = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.ne(converter, o1, o2);
        }

        public String toString() {
            return "!=";
        }
    };
    public static final Operator OR = new Operator(){

        @Override
        public Object eval(Bindings bindings, ELContext context, AstNode left, AstNode right) {
            Boolean l = bindings.convert(left.eval(bindings, context), Boolean.class);
            return Boolean.TRUE.equals(l) ? Boolean.TRUE : bindings.convert(right.eval(bindings, context), Boolean.class);
        }

        public String toString() {
            return "||";
        }
    };
    public static final Operator SUB = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return NumberOperations.sub(converter, o1, o2);
        }

        public String toString() {
            return "-";
        }
    };
    public static final Operator LK = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.like(converter, o1, o2);
        }

        public String toString() {
            return "LK";
        }
    };
    public static final Operator NL = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.notlike(converter, o1, o2);
        }

        public String toString() {
            return "NL";
        }
    };
    public static final Operator BL = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("BL", converter, o1, o2);
        }

        public String toString() {
            return "BL";
        }
    };
    public static final Operator NB = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("NB", converter, o1, o2);
        }

        public String toString() {
            return "NB";
        }
    };
    public static final Operator CLK = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("CL", converter, o1, o2);
        }

        public String toString() {
            return "CL";
        }
    };
    public static final Operator CNL = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("NC", converter, o1, o2);
        }

        public String toString() {
            return "NC";
        }
    };
    public static final Operator CBL = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("IN", converter, o1, o2);
        }

        public String toString() {
            return "IN";
        }
    };
    public static final Operator CNB = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("NI", converter, o1, o2);
        }

        public String toString() {
            return "NI";
        }
    };
    public static final Operator BS = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("BS", converter, o1, o2);
        }

        public String toString() {
            return "BS";
        }
    };
    public static final Operator CS = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("CS", converter, o1, o2);
        }

        public String toString() {
            return "CS";
        }
    };
    public static final Operator BO = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("BO", converter, o1, o2);
        }

        public String toString() {
            return "BO";
        }
    };
    public static final Operator BR = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("BR", converter, o1, o2);
        }

        public String toString() {
            return "BR";
        }
    };
    public static final Operator NR = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("NR", converter, o1, o2);
        }

        public String toString() {
            return "NR";
        }
    };
    public static final Operator BT = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("BT", converter, o1, o2, context);
        }

        public String toString() {
            return "BT";
        }
    };
    public static final Operator NOTBT = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("NBT", converter, o1, o2, context);
        }

        public String toString() {
            return "NBT";
        }
    };
    public static final Operator BTU = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("BTU", converter, o1, o2);
        }

        public String toString() {
            return "BTU";
        }
    };
    public static final Operator NOTBTU = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2, ELContext context) {
            return BooleanOperations.expOperation("NBTU", converter, o1, o2);
        }

        public String toString() {
            return "NBTU";
        }
    };
    private final Operator operator;
    private final AstNode left;
    private final AstNode right;

    public AstBinary(AstNode left, AstNode right, Operator operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Object obj = this.operator.eval(bindings, context, this.left, this.right);
        this.setLogVal(obj, context);
        return obj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append('\'').append(this.operator).append('\'').toString();
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        this.left.appendStructure(b, bindings);
        b.append(' ');
        b.append(this.operator);
        b.append(' ');
        this.right.appendStructure(b, bindings);
    }

    @Override
    public void appendLogStructure(StringBuilder b, Bindings bindings, ELContext context) {
        Object logVal;
        boolean linkOp;
        this.left.appendLogStructure(b, bindings, context);
        b.append(' ');
        b.append(this.operator);
        b.append(' ');
        this.right.appendLogStructure(b, bindings, context);
        String str = this.operator.toString();
        boolean bl = linkOp = OR.toString().equalsIgnoreCase(str) || AND.toString().equalsIgnoreCase(str);
        if (!linkOp && (logVal = ELResolverUtil.getLogValue(context, this)) != null) {
            b.append(String.format("[%s]", logVal));
        }
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.left : (i == 1 ? this.right : null);
    }

    public AstNode getLeft() {
        return this.left;
    }

    public AstNode getRight() {
        return this.right;
    }

    public static abstract class SimpleOperator
    implements Operator {
        /*
         * Enabled aggressive block sorting
         */
        public boolean evelEntryValue(Bindings bindings, ELContext context, AstNode left, AstNode right, String entryLocation, int indexEntry) {
            Object rightVal;
            List entryProps = (List)context.getContext(AstNode.class);
            if (indexEntry <= entryProps.size() - 1) {
                String prefixStr = (String)entryProps.get(indexEntry);
                EntryContextPojo pojo = null;
                if ("left".equals(entryLocation)) {
                    AstDot leftDot = null;
                    leftDot = left instanceof AstFunction ? this.resolveFunctionEntry(left, leftDot) : (AstDot)left;
                    if (leftDot != null) {
                        pojo = leftDot.markEntryAndSetContextEntryValue(bindings, context, prefixStr);
                    }
                } else {
                    AstDot rightDot = null;
                    rightDot = right instanceof AstFunction ? this.resolveFunctionEntry(right, rightDot) : (AstDot)right;
                    if (rightDot != null) {
                        pojo = rightDot.markEntryAndSetContextEntryValue(bindings, context, prefixStr);
                    }
                }
                if (pojo != null && pojo.getEntry() != null && !pojo.getEntry().isEmpty()) {
                    int tmp = indexEntry + 1;
                    Iterator iterator = pojo.getEntry().iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        DynamicObject i = (DynamicObject)iterator.next();
                        pojo.setEntryItem(i);
                    } while (!this.evelEntryValue(bindings, context, left, right, entryLocation, tmp));
                    return true;
                }
                Object leftVal = null;
                Object rightVal2 = null;
                if ("left".equals(entryLocation)) {
                    if (right == null) return (Boolean)this.apply(bindings, leftVal, rightVal2, context);
                    rightVal2 = this.getVal(bindings, context, right);
                    return (Boolean)this.apply(bindings, leftVal, rightVal2, context);
                }
                if (left == null) return (Boolean)this.apply(bindings, leftVal, rightVal2, context);
                leftVal = this.getVal(bindings, context, left);
                return (Boolean)this.apply(bindings, leftVal, rightVal2, context);
            }
            Object leftVal = this.getVal(bindings, context, left);
            boolean result = (Boolean)this.apply(bindings, leftVal, rightVal = this.getVal(bindings, context, right), context);
            if (result) {
                return result;
            }
            entryProps = (List)context.getContext(AstNode.class);
            if (indexEntry > entryProps.size() - 1) return false;
            return this.evelEntryValue(bindings, context, left, right, entryLocation, indexEntry);
        }

        @Override
        public Object eval(Bindings bindings, ELContext context, AstNode left, AstNode right) {
            Object leftVal = null;
            Object rightVal = null;
            Object obj = null;
            AstDot leftDot = null;
            AstDot rightDot = null;
            if (left instanceof AstDot) {
                leftDot = (AstDot)left;
            } else if (left instanceof AstFunction && !CollectionFunctionType.isContain(((AstFunction)left).getName())) {
                leftDot = this.resolveFunctionEntry(left, leftDot);
            }
            if (right instanceof AstDot) {
                rightDot = (AstDot)right;
            } else if (right instanceof AstFunction && !CollectionFunctionType.isContain(((AstFunction)right).getName())) {
                rightDot = this.resolveFunctionEntry(right, rightDot);
            }
            if (leftDot != null || rightDot != null) {
                List entryProps;
                String entryLocation = "";
                if (leftDot != null) {
                    leftDot.markEntryAndSetContextEntryValue(bindings, context, null);
                }
                if (((entryProps = (List)context.getContext(AstNode.class)) == null || entryProps.isEmpty()) && rightDot != null) {
                    rightDot.markEntryAndSetContextEntryValue(bindings, context, null);
                } else {
                    entryLocation = "left";
                }
                entryProps = (List)context.getContext(AstNode.class);
                if (entryProps != null && !entryProps.isEmpty()) {
                    try {
                        boolean flag = this.evelEntryValue(bindings, context, left, right, entryLocation, 0);
                        Boolean bl = flag;
                        return bl;
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("expression parse error :\r\n");
                        sb.append("entryList= [");
                        sb.append(entryProps).append("]\r\n");
                        if (context.getContext(EntryContextPojo.class) != null) {
                            sb.append("EntryContextPojo= [");
                            sb.append(context.getContext(EntryContextPojo.class)).append("]\r\n");
                        }
                        sb.append(ExceptionUtils.getStackTrace((Throwable)e));
                        logger.info(sb.toString());
                        throw e;
                    }
                    finally {
                        context.putContext(AstNode.class, new ArrayList());
                        context.putContext(EntryContextPojo.class, new HashMap());
                    }
                }
            }
            leftVal = this.getVal(bindings, context, left);
            rightVal = this.getVal(bindings, context, right);
            obj = this.apply(bindings, leftVal, rightVal, context);
            return obj;
        }

        private AstDot resolveFunctionEntry(AstNode left, AstDot leftDot) {
            AstParameters parameters = ((AstFunction)left).getParameters();
            if (parameters != null) {
                List<AstNode> nodes = parameters.getNodes();
                for (AstNode node : nodes) {
                    if (!(node instanceof AstDot)) continue;
                    leftDot = (AstDot)node;
                }
            }
            return leftDot;
        }

        private Object getVal(Bindings bindings, ELContext context, AstNode node) {
            String exp = node.getStructuralId(bindings);
            ELResolverUtil.setCurrentProp(exp, context);
            Object val = node.eval(bindings, context);
            if (!(node instanceof AstString)) {
                node.setLogVal(val, context);
            }
            ELResolverUtil.clearCurrentProp(context);
            return val;
        }

        protected abstract Object apply(TypeConverter var1, Object var2, Object var3, ELContext var4);
    }

    @FunctionalInterface
    public static interface Operator {
        public Object eval(Bindings var1, ELContext var2, AstNode var3, AstNode var4);
    }
}

