/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;

public class AstComposite
extends AstRightValue {
    private final List<AstNode> nodes;

    public AstComposite(List<AstNode> nodes) {
        ArrayList<AstNode> tmp = new ArrayList<AstNode>(nodes.size());
        for (AstNode n : nodes) {
            tmp.add(n);
        }
        this.nodes = tmp;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        StringBuilder b = new StringBuilder(16);
        for (int i = 0; i < this.getCardinality(); ++i) {
            b.append(bindings.convert(this.nodes.get(i).eval(bindings, context), String.class));
        }
        return b.toString();
    }

    public String toString() {
        return "composite";
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        for (int i = 0; i < this.getCardinality(); ++i) {
            this.nodes.get(i).appendStructure(b, bindings);
        }
    }

    @Override
    public void appendLogStructure(StringBuilder b, Bindings bindings, ELContext context) {
        for (int i = 0; i < this.getCardinality(); ++i) {
            this.nodes.get(i).appendLogStructure(b, bindings, context);
        }
    }

    @Override
    public int getCardinality() {
        return this.nodes.size();
    }

    @Override
    public AstNode getChild(int i) {
        return this.nodes.get(i);
    }
}

