/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import javax.el.ELContext;
import javax.el.MethodInfo;
import javax.el.ValueReference;

public final class AstEval
extends AstNode {
    private final AstNode child;
    private final boolean deferred;

    public AstEval(AstNode child, boolean deferred) {
        this.child = child;
        this.deferred = deferred;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    @Override
    public boolean isLeftValue() {
        return this.getChild(0).isLeftValue();
    }

    @Override
    public boolean isMethodInvocation() {
        return this.getChild(0).isMethodInvocation();
    }

    @Override
    public ValueReference getValueReference(Bindings bindings, ELContext context) {
        return this.child.getValueReference(bindings, context);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Object obj = this.child.eval(bindings, context);
        this.setLogVal(obj, context);
        return obj;
    }

    public String toString() {
        return (this.deferred ? "#" : "$") + "{...}";
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(this.deferred ? "#{" : "${");
        this.child.appendStructure(b, bindings);
        b.append('}');
    }

    @Override
    public void appendLogStructure(StringBuilder b, Bindings bindings, ELContext context) {
        b.append(this.deferred ? "#{" : "${");
        this.child.appendLogStructure(b, bindings, context);
        b.append('}');
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        return this.child.getMethodInfo(bindings, context, returnType, paramTypes);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] paramValues) {
        return this.child.invoke(bindings, context, returnType, paramTypes, paramValues);
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        return this.child.getType(bindings, context);
    }

    @Override
    public boolean isLiteralText() {
        return this.child.isLiteralText();
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) {
        return this.child.isReadOnly(bindings, context);
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) {
        this.child.setValue(bindings, context, value);
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.child : null;
    }
}

