/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.context.WFElContext;
import de.odysseus.el.function.ArgsDescription;
import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstParameters;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import de.odysseus.el.util.ELResolverUtil;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ELException;

public class AstFunction
extends AstRightValue
implements FunctionNode {
    private final int index;
    private final String name;
    private final AstParameters params;
    private final boolean varargs;

    public AstFunction(String name, int index, AstParameters params) {
        this(name, index, params, false);
    }

    public AstFunction(String name, int index, AstParameters params, boolean varargs) {
        this.name = name;
        this.index = index;
        this.params = params;
        this.varargs = varargs;
    }

    protected Object invoke(Bindings bindings, ELContext context, Object base, Method method) throws InvocationTargetException, IllegalAccessException {
        Object[] methodParams;
        block12: {
            ArrayList<ArgsDescription> argsDescs;
            Class<?>[] types;
            block13: {
                types = method.getParameterTypes();
                methodParams = null;
                argsDescs = new ArrayList<ArgsDescription>();
                if (types.length <= 0) break block12;
                methodParams = new Object[types.length];
                if (!this.varargs || !method.isVarArgs()) break block13;
                for (int i = 0; i < methodParams.length - 1; ++i) {
                    Object param = this.getParam(i).eval(bindings, context);
                    if (param == null && !types[i].isPrimitive()) continue;
                    methodParams[i] = bindings.convert(param, types[i]);
                }
                int varargIndex = types.length - 1;
                Class<?> varargType = types[varargIndex].getComponentType();
                int length = this.getParamCount() - varargIndex;
                Object array = null;
                if (length == 1) {
                    Object param = this.getParam(varargIndex).eval(bindings, context);
                    if (param != null && param.getClass().isArray()) {
                        if (types[varargIndex].isInstance(param)) {
                            array = param;
                        } else {
                            length = Array.getLength(param);
                            array = Array.newInstance(varargType, length);
                            for (int i = 0; i < length; ++i) {
                                Object elem = Array.get(param, i);
                                if (elem == null && !varargType.isPrimitive()) continue;
                                Array.set(array, i, bindings.convert(elem, varargType));
                            }
                        }
                    } else {
                        array = Array.newInstance(varargType, 1);
                        if (param != null || varargType.isPrimitive()) {
                            Array.set(array, 0, bindings.convert(param, varargType));
                        }
                    }
                } else {
                    array = Array.newInstance(varargType, length);
                    for (int i = 0; i < length; ++i) {
                        Object param = this.getParam(varargIndex + i).eval(bindings, context);
                        if (param == null && !varargType.isPrimitive()) continue;
                        Array.set(array, i, bindings.convert(param, varargType));
                    }
                }
                methodParams[varargIndex] = array;
                break block12;
            }
            for (int i = 0; i < methodParams.length; ++i) {
                if (i == 0) {
                    methodParams[0] = argsDescs;
                    continue;
                }
                ArgsDescription tmp = new ArgsDescription();
                AstNode paramNode = this.getParam(i - 1);
                tmp.setAstNode(paramNode);
                tmp.setMethodName(method.getName());
                ((WFElContext)context).pushArgsDescription(tmp);
                Object param = paramNode.eval(bindings, context);
                ((WFElContext)context).popArgsDescAndPassValues();
                if (param == null && !types[i].isPrimitive()) continue;
                methodParams[i] = bindings.convert(param, types[i]);
                argsDescs.add(tmp);
            }
        }
        return method.invoke(null, methodParams);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Method method = bindings.getFunction(this.index);
        try {
            return this.invoke(bindings, context, null, method);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get("error.function.access", this.name), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get("error.function.invocation", this.name), e.getCause());
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(bindings != null && bindings.isFunctionBound(this.index) ? "<fn>" : this.name);
        this.params.appendStructure(b, bindings);
    }

    @Override
    public void appendLogStructure(StringBuilder b, Bindings bindings, ELContext context) {
        b.append(bindings != null && bindings.isFunctionBound(this.index) ? "<fn>" : this.name);
        this.params.appendLogStructure(b, bindings, context);
        Object logValue = ELResolverUtil.getLogValue(context, this);
        if (logValue != null) {
            b.append(String.format("[%s]", logValue));
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isVarArgs() {
        return this.varargs;
    }

    @Override
    public int getParamCount() {
        return this.params.getCardinality();
    }

    protected AstNode getParam(int i) {
        return this.params.getChild(i);
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.params : null;
    }

    public AstParameters getParameters() {
        return this.params;
    }
}

