/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.context.WFElContext;
import de.odysseus.el.function.ArgsDescription;
import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.pojo.EntryContextPojo;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstIdentifier;
import de.odysseus.el.tree.impl.ast.AstLiteral;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class AstProperty
extends AstNode {
    public static final String TIP_NULL = "error.property.base.null";
    public static final String TIP_NOTFOUND = "error.property.property.notfound";
    public static final String TIP_NOTFOUNDMETHOD = "error.property.method.notfound";
    protected static Log logger = LogFactory.getLog(AstProperty.class);
    protected final AstNode prefix;
    protected final boolean lvalue;
    protected final boolean strict;
    protected final boolean ignoreReturnType;

    public AstProperty(AstNode prefix, boolean lvalue, boolean strict) {
        this(prefix, lvalue, strict, false);
    }

    public AstProperty(AstNode prefix, boolean lvalue, boolean strict, boolean ignoreReturnType) {
        this.prefix = prefix;
        this.lvalue = lvalue;
        this.strict = strict;
        this.ignoreReturnType = ignoreReturnType;
    }

    protected abstract Object getProperty(Bindings var1, ELContext var2) throws ELException;

    public AstNode getPrefix() {
        return this.prefix;
    }

    @Override
    public ValueReference getValueReference(Bindings bindings, ELContext context) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, "null", base));
        }
        return new ValueReference(base, property);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Object base = this.prefix.eval(bindings, context);
        if (base instanceof DynamicObjectCollection) {
            DynamicObjectCollection tmp = (DynamicObjectCollection)base;
            boolean isCondFuncExpressionCalc = false;
            if (context instanceof WFElContext) {
                String currentProp = ((WFElContext)context).getCurrentProp();
                ArgsDescription argsDescription = ((WFElContext)context).peekArgsDescription();
                if (StringUtils.isNotBlank((CharSequence)currentProp) && currentProp.startsWith("<fn>") && argsDescription != null && StringUtils.isNotBlank((CharSequence)argsDescription.getMethodName()) && !"getEnumText".equals(argsDescription.getMethodName())) {
                    isCondFuncExpressionCalc = true;
                }
            }
            if (!isCondFuncExpressionCalc && tmp.getDynamicObjectType() instanceof EntryType) {
                Object pojos;
                String entryMark = this.getEntryMark(bindings, context, this.prefix);
                List entryProps = (List)context.getContext(AstNode.class);
                if (entryProps != null && !entryProps.isEmpty() && !entryProps.contains(entryMark)) {
                    entryProps.add(entryMark);
                    if (tmp.isEmpty()) {
                        base = null;
                        logger.info(String.format("entry[%s] is isempty", entryMark));
                    } else {
                        base = tmp.get(0);
                    }
                }
                if ((pojos = context.getContext(EntryContextPojo.class)) != null && pojos instanceof Map && !((Map)pojos).isEmpty() && ((Map)pojos).get(this.getEntryMark(bindings, context, this.prefix)) != null) {
                    Map entryPojos = (Map)pojos;
                    EntryContextPojo entryProp = (EntryContextPojo)entryPojos.get(entryMark);
                    base = entryProp.getEntryItem();
                }
            }
        }
        if (base == null) {
            return null;
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            return null;
        }
        ArgsDescription argsDescription = ((WFElContext)context).peekArgsDescription();
        if (argsDescription != null) {
            AstNode astNode = argsDescription.getAstNode();
            if (astNode instanceof AstDot && "id".equals(((AstDot)astNode).getProperty())) {
                astNode = ((AstDot)astNode).getPrefix();
            }
            if (astNode.equals(this)) {
                argsDescription.setCanCalculator(true);
            }
        }
        context.setPropertyResolved(false);
        Object result = context.getELResolver().getValue(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, property, base));
        }
        return result;
    }

    private String getEntryMark(Bindings bindings, ELContext context, AstNode entryNode) {
        StringBuilder mark = new StringBuilder();
        if (entryNode instanceof AstProperty) {
            mark.append(((AstProperty)entryNode).getPrefix());
        }
        mark.append(entryNode);
        return mark.toString();
    }

    public EntryContextPojo markEntryAndSetContextEntryValue(Bindings bindings, ELContext context, String prefixStr) {
        Object pojos;
        Object property;
        DynamicObjectCollection doc;
        Object result;
        EntryContextPojo entryContextPojo = null;
        if (this.prefix instanceof AstIdentifier) {
            result = this.prefix.eval(bindings, context);
            entryContextPojo = new EntryContextPojo();
            entryContextPojo.setPath(this.getEntryMark(bindings, context, this.prefix));
            entryContextPojo.setResult(result);
        } else if (this.prefix instanceof AstProperty) {
            entryContextPojo = ((AstProperty)this.prefix).markEntryAndSetContextEntryValue(bindings, context, prefixStr);
        } else if (this.prefix instanceof AstLiteral) {
            result = this.prefix.eval(bindings, context);
            entryContextPojo = new EntryContextPojo();
            entryContextPojo.setPath(this.getEntryMark(bindings, context, this.prefix));
            entryContextPojo.setResult(result);
        }
        Object base = null;
        if (entryContextPojo != null && "SetContextEntryValueOver".equals(base = entryContextPojo.getResult())) {
            return entryContextPojo;
        }
        if (base == null) {
            return null;
        }
        if (base instanceof DynamicObjectCollection && (doc = (DynamicObjectCollection)base).getDynamicObjectType() instanceof EntryType) {
            String entryMark = this.getEntryMark(bindings, context, this.prefix);
            if (prefixStr != null && !"".equals(prefixStr.trim()) && prefixStr.equals(entryMark)) {
                Map pojos2 = (Map)context.getContext(EntryContextPojo.class);
                pojos2 = pojos2 == null ? new HashMap() : pojos2;
                EntryContextPojo pojo = new EntryContextPojo();
                pojo.setPath(prefixStr);
                pojo.setEntry(doc);
                pojo.setResult("SetContextEntryValueOver");
                pojos2.put(prefixStr, pojo);
                context.putContext(EntryContextPojo.class, (Object)pojos2);
                return pojo;
            }
            List entryProps = (List)context.getContext(AstNode.class);
            List list = entryProps = entryProps == null ? new ArrayList() : entryProps;
            if (!entryProps.contains(entryMark)) {
                entryProps.add(entryMark);
                context.putContext(AstNode.class, (Object)entryProps);
                return null;
            }
        }
        if ((property = this.getProperty(bindings, context)) == null && this.strict) {
            return null;
        }
        context.setPropertyResolved(false);
        if (base instanceof DynamicObjectCollection && (pojos = context.getContext(EntryContextPojo.class)) != null && pojos instanceof Map && !((Map)pojos).isEmpty() && ((Map)pojos).get(this.getEntryMark(bindings, context, this.prefix)) != null) {
            Map entryPojos = (Map)pojos;
            EntryContextPojo entryProp = (EntryContextPojo)entryPojos.get(this.getEntryMark(bindings, context, this.prefix));
            base = entryProp.getEntryItem();
        }
        Object result2 = context.getELResolver().getValue(context, base, property);
        EntryContextPojo returnEntryContextPojo = new EntryContextPojo();
        returnEntryContextPojo.setResult(result2);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, property, base));
        }
        return returnEntryContextPojo;
    }

    @Override
    public final boolean isLiteralText() {
        return false;
    }

    @Override
    public final boolean isLeftValue() {
        return this.lvalue;
    }

    @Override
    public boolean isMethodInvocation() {
        return false;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        if (!this.lvalue) {
            return null;
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, "null", base));
        }
        context.setPropertyResolved(false);
        Class result = context.getELResolver().getType(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, property, base));
        }
        return result;
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) throws ELException {
        if (!this.lvalue) {
            return true;
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, "null", base));
        }
        context.setPropertyResolved(false);
        boolean result = context.getELResolver().isReadOnly(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, property, base));
        }
        return result;
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) throws ELException {
        if (!this.lvalue) {
            throw new ELException(LocalMessages.get("error.value.set.rvalue", this.getStructuralId(bindings)));
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, "null", base));
        }
        context.setPropertyResolved(false);
        Class type = context.getELResolver().getType(context, base, property);
        if (context.isPropertyResolved()) {
            if (type != null && (value != null || type.isPrimitive())) {
                value = bindings.convert(value, type);
            }
            context.setPropertyResolved(false);
        }
        context.getELResolver().setValue(context, base, property, value);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUND, property, base));
        }
    }

    protected Method findMethod(String name, Class<?> clazz, Class<?> returnType, Class<?>[] paramTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(LocalMessages.get(TIP_NOTFOUNDMETHOD, name, clazz));
        }
        method = this.findAccessibleMethod(method);
        if (method == null) {
            throw new MethodNotFoundException(LocalMessages.get(TIP_NOTFOUNDMETHOD, name, clazz));
        }
        if (!this.ignoreReturnType && returnType != null && !returnType.isAssignableFrom(method.getReturnType())) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.returntype", method.getReturnType(), name, clazz, returnType));
        }
        return method;
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUNDMETHOD, "null", base));
        }
        String name = bindings.convert(property, String.class);
        Method method = this.findMethod(name, base.getClass(), returnType, paramTypes);
        return new MethodInfo(method.getName(), method.getReturnType(), (Class[])paramTypes);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] paramValues) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NULL, this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get(TIP_NOTFOUNDMETHOD, "null", base));
        }
        String name = bindings.convert(property, String.class);
        Method method = this.findMethod(name, base.getClass(), returnType, paramTypes);
        try {
            return method.invoke(base, paramValues);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get("error.property.method.access", name, base.getClass()));
        }
        catch (IllegalArgumentException e) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", name, base.getClass()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", name, base.getClass()), e.getCause());
        }
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.prefix : null;
    }
}

