/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.function.collection.CollectionFunctionType;
import de.odysseus.el.misc.BooleanOperations;
import de.odysseus.el.misc.NumberOperations;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.pojo.EntryContextPojo;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstFunction;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstParameters;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang.exception.ExceptionUtils;

public class AstUnary
extends AstRightValue {
    protected static Log logger = LogFactory.getLog(AstUnary.class);
    public static final Operator EMPTY = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o) {
            return BooleanOperations.empty(converter, o);
        }

        public String toString() {
            return "empty";
        }
    };
    public static final Operator NOTEMPTY = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o) {
            return BooleanOperations.notempty(converter, o);
        }

        public String toString() {
            return "notempty";
        }
    };
    public static final Operator NEG = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o) {
            return NumberOperations.neg(converter, o);
        }

        public String toString() {
            return "-";
        }
    };
    public static final Operator NOT = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o) {
            return converter.convert(o, Boolean.class) == false;
        }

        public String toString() {
            return "!";
        }
    };
    private final Operator operator;
    private final AstNode child;

    public AstUnary(AstNode child, Operator operator) {
        this.child = child;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) throws ELException {
        Object obj = this.operator.eval(bindings, context, this.child);
        this.setLogVal(obj, context);
        return obj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append('\'').append(this.operator).append('\'').toString();
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(this.operator);
        b.append(' ');
        this.child.appendStructure(b, bindings);
    }

    @Override
    public void appendLogStructure(StringBuilder b, Bindings bindings, ELContext context) {
        b.append(this.operator);
        b.append(' ');
        this.child.appendLogStructure(b, bindings, context);
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.child : null;
    }

    public static abstract class SimpleOperator
    implements Operator {
        private AstDot resolveFunctionEntry(AstNode astNode, AstDot astDot) {
            AstParameters parameters = ((AstFunction)astNode).getParameters();
            if (parameters != null) {
                List<AstNode> nodes = parameters.getNodes();
                for (AstNode node : nodes) {
                    if (!(node instanceof AstDot)) continue;
                    astDot = (AstDot)node;
                    break;
                }
            }
            return astDot;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean evelEntryValue(Bindings bindings, ELContext context, AstNode node, int indexEntry) {
            List entryProps = (List)context.getContext(AstNode.class);
            AstDot dot = null;
            dot = node instanceof AstFunction ? this.resolveFunctionEntry(node, dot) : (AstDot)node;
            if (dot == null) {
                return false;
            }
            if (indexEntry <= entryProps.size() - 1) {
                String prefixStr = (String)entryProps.get(indexEntry);
                EntryContextPojo pojo = null;
                if (dot != null) {
                    pojo = dot.markEntryAndSetContextEntryValue(bindings, context, prefixStr);
                }
                if (pojo == null || pojo.getEntry() == null || pojo.getEntry().isEmpty()) return (Boolean)this.apply(bindings, null);
                int tmp = indexEntry + 1;
                for (DynamicObject i : pojo.getEntry()) {
                    pojo.setEntryItem(i);
                    if (!this.evelEntryValue(bindings, context, node, tmp)) continue;
                    return true;
                }
                return false;
            } else {
                Object obj;
                Object nodeVal = node.eval(bindings, context);
                if (dot != null) {
                    dot.setLogVal(nodeVal, context);
                }
                if (!((obj = this.apply(bindings, nodeVal)) instanceof Boolean)) throw new RuntimeException(ResManager.loadKDString((String)"\u975eboolean\u7c7b\u578b\u7684\u4e0d\u7528\u6309\u7167\u6b64\u65b9\u6848\u89e3\u6790\uff01", (String)"AstUnary_1", (String)"bos-wf-juel", (Object[])new Object[0]));
                if (((Boolean)obj).booleanValue()) {
                    return (Boolean)obj;
                }
                if (indexEntry > entryProps.size() - 1) return false;
                return this.evelEntryValue(bindings, context, node, indexEntry);
            }
        }

        @Override
        public Object eval(Bindings bindings, ELContext context, AstNode node) {
            AstDot dot = null;
            if (node instanceof AstDot) {
                dot = (AstDot)node;
            } else if (node instanceof AstFunction && !CollectionFunctionType.isContain(((AstFunction)node).getName())) {
                dot = this.resolveFunctionEntry(node, dot);
            }
            if (dot != null) {
                dot.markEntryAndSetContextEntryValue(bindings, context, null);
                List entryProps = (List)context.getContext(AstNode.class);
                if (entryProps != null && !entryProps.isEmpty()) {
                    try {
                        boolean flag = this.evelEntryValue(bindings, context, node, 0);
                        Boolean bl = flag;
                        return bl;
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("expression parse error :\r\n");
                        sb.append("entryList= [");
                        sb.append(entryProps).append("]\r\n");
                        if (context.getContext(EntryContextPojo.class) != null) {
                            sb.append("EntryContextPojo= [");
                            sb.append(context.getContext(EntryContextPojo.class)).append("]\r\n");
                        }
                        sb.append(ExceptionUtils.getStackTrace((Throwable)e));
                        logger.info(sb.toString());
                        throw e;
                    }
                    finally {
                        context.putContext(AstNode.class, new ArrayList());
                        context.putContext(EntryContextPojo.class, new HashMap());
                    }
                }
            }
            Object nodeVal = node.eval(bindings, context);
            node.setLogVal(nodeVal, context);
            Object obj = this.apply(bindings, nodeVal);
            return obj;
        }

        protected abstract Object apply(TypeConverter var1, Object var2);
    }

    @FunctionalInterface
    public static interface Operator {
        public Object eval(Bindings var1, ELContext var2, AstNode var3);
    }
}

