/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.devops;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.bec.util.PluginUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;

public class EvtSubscriptionErrorList
extends AbstractListPlugin
implements ClickListener,
IConfirmCallBack {
    public static final String BTNBILL = "btnbill";
    public static final String TABKEY = "_submaintab_";

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters, "createdate")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc77\u5929\u3002", (String)"EvtSubscriptionDurationList_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean check(List<QFilter> qfilters, String date) {
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        for (QFilter filter : qfilters) {
            if (!date.equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date startDate = simpleDateFormat.parse(startTime);
                Calendar cal = Calendar.getInstance();
                cal.setTime(startDate);
                cal.add(7, 7);
                startDate = cal.getTime();
                Date endDate = simpleDateFormat.parse(endTime);
                int compare = endDate.compareTo(startDate);
                if (compare > 0) {
                    return false;
                }
                checkResult = true;
            }
            catch (ParseException px) {
                return checkResult;
            }
        }
        return checkResult;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FilterContainerInitEvent filterContainerInitEvent = args.getFilterContainerInitEvent();
        PluginUtil.removeCobPassDate(filterContainerInitEvent);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"businesskey", BTNBILL});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.NonModal);
        parameter.getOpenStyle().setTargetKey(TABKEY);
        parameter.setBillFormId("evt_deadletterjob");
        parameter.setFormId("bos_list");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter qFilter = new QFilter("executionid", "=", ((IListView)this.getView()).getFocusRowPkId());
        listFilterParameter.setFilter(qFilter);
        parameter.setListFilterParameter(listFilterParameter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void itemClick(ItemClickEvent evt) {
        ListSelectedRowCollection rows;
        String key = evt.getItemKey();
        if (BTNBILL.equals(key) && (rows = this.getSelectedRow()) != null) {
            Long jobrecordid = (Long)rows.get(0).getPrimaryKeyValue();
            PluginUtil.existBill(this, rows, jobrecordid);
        }
    }

    public ListSelectedRowCollection getSelectedRow() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EventLogListPlugin_3", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            rows = null;
        } else if (1 < rows.size()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u4e86%s\u884c\u3002", (String)"EventLogListPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]), rows.size()), Integer.valueOf(2000));
            rows = null;
        }
        return rows;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new LogDataProvider());
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        args.setEnableCustomSum(false);
        super.setEnableCustomSum(args);
    }

    private static class LogDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;

        private LogDataProvider() {
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            if (PluginUtil.isEmpty(orderBy)) {
                orderBy = "erroredtotal desc";
            }
            String lang = RequestContext.get().getLang().toString();
            String filterStr = this.buildFilter();
            String createDate = null;
            QFilter[] filters = this.getQFilters().toArray(new QFilter[0]);
            for (int i = 0; i < filters.length; ++i) {
                if (!"createdate".equalsIgnoreCase(filters[i].getProperty())) continue;
                createDate = filters[i].toString();
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select top ");
            sql.append(start + limit);
            sql.append(" A.fnumber subscriptionnumber,");
            sql.append("case when B.fname is null then A.fname else B.fname end  subscriptionname,");
            sql.append("case when C.fname is null then E.fname else C.fname end  servicename,");
            sql.append("D.id subscriptionid,");
            sql.append("D.id,");
            sql.append("D.erroredtotal,");
            sql.append("D.total ");
            sql.append("from (select fsubscriptionid id,sum(ferroredtotal) erroredtotal,sum(ftotal) total from t_wf_evtinstancecollect ");
            if (createDate != null) {
                sql.append("where ").append(createDate.replaceAll("createdate", "fcreatedate"));
            }
            sql.append(" group by fsubscriptionid)D ");
            sql.append("left join t_evt_subscription A on D.id = A.fid ");
            sql.append("left join t_evt_subscription_l B on A.fid = B.fid and B.flocaleid = ? ");
            sql.append("left join t_evt_service_l C on A.fservice = C.fid and C.flocaleid = ? ");
            sql.append("left join t_evt_service E on A.fservice = E.fid ");
            if (!WfUtils.isEmpty((String)filterStr)) {
                sql.append("where ").append(filterStr);
            }
            sql.append("order by ");
            sql.append(orderBy);
            this.queryResult = new QueryResult();
            try (DataSet ds = DB.queryDataSet((String)"EvtSubscriptionDurationList.queryGridData", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{lang, lang});){
                DynamicObjectCollection results = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
                if (null == results || results.getDynamicObjectType() == null || 0 == results.size()) {
                    DynamicObjectType dt = new DynamicObjectType();
                    this.queryResult.setCollection(new DynamicObjectCollection(dt, new Object()));
                    this.queryResult.setDataCount(0);
                    DynamicObjectCollection dynamicObjectCollection = this.queryResult.getCollection();
                    return dynamicObjectCollection;
                }
                this.queryResult.setCollection(results);
                this.queryResult.setDataCount(results.size());
                DynamicObjectCollection dynamicObjectCollection = results;
                return dynamicObjectCollection;
            }
        }

        private String buildFilter() {
            List filters = this.getQFilters();
            StringBuilder sb = new StringBuilder();
            if (filters.isEmpty()) {
                return sb.toString();
            }
            int len = filters.size();
            for (int j = 0; j < len; ++j) {
                String value;
                QFilter f = (QFilter)filters.get(j);
                if (!f.getCP().equals("ftlike") || !WfUtils.isNotEmptyString((Object)f.getValue())) continue;
                if (j != 0) {
                    sb.append(" or ");
                }
                if ((value = f.getValue().toString()).contains("#")) {
                    String like = value.split("#")[1];
                    if (like.contains("\b")) {
                        String[] items = like.split("\b");
                        for (int i = 0; i < items.length; ++i) {
                            sb.append(" A.FNUMBER like ");
                            sb.append("'%").append(items[i]).append("%' ");
                            if (i == items.length - 1) continue;
                            sb.append(" or ");
                        }
                        continue;
                    }
                    sb.append(" A.FNUMBER like ");
                    sb.append("'%").append(like).append("%' ");
                    continue;
                }
                sb.append(" A.FNUMBER like ");
                sb.append("'").append(value).append("' ");
            }
            return sb.toString();
        }
    }
}

