/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.log;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.util.PluginUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EventHiLogListPlugin
extends AbstractListPlugin
implements ClickListener,
IConfirmCallBack {
    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters, "createdate")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc77\u5929\u3002", (String)"EvtSubscriptionDurationList_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean check(List<QFilter> qfilters, String date) {
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        for (QFilter filter : qfilters) {
            if (!date.equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date startDate = simpleDateFormat.parse(startTime);
                Calendar cal = Calendar.getInstance();
                cal.setTime(startDate);
                cal.add(7, 7);
                startDate = cal.getTime();
                Date endDate = simpleDateFormat.parse(endTime);
                int compare = endDate.compareTo(startDate);
                if (compare > 0) {
                    return false;
                }
                checkResult = true;
            }
            catch (ParseException px) {
                return checkResult;
            }
        }
        return checkResult;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String entityNumber = "evt_hijob";
        args.setCancel(true);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setFormId(entityNumber);
        parameter.setPkId((Object)((Long)((ListView)this.getView()).getFocusRowPkId()));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setCustomParam("FID", (Object)((Long)((ListView)this.getView()).getFocusRowPkId()));
        IFormView parentView = PluginUtil.getTabControlView(this.getView());
        if (parentView != null) {
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.NonModal);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new LogDataProvider());
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        args.setEnableCustomSum(false);
        super.setEnableCustomSum(args);
    }

    private static class LogDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;

        private LogDataProvider() {
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String orderBy = this.getOrderByExpr();
            if (PluginUtil.isEmpty(orderBy)) {
                orderBy = "createdate desc";
            } else if (!orderBy.contains("createdate")) {
                orderBy = orderBy + ",createdate desc";
            }
            String properties = "id, lockownerid, exclusive, executionid, processinstanceid, retries, duedate, repeat, jobhandlertype, businesskey, operation, entitynumber, elementid,createdate, modifydate, srcjobid, executor, success, endtime, duration, state, source, rootjobid, bizkey, srctraceid, rooteventinstid,exceptionmessage, roottraceno";
            this.queryResult = new QueryResult();
            QFilter[] qFilters = this.getFilters(this.getQFilters());
            String entityNumber = "evt_hijob";
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"GetEvtJobDataCmd", (String)entityNumber, (String)properties, (QFilter[])qFilters, (String)orderBy, (int)(start + limit));){
                DynamicObjectCollection taskDataResultCollection = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
                if (taskDataResultCollection != null && taskDataResultCollection.size() > 0) {
                    for (DynamicObject dyn : taskDataResultCollection) {
                        dyn.set("executor", (Object)PluginUtil.desensitizeIP(dyn.getString("executor")));
                    }
                }
                this.queryResult.setCollection(taskDataResultCollection);
                Iterator iterator = taskDataResultCollection;
                return iterator;
            }
        }

        public int getRealCount() {
            QFilter[] qFilters = this.getFilters(this.getQFilters());
            String entityNumber = "evt_hijob";
            if (qFilters == null) {
                return 0;
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getBecLogRealCount", (String)entityNumber, (String)"count(1) count", (QFilter[])qFilters, null);){
                if (ds != null && ds.hasNext()) {
                    int n = ds.next().getInteger("count");
                    return n;
                }
            }
            return 0;
        }

        private QFilter[] getFilters(List<QFilter> filterList) {
            if (filterList == null || filterList.size() < 1) {
                return null;
            }
            return filterList.toArray(new QFilter[0]);
        }
    }
}

