/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.log;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bec.util.PluginUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ExceptionEvtsListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(ExceptionEvtsListPlugin.class);
    public static final String BAR_ACTIVATE = "baractivate";
    public static final String TABKEY = "_submaintab_";
    public static final String BTNBILL = "btnbill";
    public static final String CREATEDATE = "createdate";
    public static final String BAR_ACTIVATES = "activates";
    public static final String ACTIVECALLBACK = "activeCallBack";

    public void preOpenForm(PreOpenFormEventArgs e) {
        ListShowParameter showParameter = (ListShowParameter)e.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f", (String)"ExceptionEvtsListPlugin_0", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        Map map = (Map)showParameter.getCustomParam("data");
        if (map != null && !map.isEmpty()) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (EntityMetadataCache.getDataEntityType((String)"evt_deadletterjob").getProperty((String)entry.getKey()) == null) continue;
                QFilter qfilter = new QFilter((String)entry.getKey(), "=", entry.getValue());
                qFilters.add(qfilter);
            }
            listFilterParameter.setQFilters(qFilters);
            showParameter.setListFilterParameter(listFilterParameter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String lang = RequestContext.get().getLang().toString();
        if (!"zh_CN".equalsIgnoreCase(lang) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
            List list = args.getListColumns();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String colName = ((IListColumn)it.next()).getListFieldKey();
                if (!"exceptionmessage".equals(colName)) continue;
                it.remove();
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!PluginUtil.check(qfilters, CREATEDATE)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u64cd\u4f5c\u65f6\u95f4\u201d\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e09\u4e2a\u6708\u3002", (String)"EventLogListPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FilterContainerInitEvent filterContainerInitEvent = args.getFilterContainerInitEvent();
        this.removeCobPassDate(filterContainerInitEvent);
    }

    private void removeCobPassDate(FilterContainerInitEvent event) {
        try {
            List<String> ids = Arrays.asList("13", "11", "10", "61", "63", "92", "24");
            Field field = event.getClass().getDeclaredField("schemeFilterView");
            ReflectionUtils.makeAccessible((Field)field);
            SchemeFilterView schemeFilterView = (SchemeFilterView)field.get(event);
            List filterColumns = schemeFilterView.getFilterColumns();
            for (FilterColumn column : filterColumns) {
                if (!CREATEDATE.equals(column.getFieldName())) continue;
                SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)column;
                Field compField = schemeFilterColumn.getClass().getDeclaredField("compareTypes");
                ReflectionUtils.makeAccessible((Field)compField);
                List compareTypes = (List)compField.get(schemeFilterColumn);
                compareTypes.removeIf(temp -> !ids.contains(temp.getId()));
            }
        }
        catch (Exception e) {
            logger.info("ExceptionEvtsListPlugin_removeCobPassDate:\u79fb\u9664\u65e5\u671f\u5f02\u5e38");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btnbill": {
                ListSelectedRowCollection rows = this.getSelectedRow();
                if (rows == null) break;
                Long jobrecordid = (Long)rows.get(0).getPrimaryKeyValue();
                this.existBill(rows, jobrecordid);
                break;
            }
        }
    }

    public void existBill(ListSelectedRowCollection rows, Long jobrecordid) {
        String businesskey = null;
        String entitynumber = null;
        String sbs = "SELECT FBUSINESSKEY,FENTITYNUMBER  FROM T_EVT_DEADLETTERJOB WHERE FID = ? ";
        try (DataSet ds = DB.queryDataSet((String)"EventJobPlugin", (DBRoute)DBRoute.workflow, (String)sbs, (Object[])new Object[]{jobrecordid});){
            for (Row row : ds) {
                businesskey = row.getString("fbusinesskey");
                entitynumber = row.getString("fentitynumber");
            }
        }
        try {
            if (ORM.create().exists(entitynumber, businesskey)) {
                this.openBill(rows, jobrecordid, businesskey, entitynumber);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"ExceptionEvtsListPlugin_10", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"ExceptionEvtsListPlugin_10", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public void openBill(ListSelectedRowCollection rows, Long jobrecordid, String businesskey, String entitynumber) {
        if (ExceptionEvtsListPlugin.hasCurrentPageTab(jobrecordid, "showBill", this.getView())) {
            return;
        }
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        IFormView settingsFormView = ExceptionEvtsListPlugin.getTargetView(this);
        FormShowParameter parameter = new FormShowParameter();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entitynumber);
        LocaleString localString = formConfig.getCaption();
        parameter.getCustomParams().put("rows", rows);
        parameter.getCustomParams().put("pkId", businesskey);
        parameter.getCustomParams().put("BillFormId", billFormId);
        parameter.getCustomParams().put("taskId", jobrecordid);
        String appId = WfUtils.getAppIdForEntity((String)entitynumber);
        parameter.getCustomParams().put("ServiceAppId", appId);
        parameter.getCustomParams().put("formId", entitynumber);
        parameter.setCaption(localString.getLocaleValue());
        parameter.setCustomParam("listView", (Object)this.getView().getPageId());
        parameter.setFormId("wf_openbills");
        parameter.setPageId(ExceptionEvtsListPlugin.getPageId(jobrecordid, "showBill", this.getView().getParentView()));
        parameter.getOpenStyle().setTargetKey(TABKEY);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (settingsFormView != null) {
            settingsFormView.showForm(parameter);
            this.getView().sendFormAction(settingsFormView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        }
    }

    public static IFormView getTargetView(AbstractListPlugin plugin) {
        IFormView parentView = plugin.getView();
        while ((parentView = parentView.getParentView()) != null && !"pc_main_console".equals(parentView.getFormShowParameter().getFormId())) {
            Control control = parentView.getControl(TABKEY);
            if (control == null) continue;
            return parentView;
        }
        return null;
    }

    public static String getPageId(long taskId, String type, IFormView view) {
        String pageId = UUID.randomUUID().toString();
        if (null != view) {
            IPageCache parentPageCache = (IPageCache)view.getService(IPageCache.class);
            parentPageCache.put(ExceptionEvtsListPlugin.getPageIdKey(taskId, type, view), pageId);
        }
        return pageId;
    }

    public static String getPageIdKey(long taskId, String type, IFormView view) {
        String pageIdkey = type + taskId;
        if (null != RequestContext.get()) {
            pageIdkey = pageIdkey + RequestContext.get().getUserId();
        }
        if (null != view) {
            pageIdkey = pageIdkey + view.getPageId();
        }
        return pageIdkey;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (BAR_ACTIVATE.equals(key)) {
            if (!PermissionServiceHelper.checkPermission((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"0P2FWW95+QU6", (String)"evt_deadletterjob", (String)"1RG9K85FQ=HP")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6fc0\u6d3b\u201d\u6743\u9650\u3002", (String)"ExceptionEvtsListPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                return;
            }
            this.activateDeadJob();
            return;
        }
        if (BAR_ACTIVATES.equals(key)) {
            if (!PermissionServiceHelper.checkPermission((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"0P2FWW95+QU6", (String)"evt_deadletterjob", (String)"1RG9K85FQ=HP")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6fc0\u6d3b\u201d\u6743\u9650\u3002", (String)"ExceptionEvtsListPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                return;
            }
            return;
        }
    }

    private void activateDeadJobs() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIVECALLBACK));
        parameter.setFormId("evt_active_deadletter");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (ACTIVECALLBACK.equals(actionId) && "1".equals((String)evt.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6309\u8ba2\u9605\u6fc0\u6d3b\u6210\u529f\u3002", (String)"ExceptionEvtsListPlugin_17", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            IListView view = (IListView)this.getView();
            view.refresh();
            return;
        }
    }

    private void activateDeadJob() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ExceptionEvtsListPlugin_14", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rows.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e9100\u6761\u6570\u636e\u3002", (String)"ExceptionEvtsListPlugin_15", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder errorMSG = new StringBuilder();
        StringBuilder deadLetterJobIds = new StringBuilder();
        try {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            for (ListSelectedRow row : rows) {
                Long deadLetterJobId = (Long)row.getPrimaryKeyValue();
                deadLetterJobIds.append(deadLetterJobId).append(',');
                try {
                    wfService.getManagementService().revokDeadLetterEventJob(deadLetterJobId);
                }
                catch (Exception e) {
                    String tips = ResManager.loadKDString((String)"ID\u4e3a%s\u7684\u4efb\u52a1\u6fc0\u6d3b\u5931\u8d25\u3002", (String)"ExceptionEvtsListPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]);
                    String format = String.format(tips, deadLetterJobId);
                    errorMSG.append(format);
                }
            }
        }
        catch (Exception e) {
            errorMSG.append(ResManager.loadKDString((String)"\u5f15\u64ce\u5f02\u5e38\uff1a", (String)"ExceptionEvtsListPlugin_4", (String)"bos-bec-formplugin", (Object[])new Object[0])).append(e.getMessage());
        }
        if (errorMSG.length() > 0) {
            this.getView().showErrorNotification(errorMSG.toString());
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6fc0\u6d3b\u6210\u529f", (String)"ExceptionEvtsListPlugin_5", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        WfUtils.addOpLog((String)"wf_deadletterjob", (String)"activate", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6fc0\u6d3b", "ExceptionEvtsListPlugin_6", "bos-bec-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c06\u5f02\u5e38Id[%s]\u6fc0\u6d3b", "ExceptionEvtsListPlugin_7", "bos-bec-formplugin"), (Object[])new Object[]{deadLetterJobIds.substring(0, deadLetterJobIds.length() - 1)});
        ListView listView = (ListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }

    public boolean checkWorkflowInService(IFormView view) {
        try {
            ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
            return true;
        }
        catch (Exception e) {
            view.showMessage(e.getMessage());
            return false;
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setShowTitle(false);
        parameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f", (String)"ExceptionEvtsListPlugin_9", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.getOpenStyle().setTargetKey(TABKEY);
        parameter.setFormId("evt_deadletterjob");
        parameter.setPkId((Object)((Long)((ListView)this.getView()).getFocusRowPkId()));
        parameter.setStatus(OperationStatus.VIEW);
        IFormView parentView = ExceptionEvtsListPlugin.getTabControlView(this.getView());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (parentView != null) {
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        } else {
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public static IFormView getTabControlView(IFormView view) {
        IFormView parentView = view;
        while ((parentView = parentView.getParentView()) != null && !"pc_main_console".equals(parentView.getFormShowParameter().getFormId())) {
            Control control = parentView.getControl(TABKEY);
            if (control == null) continue;
            return parentView;
        }
        return null;
    }

    public ListSelectedRowCollection getSelectedRow() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        StandardTips tips = StandardTips.view((IFormView)this.getView());
        if (rows == null || rows.isEmpty()) {
            tips.notSelectRow();
            rows = null;
        } else if (1 < rows.size()) {
            tips.selectMultiRow(rows.size());
            rows = null;
        }
        return rows;
    }

    public static boolean hasCurrentPageTab(long taskId, String type, IFormView view) {
        if (view.getParentView() == null) {
            return false;
        }
        IFormView formView = ExceptionEvtsListPlugin.getCurrentPageTab(taskId, type, view.getParentView());
        if (formView != null) {
            formView.activate();
            ExceptionEvtsListPlugin.clearSelectData(view);
            view.sendFormAction(formView);
            return true;
        }
        return false;
    }

    public static IFormView getCurrentPageTab(long taskId, String type, IFormView view) {
        IFormView formView = null;
        if (null != view) {
            String pageIdkey = ExceptionEvtsListPlugin.getPageIdKey(taskId, type, view);
            IPageCache parentPageCache = (IPageCache)view.getService(IPageCache.class);
            String pageId = parentPageCache.get(pageIdkey);
            if (WfUtils.isNotEmpty((String)pageId)) {
                formView = view.getViewNoPlugin(pageId);
            }
        }
        return formView;
    }

    public static void clearSelectData(IFormView formView) {
        if (formView instanceof IListView) {
            IListView view = (IListView)formView;
            view.clearSelection();
        }
    }
}

