/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.rule.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.EvtUtils;
import kd.bos.bec.engine.devops.rule.persistent.EvtAbnormalSubEntity;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;

public class EvtAbnormalSubsListPlugin
extends AbstractListPlugin {
    private static final String OPENED_HISTORICPAGE_IDS = "openedHistoricPageIds";
    private static final String OPENED_INSTPAGE_IDS = "openedInstPageIds";
    private static final String OPERATE_ADD = "addabnormalsub";
    private static final String OPERATE_RELIEVE = "abnormalsubrelieve";
    private static final String OPERATE_VIEWHISTORY = "abnormalsubviewhistory";
    private static final String OPERATE_VIEWINST = "abnormalsubviewinst";
    private static final String BAR_RELIEVE = "bar_relieve";
    private static final String BAR_VIEWINST = "bar_viewinst";
    private static final String SUBSCRIPTIONID = "subscriptionid";
    private static final String DEALOPTION = "dealoption";
    private static final String EXPLAIN = "explain";

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        Boolean canShowRelieveBtn = Boolean.TRUE;
        Boolean canShowViewInstBtn = Boolean.TRUE;
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> abnormalSubIds = new ArrayList<Long>(10);
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                abnormalSubIds.add((Long)row.getPrimaryKeyValue());
            }
            List<EvtAbnormalSubEntity> evtAbnormalSubEntitys = this.getEvtAbnormalSubEntitys(abnormalSubIds, "subState");
            if (WfUtils.isEmptyForCollection(evtAbnormalSubEntitys)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"EvtAbnormalSubsListPlugin_3", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                return;
            }
            for (EvtAbnormalSubEntity entity : evtAbnormalSubEntitys) {
                if (!"2".equals(entity.getSubState())) continue;
                canShowRelieveBtn = Boolean.FALSE;
                break;
            }
            canShowViewInstBtn = rows.size() == 1 && ("1".equals(evtAbnormalSubEntitys.get(0).getSubState()) || "2".equals(evtAbnormalSubEntitys.get(0).getSubState())) ? Boolean.TRUE : Boolean.FALSE;
        }
        this.getView().setEnable(canShowRelieveBtn, new String[]{BAR_RELIEVE});
        this.getView().setEnable(canShowViewInstBtn, new String[]{BAR_VIEWINST});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        switch (key = evt.getOperateKey()) {
            case "addabnormalsub": {
                this.showAddAbnormal();
                break;
            }
            case "abnormalsubrelieve": {
                this.relieve();
                this.refresh();
                break;
            }
            case "abnormalsubviewhistory": {
                this.viewHistory();
                break;
            }
            case "abnormalsubviewinst": {
                this.viewInst();
                break;
            }
        }
    }

    private void showAddAbnormal() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("evt_addabnomalsub");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPERATE_ADD));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.isBlank((Object)returnData)) {
            return;
        }
        if (OPERATE_ADD.equalsIgnoreCase(actionId)) {
            Map result = (Map)returnData;
            List subscriptionIds = (List)result.get(SUBSCRIPTIONID);
            String dealOption = (String)result.get(DEALOPTION);
            LocaleString explain = (LocaleString)result.get(EXPLAIN);
            for (Long subscriptionId : subscriptionIds) {
                EvtUtils.getEvtService().addOneAbnormalSub(subscriptionId, dealOption, explain);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5f02\u5e38\u8ba2\u9605\u6210\u529f\u3002", (String)"EvtAbnormalSubsListPlugin_4", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        }
        super.closedCallBack(closedCallBackEvent);
        this.refresh();
    }

    private void viewInst() {
        Long subscriptionId = this.getSubscriptionId();
        if (subscriptionId == null) {
            return;
        }
        String ids = this.getPageCache().get(OPENED_INSTPAGE_IDS);
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String subscriptionIdStr = String.valueOf(subscriptionId);
        String pageId = (String)idsMap.get(subscriptionIdStr);
        IFormView openedView = this.getView().getView(pageId);
        if (pageId != null && openedView != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("evt_abnormalinstance");
        parameter.setFormId("bos_list");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (subscriptionId != -1L) {
            QFilter qFilter = new QFilter("executionid", "=", (Object)subscriptionId);
            listFilterParameter.setFilter(qFilter);
        }
        parameter.setListFilterParameter(listFilterParameter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
        idsMap.put(subscriptionIdStr, parameter.getPageId());
        this.getPageCache().put(OPENED_INSTPAGE_IDS, SerializationUtils.toJsonString(idsMap));
    }

    private Long getSubscriptionId() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        Long subscriptionId = -1L;
        if (rows != null && rows.size() > 0) {
            if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EvtAbnormalSubsListPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                return null;
            }
            ArrayList<Long> abnormalSubIds = new ArrayList<Long>(1);
            abnormalSubIds.add((Long)rows.get(0).getPrimaryKeyValue());
            List<EvtAbnormalSubEntity> entities = this.getEvtAbnormalSubEntitys(abnormalSubIds, "subscriptionId");
            if (WfUtils.isEmptyForCollection(entities)) {
                return subscriptionId;
            }
            subscriptionId = entities.get(0).getSubscriptionId();
        }
        return subscriptionId;
    }

    private void viewHistory() {
        Long subscriptionId = this.getSubscriptionId();
        if (subscriptionId == null) {
            return;
        }
        String ids = this.getPageCache().get(OPENED_HISTORICPAGE_IDS);
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String subscriptionIdStr = String.valueOf(subscriptionId);
        String pageId = (String)idsMap.get(subscriptionIdStr);
        IFormView openedView = this.getView().getView(pageId);
        if (pageId != null && openedView != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("evt_hiabnormalsubs");
        parameter.setFormId("bos_list");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (subscriptionId != -1L) {
            QFilter qFilter = new QFilter("subscriptionId", "=", (Object)subscriptionId);
            listFilterParameter.setFilter(qFilter);
        }
        parameter.setListFilterParameter(listFilterParameter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
        idsMap.put(subscriptionIdStr, parameter.getPageId());
        this.getPageCache().put(OPENED_HISTORICPAGE_IDS, SerializationUtils.toJsonString(idsMap));
    }

    private void relieve() {
        ListSelectedRowCollection rows = this.getSelectedRowListWithShowTip();
        if (rows != null && WfUtils.isNotEmptyForCollection((Collection)rows)) {
            for (ListSelectedRow row : rows) {
                EvtUtils.getEvtService().relieveAbnormalSub((Long)row.getPrimaryKeyValue());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6062\u590d\u5f02\u5e38\u8ba2\u9605\u6210\u529f\u3002", (String)"EvtAbnormalSubsListPlugin_5", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        }
    }

    private List<EvtAbnormalSubEntity> getEvtAbnormalSubEntitys(List<Long> abnormalSubIds, String selectFields) {
        return EvtUtils.getEvtService().findEvtAbnormalSubEntitysBySubId(abnormalSubIds, selectFields);
    }

    private ListSelectedRowCollection getSelectedRowListWithShowTip() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvtAbnormalSubsListPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            return null;
        }
        return rows;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(OPENED_HISTORICPAGE_IDS);
        this.getPageCache().remove(OPENED_INSTPAGE_IDS);
    }

    private void refresh() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        this.getView().setEnable(Boolean.TRUE, new String[]{BAR_RELIEVE});
        this.getView().setEnable(Boolean.TRUE, new String[]{BAR_VIEWINST});
        view.refresh();
    }
}

