/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.rule.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class EvtRegulationParamPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String CONTROL_BASE_COUNT = "basecount";
    private static final String CONTROL_FAILURE_RATE = "failurerate";
    private static final String CONTROL_OVERTIME_RATE = "overtimerate";
    private static final String CONTROL_OVERTIME_DURATION = "overtimeduration";
    private static final String BASE_COUNT = "baseCount";
    private static final String FAILURE_RATE = "failureRate";
    private static final String OVERTIME_RATE = "overtimeRate";
    private static final String OVERTIME_DURATION = "overtimeDuration";
    private static final String SCENE = "scene";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map initParam = this.getView().getFormShowParameter().getCustomParams();
        String scene = (String)initParam.get(SCENE);
        if (initParam.get(BASE_COUNT) != null) {
            this.getModel().setValue(CONTROL_BASE_COUNT, initParam.get(BASE_COUNT));
        }
        if (initParam.get(FAILURE_RATE) != null) {
            this.getModel().setValue(CONTROL_FAILURE_RATE, (Object)((BigDecimal)initParam.get(FAILURE_RATE)).multiply(new BigDecimal(100)));
        }
        if (initParam.get(OVERTIME_RATE) != null) {
            this.getModel().setValue(CONTROL_OVERTIME_RATE, (Object)((BigDecimal)initParam.get(OVERTIME_RATE)).multiply(new BigDecimal(100)));
        }
        if (initParam.get(OVERTIME_DURATION) != null) {
            this.getModel().setValue(CONTROL_OVERTIME_DURATION, initParam.get(OVERTIME_DURATION));
        }
        if ("overtime".equals(scene)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_OVERTIME_RATE, CONTROL_OVERTIME_DURATION});
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_FAILURE_RATE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_FAILURE_RATE});
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OVERTIME_RATE, CONTROL_OVERTIME_DURATION});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_BASE_COUNT});
    }

    public void click(EventObject evt) {
        Map initParam = this.getView().getFormShowParameter().getCustomParams();
        String scene = (String)initParam.get(SCENE);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            Object baseCountObj = this.getModel().getValue(CONTROL_BASE_COUNT);
            Object failureRateObj = this.getModel().getValue(CONTROL_FAILURE_RATE);
            Object overtimeRateObj = this.getModel().getValue(CONTROL_OVERTIME_RATE);
            Object overtimeDurationObj = this.getModel().getValue(CONTROL_OVERTIME_DURATION);
            HashMap<String, Object> result = new HashMap<String, Object>(3);
            if (baseCountObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"EvtRegulationParamPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            Integer baseCount = (Integer)baseCountObj;
            if (baseCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u91cf\u9608\u503c\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u3002", (String)"EvtRegulationParamPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            result.put(BASE_COUNT, baseCountObj);
            if ("overtime".equals(scene)) {
                if (overtimeRateObj == null || overtimeDurationObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"EvtRegulationParamPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                Integer overtimeRate = (Integer)overtimeRateObj;
                if (overtimeRate <= 0 || overtimeRate > 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u65f6\u7387\u9608\u503c\u5fc5\u987b\u4e3a\u5927\u4e8e0\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u7684\u6b63\u6574\u6570\u3002", (String)"EvtRegulationParamPlugin_3", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                Double realFailureRate = new BigDecimal(overtimeRate).divide(new BigDecimal(100)).doubleValue();
                Integer overtimeDuration = (Integer)overtimeDurationObj;
                if (overtimeDuration <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8017\u65f6\u65f6\u957f\u9608\u503c\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u3002", (String)"EvtRegulationParamPlugin_4", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                result.put(OVERTIME_RATE, realFailureRate);
                result.put(OVERTIME_DURATION, overtimeDuration);
            } else {
                if (failureRateObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"EvtRegulationParamPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                Integer failureRate = (Integer)failureRateObj;
                if (failureRate <= 0 || failureRate > 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u8d25\u7387\u9608\u503c\u5fc5\u987b\u4e3a\u5927\u4e8e0\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u7684\u6b63\u6574\u6570\u3002", (String)"EvtRegulationParamPlugin_5", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                Double realFailureRate = new BigDecimal(failureRate).divide(new BigDecimal(100)).doubleValue();
                result.put(FAILURE_RATE, realFailureRate);
            }
            this.getView().returnDataToParent(result);
        }
        this.getView().close();
        super.click(evt);
    }
}

