/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.service.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.util.HttpClientUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.WfUtils;

public class CustomTokenPlugin
extends AbstractFormPlugin {
    public static final String TOKENURL = "tokenurl";
    public static final String EXTPARAMS = "extparams";
    public static final String TOKENPATH = "tokenpath";
    public static final String BTNOK = "btnok";
    public static final String BTNCONNECT = "connect";
    public static final String VALUESTRATKEY = "CCB_";
    public static final String VALUE = "value";
    public static final String TESTVALUE = "testvalue";
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, VALUE, BTNCONNECT});
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject data;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String dataJson = (String)formShowParameter.getCustomParam("authcconfig");
        if (dataJson != null && !"".equals(dataJson.trim()) && (data = JSON.parseObject((String)dataJson)) != null && !data.isEmpty()) {
            this.getModel().setValue(TOKENURL, data.get((Object)TOKENURL));
            this.getModel().setValue(TOKENPATH, data.get((Object)TOKENPATH));
            JSONArray extParams = data.getJSONArray(EXTPARAMS);
            if (extParams != null && !extParams.isEmpty()) {
                this.setEntryValue(extParams, EXTPARAMS, "key", VALUE, TESTVALUE);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            String url = (String)this.getModel().getValue(TOKENURL);
            String tokenPath = (String)this.getModel().getValue(TOKENPATH);
            if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)tokenPath)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4ee4\u724cURL\u201d\u6216\u201c\u4ee4\u724c\u8def\u5f84\u201d\u3002", (String)"CustomTokenPlugin_0", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                return;
            }
            returnData.put(TOKENURL, url);
            returnData.put(TOKENPATH, tokenPath);
            List<Map<String, Object>> extParams = this.getEntryData(EXTPARAMS, "key", VALUE, TESTVALUE);
            if (!extParams.isEmpty()) {
                returnData.put(EXTPARAMS, extParams);
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (VALUE.equals(key)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            FormShowParameter parameter = new FormShowParameter();
            HashMap<String, String> content = new HashMap<String, String>();
            String entityNumber = (String)showParameter.getCustomParam("entityNumber");
            String event = (String)showParameter.getCustomParam("eventnumber");
            content.put("eventnumber", event);
            content.put("ruleType", "EventConfig");
            if (entityNumber != null && !"".equals(entityNumber.trim())) {
                content.put("entityNumber", entityNumber);
            }
            TextEdit source = (TextEdit)evt.getSource();
            String entryKey = source.getEntryKey();
            AbstractGrid grid = (AbstractGrid)this.getControl(entryKey);
            int[] selectRow = grid.getEntryState().getSelectedRows();
            String fieldKey = source.getFieldKey();
            String closedCallBackKey = String.format("%s.%s.%s", VALUESTRATKEY, fieldKey, selectRow[0]);
            String value = (String)this.getModel().getValue(fieldKey, selectRow[0]);
            String expression = "";
            if (!value.startsWith("${") || !value.endsWith("}")) {
                value = null;
            }
            if (value != null) {
                expression = String.valueOf(value);
            }
            if (expression.startsWith("${") && expression.endsWith("}")) {
                expression = expression.substring(2, expression.length() - 1);
            }
            content.put("expression", expression);
            parameter.setCustomParams(content);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closedCallBackKey));
            parameter.setFormId("wf_valueexpression");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        } else if (BTNCONNECT.equals(key)) {
            try {
                JSONObject rsJson;
                String tokenUrl = (String)this.getModel().getValue(TOKENURL);
                if (StringUtils.isBlank((String)tokenUrl)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ee4\u724cURL\u3002", (String)"CustomTokenPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                JSONObject params = new JSONObject();
                List<Map<String, Object>> extParams = this.getEntryData(EXTPARAMS, "key", VALUE, TESTVALUE);
                for (Map<String, Object> map : extParams) {
                    String jkey = (String)map.get("key");
                    Object value = map.get(VALUE);
                    Object testValue = map.get(TESTVALUE);
                    if (StringUtils.isBlank((String)jkey) || value == null || testValue == null) continue;
                    params.put(jkey, testValue);
                }
                HashMap<String, String> tokenHeader = new HashMap<String, String>();
                tokenHeader.put("Content-Type", "application/json");
                String bodyJson = SerializationUtils.toJsonString((Object)params);
                String tokenJson = HttpClientUtil.postjson(tokenUrl, tokenHeader, bodyJson);
                String tokenPath = (String)this.getModel().getValue(TOKENPATH);
                if (StringUtils.isBlank((String)tokenJson)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff1a\u8fd4\u56de\u7a7a\u3002", (String)"CustomTokenPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                String[] path = tokenPath.split("\\.");
                Object tmp = rsJson = JSON.parseObject((String)tokenJson);
                String token = "";
                for (int i = 0; i < path.length; ++i) {
                    if ((tmp = tmp.get((Object)path[i])) != null) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6309\u7167\u4ee4\u724c\u8def\u5f84\u83b7\u53d6\u4e0d\u5230\u4ee4\u724c\uff0c\u8bf7\u68c0\u67e5\u6388\u6743\u914d\u7f6e\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a\u201c%s\u201d\u3002", (String)"CustomTokenPlugin_3", (String)"bos-bec-formplugin", (Object[])new Object[0]), tokenJson));
                    return;
                }
                token = (String)tmp;
                if (StringUtils.isBlank((String)token)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff1a\u8fd4\u56de\u7a7a\u3002", (String)"CustomTokenPlugin_4", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                } else {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f\uff0c\u83b7\u53d6token\uff1a%s\u3002", (String)"CustomTokenPlugin_5", (String)"bos-bec-formplugin", (Object[])new Object[0]), token));
                }
            }
            catch (IOException | RuntimeException e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"CustomTokenPlugin_6", (String)"bos-bec-formplugin", (Object[])new Object[0]), e.getMessage()));
                this.log.warn(String.format("CustomTokenPlugin error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (VALUE.equals(propertyName)) {
            String value = (String)this.getModel().getValue(VALUE);
            if (value == null || "".equals(value.trim())) {
                this.getModel().setValue(TESTVALUE, (Object)"");
            } else if (!value.startsWith("${")) {
                this.getModel().setValue(TESTVALUE, (Object)value);
            }
        }
    }

    private void setEntryValue(JSONArray data, String entryName, String keyName, String valueName, String testValueName) {
        if (data != null && !data.isEmpty()) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(entryName, data.size());
            for (int i = 0; i < data.size(); ++i) {
                model.setValue(keyName, data.getJSONObject(i).get((Object)keyName), i);
                model.setValue(valueName, data.getJSONObject(i).get((Object)valueName), i);
                model.setValue(testValueName, data.getJSONObject(i).get((Object)testValueName), i);
            }
        }
    }

    private List<Map<String, Object>> getEntryData(String entryName, String keyName, String valueName, String testValueName) {
        AbstractGrid grid = (AbstractGrid)this.getControl(entryName);
        DynamicObjectCollection col = grid.getModel().getEntryEntity(entryName);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(col.size());
        for (DynamicObject i : col) {
            String keyResult = i.getString(keyName);
            String valueResult = i.getString(valueName);
            String testValue = i.getString(testValueName);
            if (keyResult == null || "".equals(keyResult) || valueResult == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(keyName, keyResult);
            map.put(valueName, valueResult);
            map.put(testValueName, testValue);
            result.add(map);
        }
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        String key = evt.getActionId();
        if (key.startsWith(VALUESTRATKEY) && (returnData = (Map)evt.getReturnData()) != null) {
            String[] cbkeys = key.split("\\.");
            String fieldKey = cbkeys[1];
            int row = Integer.parseInt(cbkeys[2]);
            String value = String.format("${%s}", returnData.get("expression"));
            this.getModel().setValue(fieldKey, (Object)value, row);
        }
    }
}

