/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.service.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;

public class EventFlowParamConfigPlugin
extends AbstractFormPlugin {
    private static final String KEY_ID = "id";
    private static final String KEY_NAME = "name";
    private static final String KEY_NUMBER = "number";
    private static final String PARAM_KEY_ID = "procId";
    private static final String PARAM_KEY_NAME = "procName";
    private static final String PARAM_KEY_NUMBER = "procNumber";
    private static final String BTN_OK = "btnok";
    private static final String KEY_CALLBACKID = "callBackId";
    private static final String FIELD_PROCESSNAME = "procname";
    private static final String FIELD_PROCESSNUMBER = "procnumber";
    private static final String FIELD_PROCESSID = "procid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        TextEdit selectProcess = (TextEdit)this.getControl(FIELD_PROCESSNAME);
        selectProcess.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String params = (String)parameter.getCustomParam("params");
        if (params != null && params.trim().length() > 1) {
            JSONObject data = JSON.parseObject((String)params);
            IDataModel model = this.getModel();
            model.setValue(FIELD_PROCESSID, data.get((Object)PARAM_KEY_ID));
            model.setValue(FIELD_PROCESSNAME, data.get((Object)PARAM_KEY_NAME));
            model.setValue(FIELD_PROCESSNUMBER, data.get((Object)PARAM_KEY_NUMBER));
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "procname": {
                this.selectEventProcess();
                break;
            }
            case "btnok": {
                this.confirm();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void selectEventProcess() {
        FormShowParameter param = new FormShowParameter();
        param.setShowTitle(false);
        param.setFormId("wf_common_f7list");
        param.setCustomParam("billFormId", (Object)"wf_released_process");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("key", "like", (Object)"Event_%"));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CALLBACKID));
        param.setCustomParam("filters", (Object)SerializationUtils.toJsonString(filters));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void confirm() {
        IDataModel model = this.getModel();
        JSONObject ret = new JSONObject();
        ret.put(PARAM_KEY_ID, model.getValue(FIELD_PROCESSID));
        ret.put(PARAM_KEY_NAME, model.getValue(FIELD_PROCESSNAME));
        ret.put(PARAM_KEY_NUMBER, model.getValue(FIELD_PROCESSNUMBER));
        this.getView().returnDataToParent((Object)ret);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (KEY_CALLBACKID.equals(actionId)) {
            this.udpateEventProcess(returnData);
        }
    }

    private void udpateEventProcess(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            IDataModel model = this.getModel();
            model.setValue(FIELD_PROCESSID, data.get(KEY_ID));
            model.setValue(FIELD_PROCESSNAME, data.get(KEY_NAME));
            model.setValue(FIELD_PROCESSNUMBER, data.get(KEY_NUMBER));
        }
    }
}

