/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.service.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class EventSplitPlugin
extends AbstractFormPlugin
implements ClickListener,
CellClickListener,
BeforeF7SelectListener {
    public static final String BTNOK = "btnok";
    public static final String BTNCANCEL = "btncancel";
    public static final String SPLITTYPE = "splittype";
    public static final String SPLITWORD = "splitword";
    public static final String SPLITSIZE = "splitsize";
    public static final String SPLITSIZE_REGULAR = "^([1-9][0-9]{0,2}|1000)$";
    public static final String EVENTTYPE_COSMIC = "cosmic";
    public static final String EVENTTYPE_CUSTOM = "custom";
    public static final String EVENTTYPE = "type";
    public static final String NUMBER = "number";
    public static final String EVENTNUMBER = "eventnumber";
    public static final String EVENTSPLITCONF = "eventsplitconfig";
    public static final String BILLID = "billid";

    public void afterCreateNewData(EventObject e) {
        boolean isCosmic;
        Map eventsplitconfMap;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String eventnumber = (String)showParameter.getCustomParam(EVENTNUMBER);
        String eventsplitconf = (String)showParameter.getCustomParam(EVENTSPLITCONF);
        if (WfUtils.isNotEmpty((String)eventsplitconf) && (eventsplitconfMap = (Map)SerializationUtils.fromJsonString((String)eventsplitconf, Map.class)) != null && !eventsplitconfMap.isEmpty()) {
            this.setValue(SPLITTYPE, eventsplitconfMap.get(SPLITTYPE));
            this.setValue(SPLITWORD, eventsplitconfMap.get(SPLITWORD));
            this.setValue(SPLITSIZE, eventsplitconfMap.get(SPLITSIZE));
        }
        if (isCosmic = EVENTTYPE_COSMIC.equalsIgnoreCase((String)showParameter.getCustomParam(EVENTTYPE))) {
            ComboEdit splitTypes = (ComboEdit)this.getControl(SPLITTYPE);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(BILLID);
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u636eID", (String)"EventSplitPlugin_4", (String)"bos-bec-formplugin", (Object[])new Object[0])));
            items.add(comboItem);
            splitTypes.setComboItems(items);
        } else {
            ComboEdit splitwords = (ComboEdit)this.getControl(SPLITWORD);
            splitwords.setComboItems(this.getItems(eventnumber));
        }
        if (isCosmic || BILLID.equalsIgnoreCase((String)this.getModel().getValue(SPLITTYPE))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SPLITWORD});
        }
    }

    private List<ComboItem> getItems(String eventnumber) {
        QFilter filter = new QFilter(NUMBER, "=", (Object)eventnumber);
        DynamicObjectCollection tmp = QueryServiceHelper.query((String)"evt_event", (String)"number,config.configname,config.confignumber,config.configtype,config.configdescription", (QFilter[])new QFilter[]{filter});
        Iterator iter = tmp.iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        while (iter.hasNext()) {
            Map argsCfg;
            String valueType;
            DynamicObject obj = (DynamicObject)iter.next();
            String cfgJson = obj.getString("config.configtype");
            if (!WfUtils.isNotEmpty((String)cfgJson) || !"String".equalsIgnoreCase(valueType = (String)(argsCfg = (Map)SerializationUtils.fromJsonString((String)cfgJson, Map.class)).get(EVENTTYPE))) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(obj.getString("config.confignumber"));
            comboItem.setCaption(new LocaleString(obj.getString("config.configname")));
            items.add(comboItem);
        }
        return items;
    }

    private void setValue(String key, Object value) {
        if (value != null) {
            this.getModel().setValue(key, value);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{SPLITWORD, SPLITTYPE, BTNOK, BTNCANCEL});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase(BTNOK)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        String splittype = (String)this.getModel().getValue(SPLITTYPE);
        if (WfUtils.isEmpty((String)splittype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62c6\u5206\u4f9d\u636e\u201d\u3002", (String)"EventSplitPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            return;
        }
        String splitsize = (String)this.getModel().getValue(SPLITSIZE);
        if (WfUtils.isNotEmpty((String)splitsize) && !this.matchPattern(SPLITSIZE_REGULAR, splitsize)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u53c2\u6570\u8bf7\u586b\u51991000\u4ee5\u5185\u7684\u6574\u6570\u3002", (String)"EventSplitPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject json = new JSONObject();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        boolean isCustom = EVENTTYPE_CUSTOM.equalsIgnoreCase((String)showParameter.getCustomParam(EVENTTYPE));
        if (isCustom && !BILLID.equalsIgnoreCase((String)this.getModel().getValue(SPLITTYPE))) {
            String splitword = (String)this.getModel().getValue(SPLITWORD);
            if (WfUtils.isEmpty((String)splitword)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e8b\u4ef6\u53c2\u6570\u201d\u3002", (String)"EventSplitPlugin_3", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                return;
            }
            json.put(SPLITWORD, (Object)splitword);
        }
        json.put(SPLITTYPE, (Object)splittype);
        json.put(SPLITSIZE, (Object)splitsize);
        this.getView().returnDataToParent((Object)json);
        this.getView().close();
    }

    private boolean matchPattern(String patternStr, String value) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (SPLITTYPE.equals(propName)) {
            this.getModel().getDataEntity();
            String value = (String)e.getChangeSet()[0].getNewValue();
            this.getView().setVisible(Boolean.valueOf(!BILLID.equalsIgnoreCase(value)), new String[]{SPLITWORD});
        }
    }
}

