/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.service.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.service.formplugin.EvtTriggerHttpCfgPlugin;
import kd.bos.bec.util.HttpClientUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang.exception.ExceptionUtils;

public class EvtHttpPlugin
extends EvtTriggerHttpCfgPlugin {
    public static final String CERTIFICATION = "certification";
    public static final String CERTIFICATION_CIPHER = "cipher";
    public static final String CERTIFICATION_CLIENT = "client_credentials";
    public static final String TOKENURL = "tokenurl";
    public static final String CLIENTID = "clientid";
    public static final String CLIENTSECRET = "clientsecret";
    public static final String TOKENPATH = "tokenpath";
    public static final String TOKENKEY = "tokenkey";
    public static final String URL = "url";
    public static final String HEAD = "head";
    public static final String BODY = "body";
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("connect".equals(key)) {
            this.tryTrigger();
        } else {
            super.click(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryTrigger() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u8c03\u7528http\u670d\u52a1\uff1a", (String)"BusinessSubscriptionModelPlugin_17", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            IDataModel model = this.getModel();
            String requestType = (String)model.getValue("requesttype");
            String url = (String)model.getValue(URL);
            String authType = (String)model.getValue("authtype");
            Map<String, Object> tmp = this.getMapData(HEAD, "headkey", "headvalue", "headtestvalue");
            HashMap<String, String> header = new HashMap<String, String>(tmp.size());
            header.put("Content-Type", "application/json");
            for (Map.Entry<String, Object> entry : tmp.entrySet()) {
                header.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.putAll(this.getMapData(BODY, "bodykey", "bodyvalue", "bodytestvalue"));
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.putAll(this.getMapData("urlentry", "urlkey", "urlvalue", "urltestvalue"));
            url = this.buildURL(url, urlParams);
            if (!"noAuth".equals(authType)) {
                String authConfigJson = (String)model.getValue("authcconfig");
                String tokenKey = (String)model.getValue(TOKENKEY);
                String tokenPosition = (String)model.getValue("tokenposition");
                Map authConfig = (Map)SerializationUtils.fromJsonString((String)authConfigJson, Map.class);
                String token = this.getToken(authConfig);
                if (this.isEmpty(token)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ee4\u724c\u83b7\u53d6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6388\u6743\u914d\u7f6e\u3002", (String)"EvtHttpPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                    return;
                }
                switch (tokenPosition) {
                    case "head": {
                        header.put(tokenKey, token);
                        break;
                    }
                    case "body": {
                        body.put(tokenKey, token);
                        break;
                    }
                    case "url": {
                        url = url.contains("?") ? String.format("%s&%s=%s", url, tokenKey, token) : String.format("%s?%s=%s", url, tokenKey, token);
                        break;
                    }
                    default: {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4ee4\u724c\u62fc\u63a5\u5931\u8d25\uff0c\u524d\u68c0\u67e5\u4ee4\u724c\u4f4d\u7f6e\uff0ctoken\u201c%s\u201d\u3002", (String)"EvtHttpPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]), token));
                        return;
                    }
                }
            }
            String result = "";
            if ("GET".equals(requestType)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u901a\u8fc7GET\u65b9\u5f0f\u8c03\u7528http\uff0c\u53c2\u6570\u3010url=%1$S,header=%2$S,body=%3$S\u3011\uff0c", (String)"BusinessSubscriptionModelPlugin_18", (String)"bos-bec-formplugin", (Object[])new Object[0]), url, SerializationUtils.toJsonString(header), SerializationUtils.toJsonString(body)));
                result = HttpClientUtil.get(url, header, body);
            } else {
                String bjson = SerializationUtils.toJsonString(body);
                sb.append(String.format(ResManager.loadKDString((String)"\u901a\u8fc7POST\u65b9\u5f0f\u8c03\u7528http\uff0c\u53c2\u6570\u3010url=%1$S,header=%2$S,body=%3$S\u3011\uff0c", (String)"BusinessSubscriptionModelPlugin_19", (String)"bos-bec-formplugin", (Object[])new Object[0]), url, SerializationUtils.toJsonString(header), bjson));
                result = HttpClientUtil.postjson(url, header, bjson);
            }
            sb.append(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\uff1a\u3010%s\u3011\uff0c", (String)"BusinessSubscriptionModelPlugin_20", (String)"bos-bec-formplugin", (Object[])new Object[0]), result));
            String statePath = (String)model.getValue("statepath");
            if (statePath != null && !"".equals(statePath.trim())) {
                String successCode = (String)model.getValue("successcode");
                if (this.isEmpty(result)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528http\u540e\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u62ff\u5230\u72b6\u6001\u8def\u5f84\u3002", (String)"EvtHttpPlugin_6", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                    return;
                }
                JSONObject rsJson = JSON.parseObject((String)result);
                String[] path = statePath.split("\\.");
                Object t = rsJson;
                for (int i = 0; i < path.length; ++i) {
                    if (t == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528http\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u9519\u8bef\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"EvtHttpPlugin_7", (String)"bos-bec-formplugin", (Object[])new Object[0]), rsJson));
                        return;
                    }
                    t = t.get((Object)path[i]);
                }
                if (!successCode.equals(String.valueOf(t))) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528http\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u9519\u8bef\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u201c%s\u201d\u3002", (String)"EvtHttpPlugin_8", (String)"bos-bec-formplugin", (Object[])new Object[0]), rsJson));
                    return;
                }
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u201c%s\u201d\u3002", (String)"EvtHttpPlugin_9", (String)"bos-bec-formplugin", (Object[])new Object[0]), rsJson), Integer.valueOf(5000));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49\u7ed3\u679c\u63cf\u8ff0\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a%s\u3002", (String)"EvtHttpPlugin_10", (String)"bos-bec-formplugin", (Object[])new Object[0]), result));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a\u201c%s\u201d\u3002", (String)"EvtHttpPlugin_11", (String)"bos-bec-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.log.warn(String.format("\u6d4b\u8bd5\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a\u201c%s\u201d\u3002", ExceptionUtils.getStackTrace((Throwable)e)));
        }
        finally {
            this.log.debug(sb.toString());
        }
    }

    private String getToken(Map<String, Object> authConfig) throws IOException {
        JSONObject rsJson;
        String certification = (String)authConfig.get(CERTIFICATION);
        String tokenUrl = (String)authConfig.get(TOKENURL);
        JSONObject params = new JSONObject();
        String authType = (String)this.getModel().getValue("authtype");
        if ("auth".equals(authType)) {
            params.put("grant_type", (Object)certification);
            params.put("client_id", authConfig.get(CLIENTID));
            if (!CERTIFICATION_CIPHER.equals(certification)) {
                params.put("client_secret", authConfig.get(CLIENTSECRET));
            }
        }
        List extParams = (List)authConfig.get("extparams");
        for (Map map : extParams) {
            String key = (String)map.get("key");
            Object value = map.get("value");
            Object testValue = map.get("testvalue");
            if (this.isEmpty(key) || value == null || testValue == null) continue;
            params.put(key, testValue);
        }
        HashMap<String, String> tokenHeader = new HashMap<String, String>();
        tokenHeader.put("Content-Type", "application/json");
        String bodyJson = SerializationUtils.toJsonString((Object)params);
        String tokenJson = HttpClientUtil.postjson(tokenUrl, tokenHeader, bodyJson);
        String tokenPath = (String)authConfig.get(TOKENPATH);
        if (this.isEmpty(tokenJson)) {
            return null;
        }
        String[] path = tokenPath.split("\\.");
        Object tmp = rsJson = JSON.parseObject((String)tokenJson);
        String token = "";
        for (int i = 0; i < path.length; ++i) {
            if ((tmp = tmp.get((Object)path[i])) != null) continue;
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u6309\u7167\u4ee4\u724c\u8def\u5f84\u83b7\u53d6\u4e0d\u5230\u4ee4\u724c\uff0c\u8bf7\u68c0\u67e5\u6388\u6743\u914d\u7f6e\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a\u201c%s\u201d\u3002", (String)"EvtHttpPlugin_12", (String)"bos-bec-formplugin", (Object[])new Object[0]), tokenJson));
        }
        token = (String)tmp;
        return token;
    }

    private Map<String, Object> getMapData(String entryName, String keyName, String valueName, String testValueName) {
        AbstractGrid grid = (AbstractGrid)this.getControl(entryName);
        DynamicObjectCollection col = grid.getModel().getEntryEntity(entryName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (DynamicObject i : col) {
            String keyResult = i.getString(keyName);
            String valueResult = i.getString(valueName);
            String testValue = i.getString(testValueName);
            if (keyResult == null || "".equals(keyResult) || valueResult == null || testValue == null) continue;
            result.put(keyResult, testValue);
        }
        return result;
    }

    private String buildURL(String url, Map<String, Object> extURL) {
        String newURL;
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(url);
        if (!extURL.isEmpty()) {
            urlBuilder.append('?');
            Set<Map.Entry<String, Object>> entrys = extURL.entrySet();
            for (Map.Entry<String, Object> entry : entrys) {
                urlBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
            }
        }
        newURL = (newURL = urlBuilder.toString()).endsWith("&") ? newURL.substring(0, newURL.length() - 1) : newURL;
        return newURL;
    }
}

