/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.service.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.WfUtils;

public class OperateParamsConfigPlugin
extends AbstractFormPlugin
implements ClickListener,
CellClickListener,
BeforeF7SelectListener {
    public static final String ENTRYKEY = "entryentity";
    public static final String BTNNEW = "btnnew";
    public static final String BTNDEL = "btndel";
    public static final String OPERATEPARAM = "operateparam";
    public static final String OPERATEPARAMVALUE = "operateparamvalue";
    public static final String OPERATEPARAMTYPE = "operateparamtype";
    public static final String OPERATEPARAMTYPECUSTOM = "operateparamtypecustom";
    public static final String ADVCONTOOLBARAP = "advcontoolbarap";
    public static final String BTNOK = "btnok";
    public static final String BTNCANCEL = "btncancel";
    public static final String OPERPARAM_REGULAR = "^[A-Za-z][A-Za-z0-9_.]*$";
    public static final String OPERPVALUE_REGULAR = "[,/]";
    public static final String OPERATEPARAMSCONF = "operateparamsconf";
    public static final String OPERATEPARAMSCONFPLUGIN = "operateparamsconfplugin";
    public static final String EVENTTYPE = "type";
    public static final String EVENTTYPE_COSMIC = "cosmic";
    public static final String EVENTTYPE_CUSTOM = "custom";

    public void afterCreateNewData(EventObject e) {
        String[] operateparams;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String operateparamsconf = (String)showParameter.getCustomParam(OPERATEPARAMSCONF);
        boolean isCosmic = EVENTTYPE_COSMIC.equalsIgnoreCase((String)showParameter.getCustomParam(EVENTTYPE));
        if (isCosmic) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OPERATEPARAMTYPECUSTOM});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OPERATEPARAMTYPE});
        }
        if (WfUtils.isNotEmpty((String)operateparamsconf) && (operateparams = operateparamsconf.split(",")) != null && operateparams.length > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRYKEY, operateparams.length);
            for (int i = 0; i < operateparams.length; ++i) {
                String operateparamsIndex = operateparams[i].substring(1, operateparams[i].length() - 1);
                String[] operateparam = operateparamsIndex.split("/");
                if (operateparam == null || operateparam.length < 2) continue;
                String operateparamtype = operateparam[0];
                if (isCosmic) {
                    model.setValue(OPERATEPARAMTYPE, (Object)operateparamtype, i);
                }
                if ("1".equalsIgnoreCase(operateparamtype)) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{OPERATEPARAMVALUE});
                }
                model.setValue(OPERATEPARAM, (Object)operateparam[1], i);
                if (operateparam.length < 3 || !"0".equalsIgnoreCase(operateparamtype)) continue;
                model.setValue(OPERATEPARAMVALUE, (Object)operateparam[2], i);
            }
        }
        if (OPERATEPARAMSCONFPLUGIN.equals(showParameter.getCustomParam(OPERATEPARAMSCONFPLUGIN))) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u63d2\u4ef6\u53c2\u6570\u914d\u7f6e", (String)"OperateParamsConfigPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0])));
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ENTRYKEY, BTNNEW, BTNDEL, BTNOK, BTNCANCEL});
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btnnew": {
                this.getModel().createNewEntryRow(ENTRYKEY);
                break;
            }
            case "btndel": {
                EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYKEY);
                int[] delRows = grid.getSelectRows();
                this.getModel().deleteEntryRows(ENTRYKEY, delRows);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase(BTNOK)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        int count = this.getModel().getEntryRowCount(ENTRYKEY);
        ArrayList<String> operateParameters = null;
        if (count > 0) {
            operateParameters = new ArrayList<String>(count);
            HashSet<String> set = new HashSet<String>(count);
            for (int i = 0; i < count; ++i) {
                String operateparam = (String)this.getModel().getValue(OPERATEPARAM, i);
                if (WfUtils.isEmpty((String)operateparam)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570\u7f16\u7801\u201d\u3002", (String)"OperateParamsConfigPlugin_2", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (set.contains(operateparam = operateparam.trim())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u53c2\u6570\u7f16\u7801\u3002", (String)"OperateParamsConfigPlugin_3", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                    return;
                }
                set.add(operateparam);
                if (!this.matchPattern(OPERPARAM_REGULAR, operateparam)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u53c2\u6570\u7f16\u7801\u201d\u8bf7\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"OperateParamsConfigPlugin_4", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                boolean isComic = EVENTTYPE_COSMIC.equalsIgnoreCase((String)showParameter.getCustomParam(EVENTTYPE));
                String operateparamtype = "0";
                if (isComic) {
                    operateparamtype = (String)this.getModel().getValue(OPERATEPARAMTYPE, i);
                }
                String operateparamvalue = (String)this.getModel().getValue(OPERATEPARAMVALUE, i);
                if ("0".equals(operateparamtype)) {
                    if (WfUtils.isEmpty((String)operateparamvalue)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u4e3a\u56fa\u5b9a\u503c\u65f6\u8bf7\u586b\u5199\u53c2\u6570\u503c\u3002", (String)"OperateParamsConfigPlugin_5", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (this.matchPattern(OPERPVALUE_REGULAR, operateparamvalue)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u503c\u4e0d\u80fd\u5305\u542b\",\"\u6216\u8005\"/\"\u3002", (String)"OperateParamsConfigPlugin_6", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    operateParameters.add(String.format("{%1$s/%2$s/%3$s}", "0", operateparam, operateparamvalue));
                }
                if (!"1".equals(operateparamtype)) continue;
                operateParameters.add(String.format("{%1$s/%2$s}", "1", operateparam));
            }
        }
        this.getView().returnDataToParent((Object)(operateParameters == null ? "empty" : String.join((CharSequence)",", operateParameters)));
        this.getView().close();
    }

    private boolean matchPattern(String patternStr, String value) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (OPERATEPARAMTYPE.equals(propName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if ("1".equalsIgnoreCase((String)e.getChangeSet()[0].getNewValue())) {
                IDataModel model = this.getModel();
                model.setValue(OPERATEPARAMVALUE, null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{OPERATEPARAMVALUE});
            }
            if ("0".equalsIgnoreCase((String)e.getChangeSet()[0].getNewValue())) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{OPERATEPARAMVALUE});
            }
        }
    }
}

