/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.subscription.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.util.PluginUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class BecEventListPlugin
extends AbstractListPlugin
implements ClickListener {
    public static final String BARDELETE = "bardelete";
    public static final String EVT_EVENT = "evt_event";
    private static final String ISPREINSDATA = "ispreinsdata";
    private static final String ISMODIFIED = "ismodified";

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5b9a\u4e49", (String)"BecEventListPlugin_0", (String)"bos-bec-formplugin", (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject evt) {
        PluginUtil.eventNumberViewRepair();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        Object key = evt.getSource();
        if (key instanceof Delete) {
            ListSelectedRowCollection ids = evt.getListSelectedData();
            List<Object> list = PluginUtil.collectionToList(ids);
            DynamicObjectCollection dyObj = QueryServiceHelper.query((String)EVT_EVENT, (String)"ispreinsdata,ismodified", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
            for (int i = 0; i < dyObj.size(); ++i) {
                if (!((DynamicObject)dyObj.get(i)).getBoolean(ISPREINSDATA) || !((DynamicObject)dyObj.get(i)).getBoolean(ISMODIFIED)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u4e8b\u4ef6\u4e0d\u80fd\u5220\u9664\u3002", (String)"BecEventListPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        StringBuilder eventNumberView = new StringBuilder();
        if (null != evt.getOperationResult()) {
            List ids = evt.getOperationResult().getSuccessPkIds();
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
            DynamicObjectCollection eventEntitys = QueryServiceHelper.query((String)EVT_EVENT, (String)"id,numberview", (QFilter[])filters);
            for (int i = 0; i < eventEntitys.size(); ++i) {
                eventNumberView.append(((DynamicObject)eventEntitys.get(i)).get("numberview")).append(",");
            }
        }
        if ("enable".equals(key = evt.getOperateKey())) {
            this.enableOrDisableEvent(evt, true);
            String enableName = ResManager.getLocaleString((String)"\u542f\u7528", (String)"BecEventListPlugin_4", (String)"bos-bec-formplugin").getLocaleValue_zh_CN();
            WfUtils.addOpLog((String)EVT_EVENT, (String)"enable", (String)enableName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\u201c%s\u201d\u542f\u7528\u6210\u529f\u3002", "BecEventListPlugin_2", "bos-bec-formplugin"), (Object[])new Object[]{eventNumberView});
        } else if ("disable".equals(key)) {
            this.enableOrDisableEvent(evt, false);
            String disableName = ResManager.getLocaleString((String)"\u7981\u7528", (String)"BecEventListPlugin_5", (String)"bos-bec-formplugin").getLocaleValue_zh_CN();
            WfUtils.addOpLog((String)EVT_EVENT, (String)"disable", (String)disableName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\u201c%s\u201d\u7981\u7528\u6210\u529f\u3002", "BecEventListPlugin_3", "bos-bec-formplugin"), (Object[])new Object[]{eventNumberView});
        } else if ("refresh".equals(key)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BARDELETE});
            this.refresh();
        }
    }

    private void refresh() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection key = evt.getListSelectedRowCollection();
        PluginUtil.judgePreinsData(key, this, EVT_EVENT);
    }

    private void enableOrDisableEvent(AfterDoOperationEventArgs evt, boolean enable) {
        List savedPks = evt.getOperationResult().getSuccessPkIds();
        if (savedPks == null || savedPks.size() < 1) {
            return;
        }
        DynamicObject[] preDeleteDatas = BusinessDataServiceHelper.load((Object[])savedPks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)EVT_EVENT));
        if (preDeleteDatas == null || preDeleteDatas.length < 1) {
            return;
        }
        HashSet<String> entityNumberSet = new HashSet<String>();
        ArrayList<String> eventNumList = new ArrayList<String>(4);
        for (DynamicObject obj : preDeleteDatas) {
            String evtNumber = obj.getString("number");
            eventNumList.add(evtNumber);
            if (evtNumber.contains(".")) {
                entityNumberSet.add(evtNumber.split("\\.")[0]);
                continue;
            }
            entityNumberSet.add("defaultGroup");
        }
        if (!entityNumberSet.isEmpty()) {
            Iterator iterator = entityNumberSet.iterator();
            while (iterator.hasNext()) {
                EvtCacheHelper.removeCacheEvent((String)((String)iterator.next()));
            }
        }
        EvtCacheHelper.removeCacheSubscriptionMap(eventNumList);
        EvtCacheHelper.removeCacheEventMap(eventNumList);
    }
}

