/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.subscription.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class BecTreeListPlugin
extends StandardTreeListPlugin {
    public void initializeTree(EventObject e) {
        this.getTreeModel().setRoot(BecTreeListPlugin.loadAllAppNodes());
    }

    public void treeNodeClick(TreeNodeEvent nodeEvent) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        JSONArray appids = new JSONArray();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(nodeId, 5);
        String nodeType = (String)current.getData();
        if (nodeType.equals("cloud")) {
            appids = BecTreeListPlugin.getAppIdsByCloudId(nodeId);
        } else if (nodeType.equals("app")) {
            appids = BecTreeListPlugin.getUnitsByAppId(nodeId);
        } else if (nodeType.equals("root")) {
            return;
        }
        QFilter qFilter = new QFilter("source", "in", (Object)appids);
        e.addQFilter(qFilter);
        e.setCancel(true);
    }

    private static TreeNode loadAllAppNodes() {
        return (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])null, (String[])null, (String)null, null);
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        TreeNode curentNode = root.getTreeNode(e.getNodeId().toString(), 20);
        e.setChildNodes(curentNode.getChildren());
    }

    public static JSONArray getAppIdsByCloudId(String bizCloudId) {
        JSONArray unitIds = new JSONArray();
        List lstAppInfo = BizAppServiceHelp.getAppsRuntimeInfoByCloudId((String)bizCloudId);
        if (lstAppInfo != null && lstAppInfo.size() > 0) {
            for (String lstAppInfwwo : lstAppInfo) {
                Map app = (Map)SerializationUtils.fromJsonString((String)lstAppInfwwo, Map.class);
                String bizAppId = (String)app.get("id");
                unitIds.add((Object)bizAppId);
            }
        }
        return unitIds;
    }

    public static JSONArray getUnitsByAppId(String appId) {
        JSONArray unitIds = new JSONArray();
        unitIds.add((Object)appId);
        return unitIds;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String nodeType;
        TreeNode root;
        TreeNode current;
        if (e.getParameter().getBillStatusValue().equals(BillOperationStatus.ADDNEW.ordinal()) && (current = (root = this.getTreeModel().getRoot()).getTreeNode((String)this.getTreeModel().getCurrentNodeId(), 5)) != null && (nodeType = (String)current.getData()).equals("app")) {
            e.getParameter().setCustomParam("appId", (Object)current.getId());
        }
        super.beforeShowBill(e);
    }
}

