/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.subscription.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bec.util.PluginUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;

public class EventSubscriptionListPlugin
extends AbstractListPlugin
implements ClickListener {
    public static final String COPY_SUBSCRIPTION = "copySubscription";
    public static final String PREDELETESUBSCRIPTIONS = "PreDeleteSubscriptions";
    public static final String PREENABLESUBSCRIPTIONS = "PreEnableSubscriptions";
    public static final String EVENTNUMBER = "eventnumber";
    public static final String BARDELETE = "bardelete";
    public static final String DUPLICATE = "duplicate";

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e8b\u4ef6\u8ba2\u9605", (String)"EventSubscriptionListPlugin_0", (String)"bos-bec-formplugin", (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject evt) {
        PluginUtil.eventNumberViewRepair();
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection key = evt.getListSelectedRowCollection();
        PluginUtil.judgePreinsData(key, this, "evt_subscription");
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BARDELETE.equals(key)) {
            ListView view = (ListView)this.getView();
            ListSelectedRowCollection rows = view.getSelectedRows();
            if (!rows.isEmpty()) {
                Object[] pkArr = new Object[rows.size()];
                for (int i = 0; i < rows.size(); ++i) {
                    pkArr[i] = rows.get(i).getPrimaryKeyValue();
                }
                DynamicObject[] preDeleteDatas = BusinessDataServiceHelper.load((Object[])pkArr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"evt_subscription"));
                HashMap<String, String> preDeleteSubscriptions = new HashMap<String, String>(preDeleteDatas.length);
                for (DynamicObject d : preDeleteDatas) {
                    preDeleteSubscriptions.put(String.valueOf(d.getPkValue()), d.getString(EVENTNUMBER));
                }
                this.getPageCache().put(PREDELETESUBSCRIPTIONS, SerializationUtils.toJsonString(preDeleteSubscriptions));
            }
        } else if (DUPLICATE.equals(key)) {
            this.duplicateModel();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListView view;
        ListSelectedRowCollection rows;
        if (args.getSource() instanceof Delete && !(rows = (view = (ListView)this.getView()).getSelectedRows()).isEmpty()) {
            ArrayList<Object> pkList = new ArrayList<Object>(rows.size());
            for (ListSelectedRow row : rows) {
                pkList.add(row.getPrimaryKeyValue());
            }
            this.deleteRuleRelaData(pkList);
        }
    }

    private void deleteRuleRelaData(List pkList) {
        String sql = "DELETE FROM T_EVT_RULESHIELDSUBS WHERE FSUBSCRIPTIONID in ( ? ) ;";
        WfDBUtils.executeBatchDeleteByIn((String)sql, (List)pkList, (Integer)500, (boolean)true);
    }

    private void duplicateModel() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"0P2FWW95+QU6", (String)"evt_subscription", (String)"47156aff000000ac")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4e8b\u4ef6\u8ba2\u9605\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BusinessSubscriptionModelPlugin_16", (String)"bos-bec-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        if (rows.size() > 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
        } else {
            Long id = (Long)rows.get(0).getPrimaryKeyValue();
            this.openModelWindow("evt_subscription", id);
        }
    }

    private void openModelWindow(String formId, Object id) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("type", (Object)"copy");
        if (id != null) {
            parameter.setCustomParam("pkid", id);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, COPY_SUBSCRIPTION);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String callBackID = event.getActionId();
        if (COPY_SUBSCRIPTION.equals(callBackID)) {
            this.refresh();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key = evt.getOperateKey();
        if ("delete".equals(key)) {
            List savedPks = evt.getOperationResult().getSuccessPkIds();
            if (savedPks == null || savedPks.size() < 1) {
                return;
            }
            HashSet<String> entityNumberSet = new HashSet<String>();
            ArrayList<String> eventNumList = new ArrayList<String>();
            String preDeleteSubscriptionsJson = this.getPageCache().get(PREDELETESUBSCRIPTIONS);
            if (PluginUtil.isNotEmpty(preDeleteSubscriptionsJson)) {
                Map preDeleteDatas = (Map)SerializationUtils.fromJsonString((String)preDeleteSubscriptionsJson, Map.class);
                for (Object pk : savedPks) {
                    String evtNumber = (String)preDeleteDatas.get(String.valueOf(pk));
                    eventNumList.add(evtNumber);
                    if (evtNumber.contains(".")) {
                        entityNumberSet.add(evtNumber.split("\\.")[0]);
                        continue;
                    }
                    entityNumberSet.add("defaultGroup");
                }
            }
            if (!entityNumberSet.isEmpty()) {
                Iterator iterator = entityNumberSet.iterator();
                while (iterator.hasNext()) {
                    EvtCacheHelper.removeCacheEvent((String)((String)iterator.next()));
                }
            }
            EvtCacheHelper.removeCacheSubscriptionMap(eventNumList);
            EvtCacheHelper.removeCacheEventMap(eventNumList);
            this.getPageCache().remove(PREDELETESUBSCRIPTIONS);
        } else if ("enable".equals(key)) {
            this.enableOrDisableEvent(evt, true);
        } else if ("disable".equals(key)) {
            this.enableOrDisableEvent(evt, false);
        } else if ("refresh".equals(key)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BARDELETE});
        }
    }

    private void enableOrDisableEvent(AfterDoOperationEventArgs evt, boolean enable) {
        List savedPks = evt.getOperationResult().getSuccessPkIds();
        if (savedPks == null || savedPks.size() < 1) {
            return;
        }
        DynamicObject[] savedSubscriptions = BusinessDataServiceHelper.load((Object[])savedPks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"evt_subscription"));
        if (savedSubscriptions == null || savedSubscriptions.length < 1) {
            return;
        }
        HashSet<String> entityNumberSet = new HashSet<String>();
        ArrayList<String> eventNumList = new ArrayList<String>(4);
        for (DynamicObject o : savedSubscriptions) {
            String evtNumber = o.getString(EVENTNUMBER);
            eventNumList.add(evtNumber);
            if (evtNumber.contains(".")) {
                entityNumberSet.add(evtNumber.split("\\.")[0]);
                continue;
            }
            entityNumberSet.add("defaultGroup");
        }
        if (!entityNumberSet.isEmpty()) {
            Iterator iterator = entityNumberSet.iterator();
            while (iterator.hasNext()) {
                EvtCacheHelper.removeCacheEvent((String)((String)iterator.next()));
            }
        }
        EvtCacheHelper.removeCacheSubscriptionMap(eventNumList);
        EvtCacheHelper.removeCacheEventMap(eventNumList);
    }

    private void refresh() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }
}

