/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.util;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.util.PluginUtil;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class EventHelperPlugin
extends AbstractFormPlugin {
    public static final String CACHE_BTN_REMOVECACHE = "removecache";
    public static final String CACHE_BTN_REFRESHCACHE = "refreshcache";
    public static final String CACHE_BTN_GETCACHE = "get";
    public static final String CACHE_BTN_GETSETVALUES = "getsetvalues";
    public static final String CACHE_BTN_GETALL = "getall";
    public static final String CACHE_BTN_ADDCACHE = "addcache";
    public static final String CACHE_CACHEKEY = "cachekey";
    public static final String CACHE_CACHEVALUE = "cachevalue";
    public static final String CACHE_SHOW = "show";
    public static final String DELETEEVTLOG = "deleteevtlog";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CACHE_BTN_REMOVECACHE, CACHE_BTN_GETCACHE, CACHE_BTN_GETSETVALUES, CACHE_BTN_GETALL, CACHE_BTN_ADDCACHE, DELETEEVTLOG});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        DistributeSessionlessCache disCache = PluginUtil.getDisCache();
        String cacheKey = (String)this.getModel().getValue(CACHE_CACHEKEY);
        String cacheValue = (String)this.getModel().getValue(CACHE_CACHEVALUE);
        switch (key) {
            case "removecache": {
                disCache.remove(EvtCacheHelper.getWholeKey((String[])new String[0]) + "." + cacheKey);
                break;
            }
            case "get": {
                String value = (String)disCache.get(EvtCacheHelper.getWholeKey((String[])new String[0]) + "." + cacheKey);
                this.getModel().setValue(CACHE_SHOW, (Object)value);
                break;
            }
            case "getsetvalues": {
                String[] values = disCache.getSetValues(EvtCacheHelper.getWholeKey((String[])new String[0]) + "." + cacheKey);
                StringBuilder sb = new StringBuilder();
                for (String s : values) {
                    sb.append(s).append(',');
                }
                if (sb.length() <= 0) break;
                this.getModel().setValue(CACHE_SHOW, (Object)sb.subSequence(0, sb.length() - 1));
                break;
            }
            case "getall": {
                Map v = disCache.getAll(EvtCacheHelper.getWholeKey((String[])new String[0]) + "." + cacheKey);
                if (v == null) break;
                this.getModel().setValue(CACHE_SHOW, (Object)SerializationUtils.toJsonString((Object)v));
                break;
            }
            case "addcache": {
                disCache.addToSet(EvtCacheHelper.getWholeKey((String[])new String[0]) + "." + cacheKey, cacheValue.split("\\,"));
                break;
            }
            case "deleteevtlog": {
                this.deleteEvtlog();
                break;
            }
        }
    }

    private void deleteEvtlog() {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        service.getHistoryService().deleteEventFinishedDatas();
    }
}

