/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.util;

import com.alibaba.fastjson.JSONObject;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.service.formplugin.EvtPluginConfigPlugin;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.beanutils.MethodUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

@SdkInternal
public class PluginUtil {
    private static Log logger = LogFactory.getLog(PluginUtil.class);
    public static final String BOS_BEC_FORMPLUGIN = "bos-bec-formplugin";
    public static final String TABKEY = "_submaintab_";
    public static final String BARDELETE = "bardelete";
    public static final String ISPREINSDATA = "ispreinsdata";
    public static final String ISMODIFIED = "ismodified";
    public static final String ID = "id";
    public static final String CREATEDATE = "createdate";
    public static final String EVT_PLUGINCONFIG = "evt_pluginconfig";
    public static final String CLASS = "class";
    private static DistributeSessionlessCache disCache = null;
    private static final String EMAILCONTENT = "emailContent";
    private static final String EMAILTITLE = "emailTitle";
    private static final String CONTENT = "content";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String PASSOPERPARAM = "passoperparam";

    public static DistributeSessionlessCache getDisCache() {
        if (disCache == null) {
            disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy());
        }
        return disCache;
    }

    public static void existBill(AbstractListPlugin plugin, ListSelectedRowCollection rows, Long jobrecordid) {
        String businesskey = null;
        String entitynumber = null;
        String hisbs = "SELECT FBUSINESSKEY,FENTITYNUMBER  FROM T_EVT_HIJOBRECORD WHERE FID = ? ";
        try (DataSet ds = DB.queryDataSet((String)"EventJobPlugin", (DBRoute)DBRoute.workflow, (String)hisbs, (Object[])new Object[]{jobrecordid});){
            for (Row row : ds) {
                businesskey = row.getString("fbusinesskey");
                entitynumber = row.getString("fentitynumber");
            }
        }
        if (PluginUtil.isEmpty(businesskey) || PluginUtil.isEmpty(entitynumber)) {
            String sbs = "SELECT FBUSINESSKEY,FENTITYNUMBER  FROM T_EVT_JOBRECORD WHERE FID = ? ";
            try (DataSet ds = DB.queryDataSet((String)"EventJobPlugin", (DBRoute)DBRoute.workflow, (String)sbs, (Object[])new Object[]{jobrecordid});){
                for (Row row : ds) {
                    businesskey = row.getString("fbusinesskey");
                    entitynumber = row.getString("fentitynumber");
                }
            }
        }
        try {
            if (ORM.create().exists(entitynumber, (Object)businesskey)) {
                PluginUtil.openBill(plugin, rows, jobrecordid, businesskey, entitynumber);
            } else {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"PluginUtil_8", (String)BOS_BEC_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
        catch (Exception e) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)"PluginUtil_8", (String)BOS_BEC_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public static void openBill(AbstractListPlugin plugin, ListSelectedRowCollection rows, Long jobrecordid, String businesskey, String entitynumber) {
        if (PluginUtil.hasCurrentPageTab(jobrecordid, "showBill", plugin.getView())) {
            return;
        }
        String billFormId = ((ListShowParameter)plugin.getView().getFormShowParameter()).getBillFormId();
        IFormView settingsFormView = PluginUtil.getTargetView(plugin);
        FormShowParameter parameter = new FormShowParameter();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entitynumber);
        LocaleString localString = formConfig.getCaption();
        parameter.getCustomParams().put("rows", rows);
        parameter.getCustomParams().put("pkId", businesskey);
        parameter.getCustomParams().put("BillFormId", billFormId);
        parameter.getCustomParams().put("taskId", jobrecordid);
        String appId = PluginUtil.getAppIdForEntity(entitynumber);
        parameter.getCustomParams().put("ServiceAppId", appId);
        parameter.getCustomParams().put("formId", entitynumber);
        parameter.setCaption(localString.getLocaleValue());
        parameter.setCustomParam("listView", (Object)plugin.getView().getPageId());
        parameter.setFormId("wf_openbills");
        parameter.setPageId(PluginUtil.getPageId(jobrecordid, "showBill", plugin.getView().getParentView()));
        parameter.getOpenStyle().setTargetKey(TABKEY);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (settingsFormView != null) {
            settingsFormView.showForm(parameter);
            plugin.getView().sendFormAction(settingsFormView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            plugin.getView().showForm(parameter);
        }
    }

    public static IFormView getTargetView(AbstractListPlugin plugin) {
        IFormView parentView = plugin.getView();
        while ((parentView = parentView.getParentView()) != null && !"pc_main_console".equals(parentView.getFormShowParameter().getFormId())) {
            Control control = parentView.getControl(TABKEY);
            if (control == null) continue;
            return parentView;
        }
        return null;
    }

    public static boolean isEmpty(ILocaleString value) {
        if (value == null || value.keySet().isEmpty()) {
            return true;
        }
        for (String key : value.keySet()) {
            if (!PluginUtil.isNotEmpty((String)value.get((Object)key))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(ILocaleString value) {
        return !PluginUtil.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() <= 0;
    }

    public static boolean isNotEmpty(String value) {
        return !PluginUtil.isEmpty(value);
    }

    public static IFormView getTabControlView(IFormView view) {
        IFormView parentView = view;
        while ((parentView = parentView.getParentView()) != null && !"pc_main_console".equals(parentView.getFormShowParameter().getFormId())) {
            Control control = parentView.getControl(TABKEY);
            if (control == null) continue;
            return parentView;
        }
        return null;
    }

    public static String getPageIdKey(long taskId, String type, IFormView view) {
        String pageIdkey = type + taskId;
        if (null != RequestContext.get()) {
            pageIdkey = pageIdkey + RequestContext.get().getUserId();
        }
        if (null != view) {
            pageIdkey = pageIdkey + view.getPageId();
        }
        return pageIdkey;
    }

    public static String getPageId(long taskId, String type, IFormView view) {
        String pageId = UUID.randomUUID().toString();
        if (null != view) {
            IPageCache parentPageCache = (IPageCache)view.getService(IPageCache.class);
            parentPageCache.put(PluginUtil.getPageIdKey(taskId, type, view), pageId);
        }
        return pageId;
    }

    public static String getAppIdForEntity(String entitynumber) {
        return FormMetadataCache.getFormConfig((String)entitynumber).getAppId();
    }

    public static boolean hasCurrentPageTab(long taskId, String type, IFormView view) {
        if (view.getParentView() == null) {
            return false;
        }
        IFormView formView = PluginUtil.getCurrentPageTab(taskId, type, view.getParentView());
        if (formView != null) {
            formView.activate();
            PluginUtil.clearSelectData(view);
            view.sendFormAction(formView);
            return true;
        }
        return false;
    }

    public static IFormView getCurrentPageTab(long taskId, String type, IFormView view) {
        IFormView formView = null;
        if (null != view) {
            String pageIdkey = PluginUtil.getPageIdKey(taskId, type, view);
            IPageCache parentPageCache = (IPageCache)view.getService(IPageCache.class);
            String pageId = parentPageCache.get(pageIdkey);
            if (PluginUtil.isNotEmpty(pageId)) {
                formView = view.getViewNoPlugin(pageId);
            }
        }
        return formView;
    }

    public static void clearSelectData(IFormView formView) {
        if (formView instanceof IListView) {
            IListView view = (IListView)formView;
            view.clearSelection();
        }
    }

    public static boolean judgePreinsData(String entityName, Object id) {
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)entityName, (String)"ispreinsdata,ismodified", (QFilter[])new QFilter[]{new QFilter(ID, "=", id)});
        return dyObj.getBoolean(ISPREINSDATA) && dyObj.getBoolean(ISMODIFIED);
    }

    public static boolean judgePassoperparam(String eventNumber) {
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)"evt_event", (String)PASSOPERPARAM, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)eventNumber)});
        return dyObj != null && dyObj.getBoolean(PASSOPERPARAM);
    }

    public static void judgePreinsData(ListSelectedRowCollection key, AbstractListPlugin plugin, String entityNumber) {
        List<Object> list = PluginUtil.collectionToList(key);
        if (list.isEmpty()) {
            plugin.getView().setEnable(Boolean.TRUE, new String[]{BARDELETE});
        } else {
            PluginUtil.controlButton(list, plugin, entityNumber);
        }
    }

    public static List<Object> collectionToList(ListSelectedRowCollection key) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ListSelectedRow next : key) {
            Long id = (Long)next.getPrimaryKeyValue();
            list.add(id);
        }
        return list;
    }

    public static void controlButton(List<Object> ids, AbstractListPlugin plugin, String entityNumber) {
        DynamicObjectCollection dyObj = QueryServiceHelper.query((String)entityNumber, (String)"ispreinsdata,ismodified", (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
        for (int i = 0; i < dyObj.size(); ++i) {
            if (((DynamicObject)dyObj.get(i)).getBoolean(ISPREINSDATA) || !((DynamicObject)dyObj.get(i)).getBoolean(ISMODIFIED)) {
                plugin.getView().setEnable(Boolean.FALSE, new String[]{BARDELETE});
                return;
            }
            plugin.getView().setEnable(Boolean.TRUE, new String[]{BARDELETE});
        }
    }

    public static boolean check(List<QFilter> qfilters, String date) {
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        for (QFilter filter : qfilters) {
            if (!date.equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date startDate = simpleDateFormat.parse(startTime);
                Calendar cal = Calendar.getInstance();
                cal.setTime(startDate);
                cal.add(2, 3);
                cal.add(7, 4);
                startDate = cal.getTime();
                Date endDate = simpleDateFormat.parse(endTime);
                int compare = endDate.compareTo(startDate);
                if (compare > 0) {
                    return false;
                }
                checkResult = true;
            }
            catch (ParseException px) {
                return checkResult;
            }
        }
        return checkResult;
    }

    public static void removeCobPassDate(FilterContainerInitEvent event) {
        try {
            List<String> ids = Arrays.asList("13", "11", "10", "61", "63", "92", "24");
            Field field = event.getClass().getDeclaredField("schemeFilterView");
            ReflectionUtils.makeAccessible((Field)field);
            SchemeFilterView schemeFilterView = (SchemeFilterView)field.get(event);
            List filterColumns = schemeFilterView.getFilterColumns();
            for (FilterColumn column : filterColumns) {
                if (!CREATEDATE.equals(column.getFieldName())) continue;
                SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)column;
                Field compField = schemeFilterColumn.getClass().getDeclaredField("compareTypes");
                ReflectionUtils.makeAccessible((Field)compField);
                List compareTypes = (List)compField.get(schemeFilterColumn);
                compareTypes.removeIf(temp -> !ids.contains(temp.getId()));
            }
        }
        catch (Exception e) {
            logger.warn("EventLogListPlugin_removeCobPassDate:\u79fb\u9664\u65e5\u671f\u5f02\u5e38");
        }
    }

    public static final String getMobEntityNumber(String entityNumber) {
        DesignFormMeta designMeta = (DesignFormMeta)BusinessDataReader.read((Object)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
        String content = designMeta.getDataXml();
        SAXReader reader = new SAXReader();
        StringReader strReader = new StringReader(content);
        try {
            Document doc = reader.read((Reader)strReader);
            Node selectSingleNode = doc.selectSingleNode("/FormMetadata/Items/BillFormAp/MobMeta/FormMetadata/Key");
            if (selectSingleNode != null) {
                return selectSingleNode.getStringValue();
            }
        }
        catch (Exception e) {
            logger.warn("get mobil's entityNumber is error, errorinfo is :" + e.getMessage());
        }
        return entityNumber + "_mob";
    }

    public static String buildUrlInfo(Map<String, Object> url, String pk) {
        String formId = "";
        String mobFormId = "";
        Long pkId = null;
        if (!StringUtils.isBlank((CharSequence)pk)) {
            pkId = Long.valueOf(pk);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : url.entrySet()) {
            if ("formId".equals(entry.getKey())) {
                formId = (String)entry.getValue();
                continue;
            }
            if ("mob_formId".equals(entry.getKey())) {
                mobFormId = (String)entry.getValue();
                continue;
            }
            param.put(entry.getKey(), entry.getValue());
        }
        param.put("src", "wf");
        logger.debug(String.format("MessageCenterServiceHelper\u4f20\u9012\u7684formId\u53c2\u6570\u4e3a\uff1a%1$s,pk\u53c2\u6570\u4e3a:%2$s,param\u53c2\u6570\u4e3a:%3$s", url.toString(), pkId, ((Object)param).toString()));
        Map builMessageUrl = MessageCenterServiceHelper.builMessageUrl((String)formId, (String)mobFormId, (Long)pkId, param);
        if (builMessageUrl.get("data") == null) {
            return null;
        }
        return (String)builMessageUrl.get("data");
    }

    public static String openExtItfInContainer(IFormView view, IFormPlugin plugin, String targetKey, String config, String type, Boolean passoperparam) {
        FormShowParameter parameter = PluginUtil.getFormShowParameter(plugin, EVT_PLUGINCONFIG, "externalInterface");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.setCustomParam(CLASS, (Object)config);
        parameter.setCustomParam(TYPE, (Object)type);
        parameter.setCustomParam(PASSOPERPARAM, (Object)passoperparam);
        view.showForm(parameter);
        return parameter.getPageId();
    }

    private static FormShowParameter getFormShowParameter(IFormPlugin plugin, String formId, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        return parameter;
    }

    public static String invokeConfirmMethod(IFormView view, String subPageId) {
        Object ret = PluginUtil.invokePluginMethod(view, subPageId, "confirm");
        if (ret instanceof JSONObject) {
            return ret.toString();
        }
        return null;
    }

    public static Object invokePluginMethod(IFormView view, String subPageId, String methodName) {
        IFormView subView = view.getView(subPageId);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)subView.getService(FormViewPluginProxy.class);
        EvtPluginConfigPlugin extItfPlugin = null;
        List plugins = pluginProxy.getPlugIns();
        Object result = null;
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof EvtPluginConfigPlugin)) continue;
            extItfPlugin = (EvtPluginConfigPlugin)plugin;
            try {
                result = MethodUtils.invokeMethod((Object)((Object)extItfPlugin), (String)methodName, null);
            }
            catch (Exception e) {
                logger.warn(String.format("invoke BecExternalInterfacePlugin's %s method error! %s", methodName, e.getMessage()));
            }
            break;
        }
        view.sendFormAction(subView);
        return result;
    }

    public static boolean isJSONObject(Object object) {
        if (StringUtils.isNotBlank((Object)object)) {
            try {
                JSONObject.parseObject((String)object.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String handleData(JSONObject obj) {
        String lang = Lang.get().toString();
        LocaleString value = new LocaleString();
        if (null != obj && obj.size() > 0) {
            for (Map.Entry entry : obj.entrySet()) {
                if (!((String)entry.getKey()).equals(lang)) continue;
                value.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
                break;
            }
        }
        return String.valueOf(value);
    }

    public static String spliceData(JSONObject obj) {
        String content = "";
        String title = "";
        Object contentObj = null;
        Object titleObj = null;
        boolean isEmail = false;
        if (obj.containsKey((Object)EMAILTITLE) || obj.containsKey((Object)EMAILCONTENT)) {
            isEmail = true;
            contentObj = obj.get((Object)EMAILCONTENT);
            titleObj = obj.get((Object)EMAILTITLE);
        } else {
            isEmail = false;
            contentObj = obj.get((Object)CONTENT);
            titleObj = obj.get((Object)TITLE);
        }
        content = contentObj instanceof JSONObject ? PluginUtil.handleData((JSONObject)contentObj) : String.valueOf(contentObj);
        title = titleObj instanceof JSONObject ? PluginUtil.handleData((JSONObject)titleObj) : String.valueOf(titleObj);
        JSONObject object = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            object.put(isEmail ? EMAILTITLE : TITLE, (Object)title);
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            object.put(isEmail ? EMAILCONTENT : CONTENT, (Object)content);
        }
        return String.valueOf(object);
    }

    public static void eventNumberViewRepair() {
        String countSql = "select  count(fnumberview) as count from t_evt_event where fnumberview  = ' ' or fnumberview = ''";
        String updateSql = "UPDATE t_evt_event SET FNUMBERVIEW = FNUMBER WHERE FNUMBERVIEW = ' ' or FNUMBERVIEW = ''";
        PluginUtil.executeSql(countSql, updateSql);
    }

    private static void executeSql(String countSql, String updateSql) {
        Long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)"eventNumberViewRepair", (DBRoute)DBRoute.workflow, (String)countSql);){
            for (Row row : ds) {
                count = row.getLong("count");
            }
        }
        if (count > 0L) {
            boolean ds = DB.execute((DBRoute)DBRoute.workflow, (String)updateSql);
            if (ds) {
                logger.debug("\u5bf9\u4e8b\u4ef6\u7f16\u7801\u4e3a\u7a7a\u7684\u6570\u636e\u8fdb\u884c\u4e86\u4fee\u590d");
            } else {
                logger.debug("\u4e8b\u4ef6\u7f16\u7801\u4e3a\u7a7a\u7684\u6570\u636e\u4fee\u590d\u5931\u8d25");
            }
        } else {
            logger.debug("\u4e0d\u5b58\u5728\u4e8b\u4ef6\u7f16\u7801\u4e3a\u7a7a\u7684\u6570\u636e");
        }
    }

    public static boolean isEmailChannel(String channelName) {
        return MessageChannelUtils.isEmailChannel((String)channelName);
    }

    public static boolean deleteCache(List<Object> serviceId) {
        try {
            if (serviceId == null || serviceId.size() < 1) {
                return true;
            }
            String sql = "select feventnumber eventNumber from t_evt_subscription where fservice in ( ? ) group by feventnumber;";
            String querySql = sql.replaceAll("\\?", PluginUtil.getQuestionMarkList(serviceId.size()));
            List eventnumbers = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql, (Object[])serviceId.toArray(), (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> keys = new ArrayList<String>(32);
                    while (rs.next()) {
                        keys.add(rs.getString("eventNumber"));
                    }
                    return keys;
                }
            });
            logger.debug(String.format("getSubscriptionForServiceEntity\uff1a%s", WfUtils.listToString((Collection)eventnumbers, (String)",")));
            EvtCacheHelper.removeCacheSubscriptionMap((List)eventnumbers);
            return true;
        }
        catch (Throwable exp) {
            logger.warn(WfUtils.getExceptionStacktrace((Throwable)exp));
            return false;
        }
    }

    public static String getQuestionMarkList(int size) {
        StringBuilder questionMark = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            questionMark.append(" ?");
            if (i == size - 1) continue;
            questionMark.append(',');
        }
        return questionMark.toString();
    }

    public static String desensitizeIP(String ip) {
        String ret = "";
        try {
            if (WfUtils.isNotEmpty((String)ip)) {
                int first = ip.indexOf(".");
                int last = ip.lastIndexOf(".");
                ret = ip.substring(0, first) + ".*.*." + ip.substring(last + 1, ip.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

