/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.config.formplugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MessageChannelListPlugin
extends AbstractListPlugin
implements IConfirmCallBack {
    private static final String MSG_CHANNEL = "msg_channel";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("number", "!=", (Object)"sysnotice"));
        e.setCustomQFilters(filters);
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow lsr = evt.getCurrentListSelectedRow();
        if (lsr != null) {
            String number = lsr.getNumber();
            if (MessageChannels.getChannelValueOf((String)number) != null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"baritedelete"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"baritedelete"});
            }
        }
    }

    private void refresh() {
        IListView listView = (IListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData;
        ListSelectedRow listSelectedRow;
        QFilter[] filters;
        DynamicObject[] channelObjects;
        FormOperate entityOperation = (FormOperate)args.getSource();
        String operateKey = entityOperation.getOperateKey();
        if ("delete".equals(operateKey)) {
            ListSelectedRowCollection collection = args.getListSelectedData();
            for (ListSelectedRow listSelectedRow2 : collection) {
                MessageChannels messageChannels = MessageChannels.getChannelValueOf((String)listSelectedRow2.getNumber());
                if (messageChannels == null) continue;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6e20\u9053\u4e0d\u80fd\u5220\u9664\u3002", (String)"MessageChannelListPlugin_5", (String)"bos-message-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("enable".equals(operateKey) && (channelObjects = BusinessDataServiceHelper.load((String)MSG_CHANNEL, (String)"id, number, mobileappconfig", (QFilter[])(filters = new QFilter[]{new QFilter("id", "=", (Object)((Long)(listSelectedRow = (listSelectedData = entityOperation.getListSelectedData()).get(0)).getPrimaryKeyValue()))}))) != null && channelObjects.length > 0) {
            DynamicObject msgChannel = channelObjects[0];
            String number = msgChannel.getString("number");
            String mobileAppConfig = msgChannel.getString("mobileappconfig");
            if ("kingdee_sky".equals(number) && MessageUtils.isEmpty((String)mobileAppConfig)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u7528\u3002\u516c\u6709\u4e91\u4f01\u4e1a\u5fae\u4fe1\u672a\u5b8c\u6210\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u5fae\u4fe1\u7ba1\u7406\u5458\u3002", (String)"MessageChannelPlugin_6", (String)"bos-message-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("delete".equalsIgnoreCase(operateKey) && args.getOperationResult().isSuccess()) {
            this.deleteChannel(args);
        } else if ("enable".equals(operateKey) || "disable".equals(operateKey)) {
            this.enableChannel(operateKey, args);
        }
    }

    private void enableChannel(String operateKey, AfterDoOperationEventArgs args) {
        ListSelectedRow listSelectedRow;
        boolean isSuccess;
        FormOperate entityOperation = (FormOperate)args.getSource();
        ListSelectedRowCollection listSelectedData = entityOperation.getListSelectedData();
        if (listSelectedData == null || listSelectedData.isEmpty()) {
            return;
        }
        boolean isEnableOperation = "enable".equals(operateKey);
        String notification1 = ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"MessageChannelListPlugin_2", (String)"bos-message-formplugin", (Object[])new Object[0]);
        String notification2 = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6e20\u9053\u5df2\u7981\u7528\u3002", (String)"MessageChannelListPlugin_4", (String)"bos-message-formplugin", (Object[])new Object[0]);
        if (isEnableOperation) {
            notification1 = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"MessageChannelListPlugin_1", (String)"bos-message-formplugin", (Object[])new Object[0]);
            notification2 = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6e20\u9053\u5df2\u542f\u7528\u3002", (String)"MessageChannelListPlugin_3", (String)"bos-message-formplugin", (Object[])new Object[0]);
        }
        if (isSuccess = MessageUtils.setEnable((Object)(listSelectedRow = listSelectedData.get(0)).getPrimaryKeyValue(), (boolean)isEnableOperation)) {
            if (isEnableOperation) {
                MessageUtils.wrapYunzhijiaChannel((Object)listSelectedRow.getPrimaryKeyValue(), null);
            }
            this.refresh();
            this.getView().showSuccessNotification(notification1);
        } else {
            this.getView().showTipNotification(notification2);
        }
    }

    private void deleteChannel(AfterDoOperationEventArgs args) {
        FormOperate entityOperation = (FormOperate)args.getSource();
        ListSelectedRowCollection listSelectedData = entityOperation.getListSelectedData();
        if (listSelectedData == null || listSelectedData.isEmpty()) {
            return;
        }
        for (ListSelectedRow listSelectedRow : listSelectedData) {
            Object channelId = listSelectedRow.getPrimaryKeyValue();
            String channelNumber = listSelectedRow.getNumber();
            String channelName = listSelectedRow.getName();
            MessageChannelUtils.updateMsgChannelTagKeyInCache();
            MsgServiceCache.refreshMsgChannelCacheInfo((String)channelNumber, (boolean)true);
            MessageUtils.addOperateLog((String)MSG_CHANNEL, (String)"delete", (String)ResManager.getLocaleString((String)"\u5220\u9664\u6d88\u606f\u6e20\u9053", (String)"MessageChannelListPlugin_0", (String)"bos-message-formplugin").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("%s\u5220\u9664\u6210\u529f", "MessageChannelListPlugin_9", "bos-message-formplugin"), (Object[])new Object[]{channelName});
        }
    }
}

