/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.config.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.util.PluginUtil;
import kd.bos.servicehelper.inte.InteServiceHelper;
import org.apache.commons.lang.BooleanUtils;

public class MessageEmailContentPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static Log log = LogFactory.getLog(MessageEmailContentPlugin.class);
    private static final String INSERTEXPRESSION = "insertexpression";
    private static final String INSERT_ENTRY_EXPRESSION = "insertentryexpression";
    private static final String INSERTFIELD = "insertfield";
    private static final String EMAILTITLE = "emailTitle";
    private static final String EMAILCONTENT = "emailContent";
    private static final String LOCALE = "locale";
    private static final String MSGINFOCACHE = "msgInfo";
    private static final String CONTENT = "content";
    private static final String TITLE = "title";
    private static final String CONFIRM = "confirm";
    private static final String CANCEL = "cancel";
    private static final String FROM = "FROM";
    private static final String NUMBERMAPNAME = "numberMapName";
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String INSERTERRORMSG = "inserterrormsg";
    private static final String MSGTABKEY = "msgtabkey";
    private static final String MSGTITLE = "msgtitle";
    private static final String EVT_AUTOMSG = "evt_automsg";
    private static final String ERRMSG = "{errmsg}";
    private static final String COSMIC = "cosmic";
    private static final String CUSTOM = "custom";
    public static final String EXPRESSION = "expression";
    public static final String PREF = "{";
    public static final String SUFF = "}";
    public static final String LOOP_PREF = "loop:{(";
    public static final String LOOP_SUFF = ")}";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, CANCEL, INSERTEXPRESSION, INSERTERRORMSG, INSERT_ENTRY_EXPRESSION});
        Tab apptabs = (Tab)this.getView().getControl("msgtab");
        apptabs.addTabSelectListener((TabSelectListener)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "insertexpression": {
                this.showExpressionForm();
                break;
            }
            case "insertentryexpression": {
                this.showExpressionForm(Boolean.TRUE);
                break;
            }
            case "confirm": {
                this.returnData();
                break;
            }
            case "cancel": {
                this.getPageCache().remove(FROM);
                this.getView().close();
                break;
            }
            case "inserterrormsg": {
                this.insertErrorMsg();
                break;
            }
        }
    }

    private void insertErrorMsg() {
        String msgTabKey = this.getPageCache().get(MSGTABKEY);
        Object content = null;
        if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
            content = this.getModel().getValue(TITLE);
            content = content + ERRMSG;
            this.getModel().setValue(TITLE, content);
        } else {
            RichTextEditor editorContent = (RichTextEditor)this.getControl(CONTENT);
            content = editorContent.getText();
            content = content == null ? ERRMSG : content + ERRMSG;
            editorContent.setText((String)content);
        }
    }

    private void returnData() {
        String title;
        HashMap<String, JSONObject> returnData = new HashMap<String, JSONObject>();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String operationSource = (String)showParameter.getCustomParam("operationSource");
        RichTextEditor editor = (RichTextEditor)this.getControl(CONTENT);
        String content = editor.getText();
        String locale = (String)this.getModel().getValue(LOCALE);
        if (locale.equalsIgnoreCase(RequestContext.get().getLang().toString())) {
            if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)content.replace("<p><br></p>", "").trim())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7cfb\u7edf\u5f53\u524d\u8bed\u79cd\u6b63\u6587\u5185\u5bb9\u3002", (String)"MessageEmailContentPlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            String tplMap = this.getPageCache().get(MSGINFOCACHE);
            if (tplMap == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7cfb\u7edf\u5f53\u524d\u8bed\u79cd\u6b63\u6587\u5185\u5bb9\u3002", (String)"MessageEmailContentPlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]));
                log.debug("\u8bf7\u5f55\u5165\u7cfb\u7edf\u5f53\u524d\u8bed\u79cd\u6b63\u6587\u5185\u5bb9No2");
                return;
            }
            Map tpls = (Map)SerializationUtils.fromJsonString((String)tplMap, Map.class);
            Map contentMap = (Map)tpls.get(EMAILCONTENT);
            if (StringUtils.isBlank(contentMap.get(RequestContext.get().getLang().toString()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7cfb\u7edf\u5f53\u524d\u8bed\u79cd\u6b63\u6587\u5185\u5bb9\u3002", (String)"MessageEmailContentPlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]));
                log.debug(String.format("\u8bf7\u5f55\u5165\u7cfb\u7edf\u5f53\u524d\u8bed\u79cd\u6b63\u6587\u5185\u5bb9No3: %s", RequestContext.get().getLang().toString()));
                return;
            }
        }
        if ((StringUtils.isNotBlank((CharSequence)(title = (String)this.getModel().getValue(TITLE))) || StringUtils.isNotBlank((CharSequence)content)) && StringUtils.isBlank((CharSequence)locale)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bed\u79cd", (String)"MessageEmailContentPlugin_2", (String)"bos-message-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject obj = this.msgHandle(locale, "", title, content);
        log.debug("returnData obj=" + obj);
        JSONObject packageData = obj.getJSONObject("packageData");
        if (null != packageData) {
            JSONObject emailTitle = packageData.getJSONObject(EMAILTITLE);
            JSONObject emailContent = packageData.getJSONObject(EMAILCONTENT);
            if (StringUtils.isNotBlank((Object)emailTitle)) {
                returnData.put(EMAILTITLE, emailTitle);
            }
            if (StringUtils.isNotBlank((Object)emailContent)) {
                returnData.put(EMAILCONTENT, emailContent);
            }
        }
        this.getPageCache().remove(FROM);
        this.getPageCache().remove(NUMBERMAPNAME);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void showExpressionForm() {
        this.showExpressionForm(Boolean.FALSE);
    }

    private void showExpressionForm(boolean isEntryParse) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String modelJson = (String)showParameter.getCustomParam("modelJson");
        String entityNumber = (String)showParameter.getCustomParam(ENTITYNUMBER);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("bpmnModel", modelJson);
        content.put(ENTITYNUMBER, entityNumber);
        String type = (String)showParameter.getCustomParam("type");
        if (COSMIC.equals(type) || CUSTOM.equals(type)) {
            content.put("ruleType", "EventConfig");
            content.put("eventnumber", showParameter.getCustomParam("eventnumber"));
        } else if ("expiresendmsg".equals(type)) {
            content.put("ruleType", "expiresendmsg");
        } else {
            content.put("ruleType", "sequenceFlow");
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, INSERTEXPRESSION));
        parameter.setFormId("wf_valueexpression");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(content);
        parameter.setHasRight(true);
        parameter.getCustomParams().put("isIgnoreLicense", true);
        parameter.getCustomParams().put("isLoopEntryParse", isEntryParse);
        this.getView().showForm(parameter);
    }

    public void afterBindData(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        this.initLocale();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (EVT_AUTOMSG.equals(parameter.getParentFormId())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
        }
        Boolean flag = (Boolean)parameter.getCustomParam("notify");
        if (flag == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{INSERTERRORMSG});
        } else {
            this.getView().setVisible(flag, new String[]{INSERTERRORMSG});
        }
        String entityNumber = (String)parameter.getCustomParam(ENTITYNUMBER);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)parameter.getCustomParam(FROM)))) {
            this.getPageCache().put(FROM, (String)parameter.getCustomParam(FROM));
        }
        JSONObject msgInfoObj = JSONObject.parseObject((String)((String)parameter.getCustomParam("value")));
        String lang = Lang.get().toString();
        this.getModel().setValue(LOCALE, (Object)lang);
        RichTextEditor editorContent = (RichTextEditor)this.getControl(CONTENT);
        if (null != msgInfoObj && msgInfoObj.size() > 0) {
            Object title = msgInfoObj.get((Object)EMAILTITLE);
            Object content = msgInfoObj.get((Object)EMAILCONTENT);
            if (title instanceof JSONObject || content instanceof JSONObject) {
                JSONObject contentObj;
                this.getPageCache().put(MSGINFOCACHE, msgInfoObj.toString());
                JSONObject titleObj = JSONObject.parseObject((String)(msgInfoObj.get((Object)EMAILTITLE) != null ? msgInfoObj.get((Object)EMAILTITLE).toString() : ""));
                if (null != titleObj && titleObj.size() > 0) {
                    this.getModel().setValue(TITLE, (Object)titleObj.getString(lang));
                }
                if (null != (contentObj = JSONObject.parseObject((String)(msgInfoObj.get((Object)EMAILCONTENT) != null ? msgInfoObj.get((Object)EMAILCONTENT).toString() : ""))) && contentObj.size() > 0) {
                    editorContent.setText(contentObj.getString(lang));
                }
            } else {
                log.debug("afterCreateNewData historyData");
                JSONObject obj = this.msgHandle(lang, null, msgInfoObj.getString(EMAILTITLE), msgInfoObj.getString(EMAILCONTENT));
                this.getPageCache().put(MSGINFOCACHE, obj.toString());
                this.getModel().setValue(TITLE, (Object)msgInfoObj.getString(EMAILTITLE));
                editorContent.setText(msgInfoObj.getString(EMAILCONTENT));
            }
        }
        log.info("afterCreateNewData msgInfoCache=" + this.getPageCache().get(MSGINFOCACHE));
        if (EVT_AUTOMSG.equals(parameter.getParentFormId()) && StringUtils.isBlank((CharSequence)entityNumber)) {
            String type = (String)parameter.getCustomParam("type");
            if (CUSTOM.equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{INSERTFIELD});
            }
            return;
        }
        if (!EVT_AUTOMSG.equals(parameter.getParentFormId()) && StringUtils.isBlank((CharSequence)entityNumber)) {
            log.warn(String.format("\u90ae\u4ef6\u5185\u5bb9\u53c2\u6570\u51fa\u9519--\u53c2\u6570\u4e3a\u7a7a\uff01 %s %s", "WorkflowEmailContentPlugin", ENTITYNUMBER));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9875\u9762\u53c2\u6570\u201d\u7f3a\u5c11\u5355\u636e\u4fe1\u606f\u3002", (String)"MessageTplTitleContentPlugin_2", (String)"bos-message-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setFieldComboItems(entityNumber);
        Tab msgtab = (Tab)this.getView().getControl("msgtab");
        msgtab.activeTab("msgcontent");
        this.getPageCache().put(MSGTABKEY, "msgcontent");
    }

    private void initLocale() {
        List langList = InteServiceHelper.getMultiLangEnabledLang();
        LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>(langList.size());
        for (EnabledLang enabledLang : langList) {
            items.put(enabledLang.getName(), enabledLang.getNumber());
        }
        PluginUtil.setComboForControl(items, (ComboEdit)this.getControl(LOCALE));
    }

    private void setFieldComboItems(String entityNumber) {
        MainEntityType entityType;
        HashMap<String, String> numberMapName = new HashMap<String, String>();
        MainEntityType mainType = entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator iter = mainType.getAllFields().values().iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        while (iter.hasNext()) {
            ComboItem item = new ComboItem();
            IDataEntityProperty fieldProp = (IDataEntityProperty)iter.next();
            if (!(fieldProp instanceof IFieldHandle) || StringUtils.isNotBlank((CharSequence)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName())) continue;
            if (!(fieldProp instanceof BasedataProp)) {
                item.setValue(fieldProp.getName());
                item.setCaption(((IFieldHandle)fieldProp).getDisplayName());
                numberMapName.put(item.getValue(), item.getCaption().toString());
            }
            items.add(item);
        }
        ComboEdit fieldCombo = (ComboEdit)this.getControl(INSERTFIELD);
        this.getPageCache().put(NUMBERMAPNAME, SerializationUtils.toJsonString(numberMapName));
        fieldCombo.setComboItems(items);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        RichTextEditor editorContent;
        Object fieldObj;
        String propertyName = e.getProperty().getName().toLowerCase();
        if (INSERTFIELD.endsWith(propertyName) && StringUtils.isNotBlank((Object)(fieldObj = this.getModel().getValue(INSERTFIELD)))) {
            String msgTabKey = this.getPageCache().get(MSGTABKEY);
            Object content = null;
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                content = this.getModel().getValue(TITLE);
            } else {
                editorContent = (RichTextEditor)this.getControl(CONTENT);
                content = editorContent.getText();
            }
            content = StringUtils.isNotBlank((Object)content) ? content : "";
            String field = fieldObj.toString();
            String fieldValue = PREF + field + SUFF;
            if (StringUtils.isBlank((CharSequence)this.getPageCache().get(FROM))) {
                String numberMapNameStr = this.getPageCache().get(NUMBERMAPNAME);
                if (StringUtils.isNotBlank((CharSequence)numberMapNameStr)) {
                    Map numberMapName = (Map)SerializationUtils.fromJsonString((String)numberMapNameStr, Map.class);
                    String name = (String)numberMapName.get(field);
                    fieldValue = name + "\uff1a" + fieldValue;
                }
                if (StringUtils.isNotBlank((Object)content)) {
                    fieldValue = "/" + fieldValue;
                }
            }
            content = content + fieldValue;
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                this.getModel().setValue(TITLE, (Object)((String)content));
            } else {
                RichTextEditor editorContent2 = (RichTextEditor)this.getControl(CONTENT);
                editorContent2.setText((String)content);
            }
        }
        if (LOCALE.equalsIgnoreCase(propertyName)) {
            String newLocale = (String)e.getChangeSet()[0].getNewValue();
            String oldLocale = (String)e.getChangeSet()[0].getOldValue();
            if (StringUtils.isNotBlank((CharSequence)oldLocale) && StringUtils.isNotBlank((CharSequence)newLocale) && !newLocale.equals(oldLocale)) {
                log.debug("\u5207\u6362\u8bed\u79cd oldLocale=" + oldLocale + " newLocale=" + newLocale);
                this.getModel().setValue(INSERTFIELD, null);
                String oldTitle = (String)this.getModel().getValue(TITLE);
                editorContent = (RichTextEditor)this.getControl(CONTENT);
                String oldContent = editorContent.getText();
                JSONObject obj = this.msgHandle(oldLocale, newLocale, oldTitle, oldContent);
                log.debug("msgHandle \u8fd4\u56de\u6570\u636eobj=" + obj);
                this.getPageCache().put(MSGINFOCACHE, String.valueOf(obj.get((Object)"packageData")));
                String title = obj.getString("newTitle");
                String content = obj.getString("newContent");
                editorContent.setText(content);
                this.getModel().setValue(TITLE, (Object)title);
            }
        }
    }

    private JSONObject msgHandle(String oldLocale, String newLocale, String oldTitle, String oldContent) {
        JSONObject obj = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)oldLocale)) {
            String msgInfoCache = this.getPageCache().get(MSGINFOCACHE);
            JSONObject dataObj = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)msgInfoCache)) {
                dataObj = JSONObject.parseObject((String)msgInfoCache);
            }
            LocaleString title = new LocaleString();
            LocaleString content = new LocaleString();
            String emailTitle = dataObj.getString(EMAILTITLE);
            if (PluginUtil.isNotEmpty(emailTitle)) {
                JSONObject titleObj = JSONObject.parseObject((String)emailTitle);
                for (Map.Entry entry : titleObj.entrySet()) {
                    title.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
                }
            }
            title.setItem(oldLocale, (Object)oldTitle);
            String emailContent = dataObj.getString(EMAILCONTENT);
            if (PluginUtil.isNotEmpty(emailContent)) {
                JSONObject contentObj = JSONObject.parseObject((String)emailContent);
                for (Map.Entry entry : contentObj.entrySet()) {
                    content.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
                }
            }
            content.setItem(oldLocale, (Object)oldContent);
            JSONObject packageData = new JSONObject();
            packageData.put(EMAILTITLE, (Object)title);
            packageData.put(EMAILCONTENT, (Object)content);
            obj.put("packageData", (Object)packageData);
            if (StringUtils.isNotBlank((CharSequence)newLocale)) {
                obj.put("newTitle", title.getItem(newLocale));
                obj.put("newContent", content.getItem(newLocale));
            }
        }
        return obj;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnObj;
        Map m;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (INSERTEXPRESSION.equals(key) && (m = (Map)(returnObj = closedCallBackEvent.getReturnData())) != null && StringUtils.isNotBlank(m.get(EXPRESSION)) && StringUtils.isNotBlank(m.get("prop"))) {
            Map propMap = (Map)SerializationUtils.fromJsonString((String)m.get("prop").toString(), Map.class);
            String msgTabKey = this.getPageCache().get(MSGTABKEY);
            Object content = null;
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                content = this.getModel().getValue(TITLE);
            } else {
                RichTextEditor editorContent = (RichTextEditor)this.getControl(CONTENT);
                content = editorContent.getText();
            }
            content = StringUtils.isNotBlank((Object)content) ? content : "";
            Object isEntryParse = m.get("isLoopEntryParse");
            String expression = PluginUtil.isEmptyString(isEntryParse) || !BooleanUtils.toBoolean((String)isEntryParse.toString()) ? PREF + m.get(EXPRESSION).toString() + SUFF : LOOP_PREF + m.get(EXPRESSION).toString() + LOOP_SUFF;
            if (StringUtils.isBlank((CharSequence)this.getPageCache().get(FROM)) && StringUtils.isNotBlank((CharSequence)((CharSequence)propMap.get("name")))) {
                String propName = StringUtils.isBlank((CharSequence)((CharSequence)propMap.get("fullName"))) ? (String)propMap.get("name") : (String)propMap.get("fullName");
                expression = propName + "\uff1a" + expression;
                if (StringUtils.isNotBlank((Object)content)) {
                    expression = "/" + expression;
                }
            }
            content = content + expression;
            if (msgTabKey == null || MSGTITLE.equalsIgnoreCase(msgTabKey)) {
                this.getModel().setValue(TITLE, (Object)((String)content));
            } else {
                RichTextEditor editorContent = (RichTextEditor)this.getControl(CONTENT);
                editorContent.setText((String)content);
            }
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        String msgTabKey = arg0.getTabKey();
        this.getPageCache().put(MSGTABKEY, msgTabKey);
        this.getModel().setValue(INSERTFIELD, null);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(MSGTABKEY);
        this.getPageCache().remove(MSGINFOCACHE);
    }
}

