/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.config.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.message.service.utils.FailMessageUtil;
import kd.bos.message.utils.MessageAttachmentUtils;
import kd.bos.message.utils.StandardTipsMsg;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MessageFailListPlugin
extends AbstractListPlugin {
    private static final String BTNRESEND = "resendbar";
    private static final String BTNDETAIL = "detailbar";
    private static final String FAILMESSAGE = "wf_msg_failmessage";

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters, "createdate", "modifydate")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u6700\u591a\u4e3a\u4e09\u4e2a\u6708\u3002", (String)"MessageFailListPlugin_8", (String)"bos-message-formplugin", (Object[])new Object[0]));
        }
        this.setMessageIdFilter(e);
        super.setFilter(e);
    }

    private void setMessageIdFilter(SetFilterEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && !customParams.isEmpty() && customParams.containsKey("messageIds")) {
            String[] msgIdArr;
            ArrayList ids = new ArrayList();
            Object messageIds = customParams.get("messageIds");
            if (StringUtils.isNotBlank(messageIds) && (msgIdArr = ((String)messageIds).split(",")).length > 0) {
                for (int i = 0; i < msgIdArr.length; ++i) {
                    Optional.ofNullable(msgIdArr[i]).ifPresent(id -> ids.add(Long.valueOf(id)));
                }
            }
            e.getCustomQFilters().add(new QFilter("messageid", "in", ids));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
        switch (evt.getItemKey()) {
            case "detailbar": {
                this.checkFailMessageDetail(rows);
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> msgIds = new ArrayList<Long>();
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                msgIds.add((Long)row.getPrimaryKeyValue());
            }
            this.resendButtonEnable(msgIds);
        }
    }

    private void resendButtonEnable(List<Long> msgIds) {
        boolean resendEnable = Boolean.TRUE;
        DynamicObject[] msgObjList = BusinessDataServiceHelper.load((String)FAILMESSAGE, (String)"state", (QFilter[])new QFilter[]{new QFilter("id", "in", msgIds)});
        if (msgObjList != null && msgObjList.length != 0) {
            for (DynamicObject msgObj : msgObjList) {
                if (!msgObj.getString("state").equalsIgnoreCase("success")) continue;
                resendEnable = Boolean.FALSE;
                break;
            }
        }
        this.getView().setEnable(Boolean.valueOf(resendEnable), new String[]{BTNRESEND});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (Delete.class.isInstance(args.getSource())) {
            this.beforeDeleteOperation(args);
        } else if (Donothing.class.isInstance(args.getSource())) {
            this.beforeResendOperation(args);
        }
    }

    private void beforeResendOperation(BeforeDoOperationEventArgs args) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"18XR3MJ0W0ET", (String)FAILMESSAGE, (String)"1RGBK/0GW03Q")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d88\u606f\u65e5\u5fd7\u201d\u7684\u201c\u91cd\u53d1\u201d\u6743\u9650\u3002", (String)"MessageFailListPlugin_9", (String)"bos-message-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListSelectedRowCollection selectedRowCollection = args.getListSelectedData();
        if (selectedRowCollection.size() > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u91cd\u53d1\u6d88\u606f\u8d28\u91cf\uff0c\u8bf7\u9009\u62e9\u4e0d\u8d85\u8fc720\u6761\u6570\u636e\u3002", (String)"MessageFailListPlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            args.setCancel(true);
        }
    }

    private void beforeDeleteOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection collection = args.getListSelectedData();
        ArrayList<Long> msgChannelIds = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : collection) {
            Long tplId = (Long)listSelectedRow.getPrimaryKeyValue();
            msgChannelIds.add(tplId);
        }
        try {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", msgChannelIds)};
            DynamicObject[] msgFails = BusinessDataServiceHelper.load((String)FAILMESSAGE, (String)"id, config", (QFilter[])filters);
            ArrayList attachmentUrls = new ArrayList();
            for (DynamicObject msg : msgFails) {
                Map param;
                String config = msg.getString("config");
                if (!StringUtils.isNotBlank((CharSequence)config) || "{}".equals(config) || !(param = (Map)SerializationUtils.fromJsonString((String)config, Map.class)).containsKey("attachmentUrls")) continue;
                List urls = (List)param.get("attachmentUrls");
                attachmentUrls.addAll(urls);
            }
            if (!attachmentUrls.isEmpty()) {
                MessageAttachmentUtils.deleteAttachmentData(attachmentUrls);
            }
        }
        catch (Exception e) {
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (Donothing.class.isInstance(args.getSource())) {
            this.afterResendOperation(args);
        }
    }

    private void afterResendOperation(AfterDoOperationEventArgs args) {
        ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
        ArrayList<Long> failMsgIds = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            failMsgIds.add((Long)rows.get(i).getPrimaryKeyValue());
        }
        List successIds = FailMessageUtil.batchResendFailMessage(failMsgIds, null);
        if (!successIds.isEmpty()) {
            ((ListView)this.getView()).refresh();
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u91cd\u53d1%s\u6761\u5931\u8d25\u6d88\u606f\uff0c\u8bf7\u68c0\u67e5\u6d88\u606f\u662f\u5426\u53d1\u9001\u6210\u529f\u3002", (String)"MessageFailListPlugin_1", (String)"bos-message-formplugin", (Object[])new Object[0]), successIds.size()), Integer.valueOf(3000));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u91cd\u53d1\u6d88\u606f\u201d\u64cd\u4f5c\u5931\u8d25\u3002", (String)"MessageFailListPlugin_3", (String)"bos-message-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void checkFailMessageDetail(ListSelectedRowCollection rows) {
        if (rows.getBillListSelectedRowCollection().size() != 1) {
            StandardTipsMsg.view((IFormView)this.getView()).selectMultiRow(rows.getBillListSelectedRowCollection().size());
            return;
        }
        long failMsgId = (Long)rows.getBillListSelectedRowCollection().get(0).getPrimaryKeyValue();
        this.shouwMessageLogDetail(failMsgId);
    }

    private void shouwMessageLogDetail(Long msgLogId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("msg_detail");
        fsp.setCaption(ResManager.loadKDString((String)"\u6d88\u606f\u8be6\u60c5", (String)"MessageFailListPlugin_5", (String)"bos-message-formplugin", (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("failMsgId", (Object)msgLogId);
        this.getView().showForm(fsp);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long failMsgId = (Long)((ListView)this.getView()).getFocusRowPkId();
        this.shouwMessageLogDetail(failMsgId);
    }

    private boolean check(List<QFilter> qfilters, String ... property) {
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        if (StringUtils.isNotBlank((Object)property)) {
            for (QFilter filter : qfilters) {
                List<String> propertyList = Arrays.asList(property);
                if (propertyList.isEmpty() || !propertyList.contains(filter.getProperty())) continue;
                String filterStr = filter.toString();
                List qfilterNests = filter.getNests(true);
                if (qfilterNests == null || qfilterNests.isEmpty()) continue;
                String startTime = null;
                String endTime = null;
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                startTime = filterStr.substring(0, filterStr.indexOf(39));
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                endTime = filterStr.substring(0, filterStr.indexOf(39));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date endDate = simpleDateFormat.parse(endTime);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endDate);
                    cal.add(2, -3);
                    cal.add(7, -3);
                    endDate = cal.getTime();
                    Date startDate = simpleDateFormat.parse(startTime);
                    if (endDate.compareTo(startDate) > 0) {
                        return false;
                    }
                    checkResult = true;
                }
                catch (ParseException px) {
                    return checkResult;
                }
            }
        }
        return checkResult;
    }
}

