/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.config.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Delete;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.mutilLange.MessageMultilangageUtils;
import kd.bos.message.utils.MessageUtils;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MessageTemplateList
extends AbstractListPlugin
implements IConfirmCallBack {
    public static final Log logger = LogFactory.getLog(MessageTemplateList.class);
    private static final String DELETEOPERATION = "delete";
    private static final String NEEDDELATETEMPLATE = "templateKeysInCache";
    private static final String MSG_TEMPLATE = "msg_template";
    private static final String MSG_CHANNEL = "msg_channel";
    private static final String MSG_TYPE = "msg_type";
    private static final String MSGCHANNEL = "msgchannel";
    private static final String MSGTYPE = "msgtype";
    private static final String MESSAGETEMPLATELIST_0 = "MessageTemplateList_0";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String MSGTEMPLATE = "msgtemplate";
    private static final String COMMONLANG = "commonlang";
    private static final String TPLCONTENT = "tplContent";
    private static final String BIZPLUGIN = "bizPlugin";

    public void packageData(PackageDataEvent e) {
        String typeNumber;
        Map typePageCache;
        String channelNumber;
        Map channelPageCache;
        Set keySet;
        DynamicObject row = e.getRowData();
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.isNotBlank((CharSequence)pageCache.get(MSG_CHANNEL)) && (keySet = (channelPageCache = (Map)SerializationUtils.fromJsonString((String)pageCache.get(MSG_CHANNEL), Map.class)).keySet()).contains(channelNumber = row.getString(MSGCHANNEL))) {
            row.set(MSGCHANNEL, channelPageCache.get(channelNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)pageCache.get(MSG_TYPE)) && (keySet = (typePageCache = (Map)SerializationUtils.fromJsonString((String)pageCache.get(MSG_TYPE), Map.class)).keySet()).contains(typeNumber = row.getString(MSGTYPE))) {
            row.set(MSGTYPE, typePageCache.get(typeNumber));
        }
        if (StringUtils.isBlank((Object)row.get(MSGTEMPLATE))) {
            String msgTemplate = "";
            String templateCacheData = MsgServiceCacheHelper.getTemplateCache((String)row.getString(NUMBER));
            if (StringUtils.isBlank((CharSequence)templateCacheData) || !templateCacheData.contains(BIZPLUGIN) || !templateCacheData.contains(TPLCONTENT)) {
                QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)row.getString(NUMBER))};
                DynamicObject[] tplObjects = BusinessDataServiceHelper.load((String)MSG_TEMPLATE, (String)COMMONLANG, (QFilter[])filters);
                msgTemplate = (String)tplObjects[0].get(COMMONLANG);
            } else {
                Map mapData = (Map)SerializationUtils.fromJsonString((String)templateCacheData, Map.class);
                JSONObject tplObj = JSONObject.parseObject((String)mapData.get(TPLCONTENT).toString());
                msgTemplate = tplObj.getString(COMMONLANG);
            }
            row.set(MSGTEMPLATE, (Object)msgTemplate);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IPageCache pageCache = this.getPageCache();
        if (MessageUtils.isNotEmpty((String)pageCache.get(MSG_CHANNEL))) {
            pageCache.remove(MSG_CHANNEL);
        }
        if (MessageUtils.isNotEmpty((String)pageCache.get(MSG_TYPE))) {
            pageCache.remove(MSG_TYPE);
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        String fieldKey = args.getListFieldKey();
        if (MSGCHANNEL.equalsIgnoreCase(fieldKey) || MSGTYPE.equalsIgnoreCase(fieldKey)) {
            List valueMapItems = args.getComboItems();
            this.wrapComboItems(fieldKey, null, valueMapItems);
        }
        super.listColumnCompareTypesSet(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!MSGCHANNEL.equalsIgnoreCase(fieldName) && !MSGTYPE.equalsIgnoreCase(fieldName)) continue;
            List comboItems = commonFilterColumn.getComboItems();
            this.wrapComboItems(fieldName, comboItems, null);
        }
        List schemeFilterColumns = args.getSchemeFilterColumns();
        for (FilterColumn filterColumn : schemeFilterColumns) {
            SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)filterColumn;
            String fieldName = schemeFilterColumn.getFieldName();
            if (!MSGCHANNEL.equalsIgnoreCase(fieldName) && !MSGTYPE.equalsIgnoreCase(fieldName)) continue;
            List comboItems = schemeFilterColumn.getComboItems();
            this.wrapComboItems(fieldName, comboItems, null);
        }
        super.filterContainerInit(args);
    }

    private void wrapComboItems(String fieldName, List<ComboItem> comboItems, List<ValueMapItem> valueMapItems) {
        String entityNumber = MSGCHANNEL.equalsIgnoreCase(fieldName) ? MSG_CHANNEL : MSG_TYPE;
        DynamicObject[] dynameObjectDatas = this.getDynameObjectDatas(entityNumber);
        if (dynameObjectDatas != null && dynameObjectDatas.length > 0) {
            if (comboItems != null) {
                comboItems.clear();
            } else {
                valueMapItems.clear();
            }
            for (DynamicObject data : dynameObjectDatas) {
                String value = data.getString(NUMBER);
                if ("sysnotice".equalsIgnoreCase(value)) continue;
                LocaleString name = MessageMultilangageUtils.swithLocaleStringFromOrm((ILocaleString)data.getLocaleString(NAME));
                if (comboItems != null) {
                    comboItems.add(new ComboItem(name, value));
                    continue;
                }
                valueMapItems.add(new ValueMapItem(null, value, name));
            }
            if (MSGCHANNEL.equalsIgnoreCase(fieldName)) {
                String mcValue = MessageChannels.MC.getNumber();
                LocaleString mcName = new LocaleString(ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3", (String)"MessageTemplatePlugin_27", (String)"bos-message-formplugin", (Object[])new Object[0]));
                if (comboItems != null) {
                    comboItems.add(new ComboItem(mcName, mcValue));
                } else {
                    valueMapItems.add(new ValueMapItem(null, mcValue, mcName));
                }
            }
        }
    }

    private DynamicObject[] getDynameObjectDatas(String entityNumber) {
        DynamicObject[] datas = null;
        try {
            IPageCache pageCache;
            datas = BusinessDataServiceHelper.load((String)entityNumber, (String)"number, name", null);
            if (datas != null && datas.length > 0 && StringUtils.isBlank((CharSequence)(pageCache = this.getPageCache()).get(entityNumber))) {
                HashMap<String, String> map = new HashMap<String, String>(datas.length);
                for (DynamicObject data : datas) {
                    map.put(data.getString(NUMBER), data.getLocaleString(NAME).toString());
                }
                pageCache.put(entityNumber, SerializationUtils.toJsonString(map));
            }
        }
        catch (Exception e) {
            logger.info("listColumnInitFaile-channel");
        }
        return datas;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object f7MultiSelect = listShowParameter.getCustomParam("tplF7MultiSelect");
        if (f7MultiSelect != null && ((Boolean)f7MultiSelect).booleanValue()) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.setMulti(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (Delete.class.isInstance(args.getSource())) {
            try {
                ListSelectedRowCollection collection = args.getListSelectedData();
                ArrayList<Long> tplIdList = new ArrayList<Long>();
                for (ListSelectedRow listSelectedRow : collection) {
                    Long tplId = (Long)listSelectedRow.getPrimaryKeyValue();
                    tplIdList.add(tplId);
                }
                String selectedFields = "id, number, msgtype, msgchannel, msgscene, msgentity";
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", tplIdList)};
                DynamicObject[] tplObjects = BusinessDataServiceHelper.load((String)MSG_TEMPLATE, (String)selectedFields, (QFilter[])filters);
                JSONArray keyArray = new JSONArray();
                for (int i = 0; i < tplObjects.length; ++i) {
                    String[] sceneArray;
                    DynamicObject tpl = tplObjects[i];
                    String number = tpl.getString(NUMBER);
                    String msgScene = tpl.getString("msgscene");
                    String entityNumber = tpl.getDynamicObject("msgentity").getString(NUMBER);
                    for (String s : sceneArray = msgScene.split(",")) {
                        String cacheKey = MsgServiceCacheHelper.getTemplateCacheKey((String)tpl.getString(MSGTYPE), (String)tpl.getString(MSGCHANNEL), (String)s, (String)entityNumber);
                        keyArray.add((Object)cacheKey);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)number)) continue;
                    keyArray.add((Object)MsgServiceCacheHelper.getTemplateCacheKey((String)number));
                }
                IPageCache pageCache = this.getPageCache();
                pageCache.put(NEEDDELATETEMPLATE, keyArray.toJSONString());
            }
            catch (Exception e) {
                args.setCancel(Boolean.TRUE.booleanValue());
                MessageUtils.addOperateLog((String)MSG_TEMPLATE, (String)DELETEOPERATION, (String)this.getStaticEntries(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664\u6a21\u677f\u4e4b\u524d\u83b7\u53d6\u7f13\u5b58key\u629b\u51fa\u5f02\u5e38", "MessageTemplateList_3", "bos-message-formplugin"), (Object[])new Object[0]);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (DELETEOPERATION.equalsIgnoreCase(args.getOperateKey())) {
            IPageCache pageCache = this.getPageCache();
            if (args.getOperationResult().isSuccess()) {
                String templateKeys = pageCache.get(NEEDDELATETEMPLATE);
                if (StringUtils.isNotBlank((CharSequence)templateKeys)) {
                    JSONArray tplKeys = JSONArray.parseArray((String)templateKeys);
                    Object[] keysInCache = (String[])tplKeys.toArray((Object[])new String[0]);
                    MsgServiceCacheHelper.deleteCache((String[])keysInCache);
                    MessageUtils.addOperateLog((String)MSG_TEMPLATE, (String)DELETEOPERATION, (String)this.getStaticEntries(), (MultiLangEnumBridge)new MultiLangEnumBridge("%s\u5220\u9664\u6210\u529f", "MessageTemplateList_1", "bos-message-formplugin"), (Object[])new Object[]{Arrays.toString(keysInCache)});
                }
            } else {
                MessageUtils.addOperateLog((String)MSG_TEMPLATE, (String)DELETEOPERATION, (String)this.getStaticEntries(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664\u5931\u8d25", "MessageTemplateList_2", "bos-message-formplugin"), (Object[])new Object[0]);
            }
            pageCache.remove(NEEDDELATETEMPLATE);
        }
    }

    private String getStaticEntries() {
        return ResManager.getLocaleString((String)"\u5220\u9664\u6d88\u606f\u6a21\u677f", (String)MESSAGETEMPLATELIST_0, (String)"bos-message-formplugin").getLocaleValue_zh_CN();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new MessageTemplateListDataProvider());
    }

    static class MessageTemplateListDataProvider
    extends ListDataProvider {
        MessageTemplateListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)MessageTemplateList.NAME)) {
                return rows;
            }
            try {
                ArrayList<Long> ids = new ArrayList<Long>(rows.size());
                for (DynamicObject row : rows) {
                    ids.add(row.getLong("id"));
                }
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
                DynamicObject[] tplObjects = BusinessDataServiceHelper.load((String)MessageTemplateList.MSG_TEMPLATE, (String)"id, name", (QFilter[])filters);
                for (DynamicObject row : rows) {
                    if (!MessageUtils.isEmpty((String)row.getString(MessageTemplateList.NAME))) continue;
                    Long id = row.getLong("id");
                    LocaleString name = new LocaleString();
                    for (DynamicObject obj : tplObjects) {
                        if (id.longValue() != obj.getLong("id")) continue;
                        name = obj.getLocaleString(MessageTemplateList.NAME);
                        break;
                    }
                    if (!MessageUtils.isNotEmpty((ILocaleString)name)) continue;
                    row.set(MessageTemplateList.NAME, (Object)name.getLocaleValue_zh_CN());
                }
            }
            catch (Exception e) {
                logger.info("MessageTemplateListDataProvider is fail");
                return rows;
            }
            return rows;
        }
    }
}

