/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.config.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.mutilLange.MessageMultilangageUtils;
import kd.bos.message.util.PluginUtil;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MessageTypePlugin
extends AbstractFormPlugin {
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String CHANNELS = "channels";
    private static final String DEFCHANNEL = "defChannel";
    private static final String CHANNELNAME = "channelname";
    private static final String MSG_TYPE = "msg_type";
    private static final String ENABLECHANNELIDS = "enableChannelIds";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put(NUMBER, ((String)this.getModel().getValue(NUMBER)).trim());
        this.getPageCache().put(NAME, ((OrmLocaleValue)this.getModel().getValue(NAME)).toString());
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{NUMBER});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.removeChannelInMsgType();
        String number = ((String)this.getModel().getValue(NUMBER)).trim();
        String name = ((OrmLocaleValue)this.getModel().getValue(NAME)).toString();
        boolean ret = false;
        if (args.getSource() instanceof Save) {
            if (StringUtils.isEmpty((CharSequence)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f53\u524d\u8bed\u79cd\u7684\u540d\u79f0\u3002", (String)"MessageTypePlugin_11", (String)"bos-message-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(NUMBER).trim()) && StringUtils.isEmpty((CharSequence)this.getPageCache().get(NAME))) {
                ret = this.isSpecialCharacter(number, name) && this.isUniqueness(NUMBER, ResManager.loadKDString((String)"\u7f16\u7801", (String)"MessageTypePlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]), number) && this.isUniqueness(NAME, ResManager.loadKDString((String)"\u540d\u79f0", (String)"MessageTypePlugin_1", (String)"bos-message-formplugin", (Object[])new Object[0]), name);
            } else if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(NUMBER).trim()) && StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(NAME))) {
                if (!number.equals(this.getPageCache().get(NUMBER))) {
                    boolean bl = ret = this.isSpecialCharacter(number, name) && this.isUniqueness(NUMBER, ResManager.loadKDString((String)"\u7f16\u7801", (String)"MessageTypePlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]), number);
                }
                ret = !name.equals(this.getPageCache().get(NAME)) ? this.isSpecialCharacter(number, name) && this.isUniqueness(NAME, ResManager.loadKDString((String)"\u540d\u79f0", (String)"MessageTypePlugin_1", (String)"bos-message-formplugin", (Object[])new Object[0]), name) : true;
            }
            if (!ret) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            Map map = args.getOperationResult().getBillNos();
            Object pkid = map.entrySet().iterator().next().getKey();
            boolean isAdd = Boolean.TRUE;
            if (!"0".equalsIgnoreCase(String.valueOf(pkid))) {
                isAdd = Boolean.FALSE;
            }
            String addName = ResManager.getLocaleString((String)"\u65b0\u589e\u4fdd\u5b58", (String)"MessageTypePlugin_12", (String)"bos-message-formplugin").getLocaleValue_zh_CN();
            String updateName = ResManager.getLocaleString((String)"\u4fee\u6539\u4fdd\u5b58", (String)"MessageTypePlugin_13", (String)"bos-message-formplugin").getLocaleValue_zh_CN();
            if (args.getOperationResult().isSuccess()) {
                List typeIds = args.getOperationResult().getSuccessPkIds();
                MessageUtils.updateChannelsOfTypeInCache(typeIds.get(0));
                DynamicObject messageTypeDO = BusinessDataServiceHelper.loadSingle(typeIds.get(0), (String)MSG_TYPE);
                this.updateMsgConfig(messageTypeDO);
                String[] channelIdsArray = messageTypeDO.getString(CHANNELS).split(",");
                StringBuilder sb = new StringBuilder();
                String number = this.getPageCache().get(NUMBER);
                for (int i = 0; i < channelIdsArray.length; ++i) {
                    String id = channelIdsArray[i];
                    if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                    sb.append(id).append(',');
                }
                String formatchannelIds = sb.toString();
                if (StringUtils.isNotBlank((CharSequence)formatchannelIds)) {
                    formatchannelIds = formatchannelIds.substring(0, formatchannelIds.length() - 1);
                }
                if (StringUtils.isBlank((CharSequence)number)) {
                    messageTypeDO.set("modifydate", (Object)messageTypeDO.getDate("createdate"));
                }
                messageTypeDO.set(CHANNELS, (Object)formatchannelIds);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{messageTypeDO});
                if (isAdd) {
                    MessageUtils.addOperateLog((String)MSG_TYPE, (String)"new", (String)addName, (MultiLangEnumBridge)new MultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f", "MessageTypePlugin_14", "bos-message-formplugin"), (Object[])new Object[]{this.getModel().getValue(NUMBER)});
                } else {
                    MessageUtils.addOperateLog((String)MSG_TYPE, (String)"modify", (String)updateName, (MultiLangEnumBridge)new MultiLangEnumBridge("%s\u4fee\u6539\u6210\u529f", "MessageTypePlugin_15", "bos-message-formplugin"), (Object[])new Object[]{this.getModel().getValue(NUMBER)});
                }
            } else if (isAdd) {
                MessageUtils.addOperateLog((String)MSG_TYPE, (String)"new", (String)addName, (MultiLangEnumBridge)new MultiLangEnumBridge("%s\u4fdd\u5b58\u5931\u8d25", "MessageTypePlugin_16", "bos-message-formplugin"), (Object[])new Object[]{this.getModel().getValue(NUMBER)});
            } else {
                MessageUtils.addOperateLog((String)MSG_TYPE, (String)"modify", (String)updateName, (MultiLangEnumBridge)new MultiLangEnumBridge("%s\u4fee\u6539\u5931\u8d25", "MessageTypePlugin_17", "bos-message-formplugin"), (Object[])new Object[]{this.getModel().getValue(NUMBER)});
            }
        }
    }

    private void updateMsgConfig(DynamicObject messageTypeDO) {
        MsgServiceCacheHelper.removeMenuConfigCache();
        if ("task".equals(messageTypeDO.get(NUMBER))) {
            return;
        }
        DynamicObject[] msgConfigs = BusinessDataServiceHelper.load((String)"msg_menuconfig", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", messageTypeDO.get(NUMBER))});
        if (msgConfigs == null || msgConfigs.length == 0) {
            DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"msg_menuconfig");
            dObject.set("msgtypeid", (Object)messageTypeDO.getLong(ID));
            dObject.set(NUMBER, messageTypeDO.get(NUMBER));
            dObject.set(NAME, messageTypeDO.get(NAME));
            dObject.set("msgcentershow", (Object)true);
            dObject.set("personalcentershow", (Object)true);
            dObject.set("category", (Object)"message");
            SaveServiceHelper.save((IDataEntityType)dObject.getDataEntityType(), (Object[])new DynamicObject[]{dObject});
        } else if (!messageTypeDO.getString(NAME).isEmpty() && !messageTypeDO.getString(NAME).equals(msgConfigs[0].getString(NAME))) {
            msgConfigs[0].set(NAME, messageTypeDO.get(NAME));
            SaveServiceHelper.update((DynamicObject[])msgConfigs);
        }
    }

    public void pageRelease(EventObject e) {
        this.getPageCache().remove(NUMBER);
        this.getPageCache().remove(NAME);
        this.getPageCache().remove(ENABLECHANNELIDS);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        if (CHANNELS.equalsIgnoreCase(propName)) {
            LocaleString channelName = new LocaleString();
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (!StringUtils.isBlank((CharSequence)newValue)) {
                String[] channelIds;
                String[] stringArray = channelIds = newValue.startsWith(",") ? newValue.substring(1).split(",") : newValue.split(",");
                if (channelIds.length != 0) {
                    ArrayList<Long> cIds = new ArrayList<Long>(channelIds.length);
                    for (String cId : channelIds) {
                        cIds.add(Long.valueOf(cId));
                    }
                    QFilter[] filters = new QFilter[]{new QFilter(ID, "in", cIds), new QFilter("enable", "=", (Object)Boolean.TRUE)};
                    DynamicObject[] channelObjects = BusinessDataServiceHelper.load((String)"msg_channel", (String)"id,name", (QFilter[])filters);
                    ArrayList<ILocaleString> channelNameList = new ArrayList<ILocaleString>(channelObjects.length);
                    for (DynamicObject channelObj : channelObjects) {
                        channelNameList.add(channelObj.getLocaleString(NAME));
                    }
                    channelName = MessageMultilangageUtils.getFormatMergeValue(channelNameList);
                }
            }
            this.getModel().setValue(CHANNELNAME, (Object)channelName);
        }
    }

    private void init() {
        boolean ispreinsdata;
        String originalChannel;
        QFilter f1 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{f1};
        DynamicObject[] channelObjects = BusinessDataServiceHelper.load((String)"msg_channel", (String)"id, number, name", (QFilter[])filters);
        ArrayList<ComboItem> channels = new ArrayList<ComboItem>(channelObjects.length);
        ArrayList<String> enableChannelIds = new ArrayList<String>(channelObjects.length);
        for (DynamicObject channelObj : channelObjects) {
            if ("sysnotice".equalsIgnoreCase(channelObj.getString(NUMBER))) continue;
            Long id = (Long)channelObj.get(ID);
            LocaleString name = MessageMultilangageUtils.swithLocaleStringFromOrm((ILocaleString)channelObj.getLocaleString(NAME));
            channels.add(new ComboItem(name, String.valueOf(id)));
            enableChannelIds.add(id + "");
        }
        if (!channels.isEmpty()) {
            ((MulComboEdit)this.getControl(CHANNELS)).setComboItems(channels);
            this.getPageCache().put(DEFCHANNEL, ((ComboItem)channels.get(0)).getValue());
            this.getPageCache().put(ENABLECHANNELIDS, SerializationUtils.toJsonString(enableChannelIds));
        }
        if (MessageUtils.isNotEmpty((String)(originalChannel = (String)this.getModel().getValue(CHANNELS)))) {
            String[] originalChannelArray = originalChannel.split(",");
            List oc = Arrays.stream(originalChannelArray).collect(Collectors.toList());
            oc.retainAll(enableChannelIds);
            this.getModel().setValue(CHANNELS, (Object)String.join((CharSequence)",", oc));
        }
        if (!(ispreinsdata = ((Boolean)this.getModel().getValue("ispreinsdata")).booleanValue()) || OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            ArrayList<ComboItem> categoryComoItems = new ArrayList<ComboItem>();
            categoryComoItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8b66\u544a\u901a\u77e5", (String)"MessageTypePlugin_9", (String)"bos-message-formplugin", (Object[])new Object[0])), "notice"));
            categoryComoItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u666e\u901a\u6d88\u606f", (String)"MessageTypePlugin_10", (String)"bos-message-formplugin", (Object[])new Object[0])), "message"));
            ((ComboEdit)this.getControl("category")).setComboItems(categoryComoItems);
        }
        if (ispreinsdata) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"category", "desc"});
        }
    }

    private boolean isSpecialCharacter(String number, String name) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)number) && !PluginUtil.matchPattern("^[\\w]+$", number)) {
            sb.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5e94\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\u3002", (String)"MessageTypePlugin_5", (String)"bos-message-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)name) && !PluginUtil.matchPattern("^[\\w\\u4e00-\\u9fa5-()]+$", name)) {
            sb.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5e94\u4f7f\u7528\u5b57\u6bcd\u3001\u4e2d\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u62ec\u53f7\u6216\u6a2a\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\u3002", (String)"MessageTypePlugin_6", (String)"bos-message-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            this.getView().showTipNotification(sb.toString());
            return false;
        }
        return true;
    }

    private boolean isUniqueness(String field, String label, String value) {
        QFilter f1 = new QFilter(field, "=", (Object)value);
        QFilter[] filters = new QFilter[]{f1};
        DynamicObject[] schemeObjects = BusinessDataServiceHelper.load((String)MSG_TYPE, (String)field, (QFilter[])filters);
        if (schemeObjects.length > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MessageTypePlugin_7", (String)"bos-message-formplugin", (Object[])new Object[0]), label));
            return false;
        }
        return true;
    }

    private void removeChannelInMsgType() {
        String enableChannelIdsStr = this.getPageCache().get(ENABLECHANNELIDS);
        if (MessageUtils.isEmpty((String)enableChannelIdsStr)) {
            this.getModel().setValue(CHANNELS, null);
        } else {
            List enableChannelIds = (List)SerializationUtils.fromJsonString((String)enableChannelIdsStr, List.class);
            StringBuilder channelIds = new StringBuilder();
            if (this.getModel().getValue(CHANNELS) != null) {
                String[] channels;
                for (String channelId : channels = ((String)this.getModel().getValue(CHANNELS)).split(",")) {
                    if (!MessageUtils.isNotEmpty((String)channelId) || !enableChannelIds.contains(channelId)) continue;
                    channelIds.append(channelId).append(",");
                }
            }
            if (MessageUtils.isNotEmptyString((Object)channelIds)) {
                String chan = channelIds.toString();
                chan = chan.endsWith(",") ? chan.substring(0, chan.length() - 1) : chan;
                this.getModel().setValue(CHANNELS, (Object)chan);
            } else {
                this.getModel().setValue(CHANNELS, null);
            }
        }
    }
}

