/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.config.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PubAccountPlugin
extends AbstractFormPlugin {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CHANNEL = "channel";
    private static final String PUBACCID = "pubaccid";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put(PUBACCID, ((String)this.getModel().getValue(PUBACCID)).trim());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String pubAccId = ((String)this.getModel().getValue(PUBACCID)).trim();
        boolean ret = false;
        if (args.getSource() instanceof Save) {
            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(PUBACCID).trim())) {
                ret = this.isUniqueness(PUBACCID, ResManager.loadKDString((String)"\u516c\u4f17\u53f7ID", (String)"PubAccountPlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]), pubAccId);
            } else if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(PUBACCID).trim())) {
                ret = !pubAccId.equals(this.getPageCache().get(PUBACCID)) ? this.isUniqueness(PUBACCID, ResManager.loadKDString((String)"\u516c\u4f17\u53f7ID", (String)"PubAccountPlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]), pubAccId) : true;
            }
        }
        if (!ret) {
            args.setCancel(true);
            return;
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(PUBACCID);
    }

    private void init() {
        QFilter f1 = new QFilter("category", "=", (Object)"mobileApp");
        QFilter[] filters = new QFilter[]{f1};
        DynamicObject[] channelObjects = BusinessDataServiceHelper.load((String)"msc_channel", (String)"id, name, category", (QFilter[])filters);
        ArrayList<ComboItem> channels = new ArrayList<ComboItem>(channelObjects.length);
        for (DynamicObject channelObj : channelObjects) {
            Long id = (Long)channelObj.get(ID);
            String name = ((OrmLocaleValue)channelObj.get(NAME)).getLocaleValue();
            channels.add(new ComboItem(new LocaleString(name), String.valueOf(id)));
        }
        if (!channels.isEmpty()) {
            ((ComboEdit)this.getControl(CHANNEL)).setComboItems(channels);
        }
    }

    private boolean isUniqueness(String field, String label, String value) {
        QFilter f1 = new QFilter(field, "=", (Object)value);
        QFilter[] filters = new QFilter[]{f1};
        DynamicObject[] channelObjects = BusinessDataServiceHelper.load((String)"msc_pubacc", (String)field, (QFilter[])filters);
        if (channelObjects.length > 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5%s\u5df2\u5b58\u5728", (String)"PubAccountPlugin_1", (String)"bos-message-formplugin", (Object[])new Object[0]), label));
            return false;
        }
        return true;
    }
}

