/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.monitor.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.utils.AccessTokenUtils;
import kd.bos.message.service.utils.DingdingProcessInstanceUtils;
import kd.bos.message.service.utils.DingdingTodoUtils;
import kd.bos.message.service.utils.TodoResult;
import kd.bos.message.service.utils.TodoStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class WorkflowDealDingTodoPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(WorkflowDealDingTodoPlugin.class);
    private static final String DINGDIGNTODO = "wf_msg_dingtodo";
    private static final String BTN_DEAL = "dealtodo";
    private static final String BTN_GETSTATE = "gettodo";
    private static final String BTN_DELETE = "deletetodo";
    private static final String DEALCONTENT = "dealcontent";
    private static final String USERID = "userid";
    private static final String TASK = "task";
    private static final String PROCESS = "process";
    private static final String AGENTID = "agentid";
    private static final String APPKEY = "appkey";
    private static final String APPSCRET = "appscret";
    private static final String TYPE_TASK = "1";
    private static final String TYPE_PROCESS = "2";
    private static final String TOHANDLE = "tohandle";
    private static final String HANDLED = "handled";
    private static final String INCOMPLETE = "incomplete";
    private static final String COMPLETE = "complete";
    private static final String RESULT = "result";
    private static final String API_RESULT = "apiret";
    private static final String APIRESULT = "apiResult";
    private static final String RET_PANEL = "retpanel";
    private static final String TASKID = "taskid";
    private static final String INSTSTATE = "inststate";
    private static final String RESULTTEXT = "resultText";
    private static final String ERRCODE = "errcode";
    private static final String PROCINSTID = "procinstid";
    private static final String ERRORMSG = "errmsg";
    private static final String WORKFLOWDEALDINGTODOPLUGIN_7 = "WorkflowDealDingTodoPlugin_7";
    private static final String WORKFLOWDEALDINGTODOPLUGIN_15 = "WorkflowDealDingTodoPlugin_15";
    private static final String WORKFLOWDEALDINGTODOPLUGIN_16 = "WorkflowDealDingTodoPlugin_16";
    private static final String WORKFLOWDEALDINGTODOPLUGIN_11 = "WorkflowDealDingTodoPlugin_11";
    private static final String TODOSTATE = "todostate";

    private String getStaticEntriesOfProc() {
        return ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u672a\u4ea7\u751f\uff0c\u6216\u5df2\u5b8c\u6210\u3002", (String)WORKFLOWDEALDINGTODOPLUGIN_11, (String)"bos-message-formplugin", (Object[])new Object[0]);
    }

    private String getStaticEntriesOfTask() {
        return ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1\u672a\u751f\u6210\u6216\u5df2\u5904\u7406\u5b8c\u6210\u3002", (String)WORKFLOWDEALDINGTODOPLUGIN_7, (String)"bos-message-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_DEAL, BTN_GETSTATE, BTN_DELETE});
        this.showUsersAddCustomParam();
    }

    private void showUsersAddCustomParam() {
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(USERID);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    private void addFilterToBasedataEdit() {
        Object user = this.getModel().getValue(USERID);
        BasedataEdit taskF7 = (BasedataEdit)this.getControl(TASK);
        BasedataEdit processF7 = (BasedataEdit)this.getControl(PROCESS);
        if (StringUtils.isNotBlank((Object)user)) {
            Long userId = ((DynamicObject)user).getLong("id");
            QFilter taskfFilter = new QFilter("assigneeid", "=", (Object)userId);
            taskF7.setQFilter(taskfFilter);
            QFilter processFilter = new QFilter("startuserid", "=", (Object)userId);
            processF7.setQFilter(processFilter);
        } else {
            taskF7.setQFilters(new ArrayList());
            processF7.setQFilters(new ArrayList());
        }
    }

    public void afterCreateNewData(EventObject e) {
        MsgChannelInfo dingCacheInfo = MsgServiceCache.getMsgChannel((String)"dingding");
        if (dingCacheInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u9489\u9489\u670d\u52a1\uff0c\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u5e73\u53f0\u201d\u68c0\u67e5\u3002", (String)"WorkflowDealDingTodoPlugin_0", (String)"bos-message-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(AGENTID, (Object)dingCacheInfo.getAgentid());
        this.getModel().setValue(APPKEY, (Object)dingCacheInfo.getAppkey());
        this.getModel().setValue(APPSCRET, (Object)dingCacheInfo.getAppsecret());
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if (DEALCONTENT.equals(prop)) {
            this.getModel().setValue(TASK, (Object)"");
            this.getModel().setValue(PROCESS, (Object)"");
            this.getModel().setValue(USERID, (Object)"");
            this.getView().setVisible(Boolean.FALSE, new String[]{RET_PANEL});
            if (TYPE_TASK.equals(this.getModel().getValue(DEALCONTENT))) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETE});
            }
        } else if (TASK.equals(prop) || PROCESS.equals(prop)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RET_PANEL});
        } else if (USERID.equals(prop)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RET_PANEL});
            this.addFilterToBasedataEdit();
        }
        super.propertyChanged(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_GETSTATE.equals(key)) {
            this.getState();
        } else if (BTN_DEAL.equals(key)) {
            this.deal(BTN_DEAL);
        } else if (BTN_DELETE.equals(key)) {
            this.deal(BTN_DELETE);
        }
    }

    private void getState() {
        String checkRes = this.check();
        if (StringUtils.isNotBlank((CharSequence)checkRes)) {
            this.getView().showTipNotification(checkRes);
            return;
        }
        String type = (String)this.getModel().getValue(DEALCONTENT);
        Map<Object, Object> result = new HashMap();
        if (TYPE_TASK.equals(type)) {
            result = this.getDingTodoState();
        } else if (TYPE_PROCESS.equals(type)) {
            result = this.getDingProcessInstState();
        }
        this.analyResult(result);
    }

    private Map<String, String> getDingProcessInstState() {
        DynamicObject process = (DynamicObject)this.getModel().getValue(PROCESS);
        long processInstId = process.getLong("id");
        QFilter filter = new QFilter(TASKID, "=", (Object)processInstId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)DINGDIGNTODO, (String)INSTSTATE, (QFilter[])new QFilter[]{filter});
        String resultText = "";
        if (obj == null) {
            resultText = this.getStaticEntriesOfProc();
        } else {
            String processState = obj.getString(INSTSTATE);
            if (StringUtils.isBlank((CharSequence)processState)) {
                resultText = this.getStaticEntriesOfProc();
            } else if (INCOMPLETE.equals(processState)) {
                resultText = ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u672a\u5b8c\u6210\u3002", (String)"WorkflowDealDingTodoPlugin_13", (String)"bos-message-formplugin", (Object[])new Object[0]);
            } else if (COMPLETE.equals(processState)) {
                resultText = ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u5b8c\u6210\u3002", (String)"WorkflowDealDingTodoPlugin_14", (String)"bos-message-formplugin", (Object[])new Object[0]);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(RESULTTEXT, resultText);
        return map;
    }

    private Map<String, String> getDingTodoState() {
        DynamicObject task = (DynamicObject)this.getModel().getValue(TASK);
        long sourcesId = task.getLong("id");
        QFilter filter = new QFilter(TASKID, "=", (Object)sourcesId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)DINGDIGNTODO, (String)TODOSTATE, (QFilter[])new QFilter[]{filter});
        String resultText = "";
        if (obj == null) {
            resultText = this.getStaticEntriesOfTask();
        } else {
            String taskState = obj.getString(TODOSTATE);
            if (StringUtils.isBlank((CharSequence)taskState)) {
                resultText = this.getStaticEntriesOfTask();
            } else if (TOHANDLE.equals(taskState)) {
                resultText = ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1\u5df2\u751f\u6210\uff0c\u5f85\u5904\u7406\u3002", (String)"WorkflowDealDingTodoPlugin_9", (String)"bos-message-formplugin", (Object[])new Object[0]);
            } else if (HANDLED.equals(taskState)) {
                resultText = ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1\u5df2\u5904\u7406\u5b8c\u6210\u3002", (String)"WorkflowDealDingTodoPlugin_10", (String)"bos-message-formplugin", (Object[])new Object[0]);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(RESULTTEXT, resultText);
        return map;
    }

    private void deal(String dealType) {
        String checkRes = this.check();
        if (StringUtils.isNotBlank((CharSequence)checkRes)) {
            this.getView().showTipNotification(checkRes);
            return;
        }
        String type = (String)this.getModel().getValue(DEALCONTENT);
        Map<Object, Object> result = new HashMap();
        if (TYPE_TASK.equals(type)) {
            result = this.dealDingTodo(dealType);
        } else if (TYPE_PROCESS.equals(type)) {
            result = this.dealDingProcessInst();
        }
        this.analyResult(result);
    }

    private Map<String, String> dealDingProcessInst() {
        DynamicObject process = (DynamicObject)this.getModel().getValue(PROCESS);
        long processInstanceId = process.getLong("id");
        QFilter filter = new QFilter(PROCINSTID, "=", (Object)processInstanceId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)DINGDIGNTODO, (String)"inststate, dprocinstid, dtodoid", (QFilter[])new QFilter[]{filter});
        String resultText = null;
        String apiResult = null;
        if (obj == null) {
            resultText = this.getStaticEntriesOfProc();
        } else {
            String appKey = (String)this.getModel().getValue(APPKEY);
            String appSecret = (String)this.getModel().getValue(APPSCRET);
            JSONObject tokenResult = AccessTokenUtils.getDingdingAccessToken((String)appKey, (String)appSecret);
            try {
                if (tokenResult.getInteger(ERRCODE) != 0) {
                    logger.info("\u83b7\u53d6token\u5931\u8d25\uff1a" + tokenResult.getString(ERRORMSG));
                    resultText = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)WORKFLOWDEALDINGTODOPLUGIN_15, (String)"bos-message-formplugin", (Object[])new Object[0]);
                    apiResult = tokenResult.toJSONString();
                } else {
                    String dProcessInstanceId = obj.getString("dprocinstid");
                    String accessToken = tokenResult.getString("access_token");
                    String agentId = (String)this.getModel().getValue(AGENTID);
                    String status = TodoStatus.COMPLETED.getNumber();
                    String result = TodoResult.AGREE.getNumber();
                    JSONObject reqResult = DingdingProcessInstanceUtils.updateProcessInstanceStatus((Long)Long.valueOf(agentId), (String)accessToken, (String)dProcessInstanceId, (String)status, (String)result);
                    if (reqResult.getInteger(ERRCODE) != 0) {
                        logger.info("update todo is error, errorinfo is:" + reqResult.getString(ERRORMSG));
                        resultText = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)WORKFLOWDEALDINGTODOPLUGIN_15, (String)"bos-message-formplugin", (Object[])new Object[0]);
                        apiResult = reqResult.getString(ERRORMSG);
                    } else {
                        resultText = ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)WORKFLOWDEALDINGTODOPLUGIN_16, (String)"bos-message-formplugin", (Object[])new Object[0]);
                        WorkflowDealDingTodoPlugin.updateDingProcess(processInstanceId);
                        WorkflowDealDingTodoPlugin.deleteupdateDingProcess(processInstanceId);
                    }
                }
            }
            catch (Exception e) {
                resultText = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)WORKFLOWDEALDINGTODOPLUGIN_15, (String)"bos-message-formplugin", (Object[])new Object[0]);
                apiResult = e.getMessage();
                logger.info("deal dingtodo is error, errorinfo is :" + e.getMessage());
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(RESULTTEXT, resultText);
        map.put(APIRESULT, apiResult);
        return map;
    }

    private Map<String, String> dealDingTodo(String dealType) {
        DynamicObject task = (DynamicObject)this.getModel().getValue(TASK);
        long taskId = task.getLong("id");
        QFilter filter = new QFilter(TASKID, "=", (Object)taskId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)DINGDIGNTODO, (String)"procinstid, todostate, inststate, dprocinstid, dtodoid", (QFilter[])new QFilter[]{filter});
        String resultText = null;
        String apiResult = null;
        if (obj == null) {
            resultText = this.getStaticEntriesOfTask();
        } else {
            String appKey = (String)this.getModel().getValue(APPKEY);
            String appSecret = (String)this.getModel().getValue(APPSCRET);
            JSONObject tokenResult = AccessTokenUtils.getDingdingAccessToken((String)appKey, (String)appSecret);
            try {
                if (tokenResult.getInteger(ERRCODE) != 0) {
                    logger.info("\u83b7\u53d6token\u5931\u8d25\uff1a" + tokenResult.getString(ERRORMSG));
                    resultText = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)WORKFLOWDEALDINGTODOPLUGIN_15, (String)"bos-message-formplugin", (Object[])new Object[0]);
                    apiResult = tokenResult.toJSONString();
                } else {
                    String dProcessInstanceId = obj.getString("dprocinstid");
                    String dTodoId = obj.getString("dtodoid");
                    String accessToken = tokenResult.getString("access_token");
                    String agentId = (String)this.getModel().getValue(AGENTID);
                    String status = BTN_DEAL.equals(dealType) ? TodoStatus.COMPLETED.getNumber() : TodoStatus.CANCELED.getNumber();
                    String result = TodoResult.AGREE.getNumber();
                    JSONObject reqResult = DingdingTodoUtils.updateTodoStatus((Long)Long.valueOf(agentId), (String)accessToken, (String)dProcessInstanceId, (Long)Long.valueOf(dTodoId), (String)status, (String)result);
                    if (reqResult.getInteger(ERRCODE) != 0) {
                        logger.info("update todo is error, errorinfo is:" + reqResult.getString(ERRORMSG));
                        resultText = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)WORKFLOWDEALDINGTODOPLUGIN_15, (String)"bos-message-formplugin", (Object[])new Object[0]);
                        apiResult = reqResult.getString(ERRORMSG);
                    } else {
                        resultText = ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)WORKFLOWDEALDINGTODOPLUGIN_16, (String)"bos-message-formplugin", (Object[])new Object[0]);
                        if (COMPLETE.equals(obj.getString(INSTSTATE))) {
                            this.deleteTodoInfo(taskId);
                        } else {
                            WorkflowDealDingTodoPlugin.updateDingTodo(taskId);
                        }
                    }
                }
            }
            catch (Exception e) {
                resultText = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)WORKFLOWDEALDINGTODOPLUGIN_15, (String)"bos-message-formplugin", (Object[])new Object[0]);
                apiResult = e.getMessage();
                logger.info("deal dingtodo is error, errorinfo is :" + e.getMessage());
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(RESULTTEXT, resultText);
        map.put(APIRESULT, apiResult);
        return map;
    }

    private void deleteTodoInfo(Long taskId) {
        QFilter[] filters = new QFilter[]{new QFilter(TASKID, "=", (Object)taskId)};
        DeleteServiceHelper.delete((String)DINGDIGNTODO, (QFilter[])filters);
    }

    public static void deleteupdateDingProcess(Long processInstanceId) {
        QFilter[] filters = new QFilter[]{new QFilter(PROCINSTID, "=", (Object)processInstanceId)};
        DeleteServiceHelper.delete((String)DINGDIGNTODO, (QFilter[])filters);
    }

    public static void updateDingTodo(Long taskId) {
        QFilter[] filters = new QFilter[]{new QFilter(TASKID, "=", (Object)taskId)};
        DynamicObject dingTodo = BusinessDataServiceHelper.loadSingle((String)DINGDIGNTODO, (String)TODOSTATE, (QFilter[])filters);
        dingTodo.set(TODOSTATE, (Object)HANDLED);
        SaveServiceHelper.update((DynamicObject)dingTodo);
    }

    public static void updateDingProcess(Long processInstanceId) {
        QFilter[] filters = new QFilter[]{new QFilter(PROCINSTID, "=", (Object)processInstanceId)};
        DynamicObject[] dingTodoList = BusinessDataServiceHelper.load((String)DINGDIGNTODO, (String)INSTSTATE, (QFilter[])filters);
        for (int i = 0; i < dingTodoList.length; ++i) {
            dingTodoList[i].set(INSTSTATE, (Object)COMPLETE);
        }
        SaveServiceHelper.update((DynamicObject[])dingTodoList);
    }

    private String check() {
        DynamicObject process;
        DynamicObject task;
        String type = (String)this.getModel().getValue(DEALCONTENT);
        DynamicObject user = (DynamicObject)this.getModel().getValue(USERID);
        if (user == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u3002", (String)"WorkflowDealDingTodoPlugin_1", (String)"bos-message-formplugin", (Object[])new Object[0]);
        }
        if (TYPE_TASK.equals(type) && (task = (DynamicObject)this.getModel().getValue(TASK)) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u3002", (String)"WorkflowDealDingTodoPlugin_2", (String)"bos-message-formplugin", (Object[])new Object[0]);
        }
        if (TYPE_PROCESS.equals(type) && (process = (DynamicObject)this.getModel().getValue(PROCESS)) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u3002", (String)"WorkflowDealDingTodoPlugin_3", (String)"bos-message-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue(AGENTID))) {
            return ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u5e94\u7528ID\u201d\u3002", (String)"WorkflowDealDingTodoPlugin_4", (String)"bos-message-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue(APPKEY))) {
            return ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5e94\u7528Key\u3002", (String)"WorkflowDealDingTodoPlugin_5", (String)"bos-message-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue(APPSCRET))) {
            return ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5e94\u7528\u79d8\u94a5\u3002", (String)"WorkflowDealDingTodoPlugin_6", (String)"bos-message-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void analyResult(Map<String, String> result) {
        if (result != null) {
            String apiResText;
            String resultText = result.get(RESULTTEXT);
            if (StringUtils.isNotBlank((CharSequence)resultText)) {
                Label resultLable = (Label)this.getControl(RESULT);
                resultLable.setText(resultText);
            }
            if (StringUtils.isNotBlank((CharSequence)(apiResText = result.get(APIRESULT)))) {
                Label apiResult = (Label)this.getControl(API_RESULT);
                apiResult.setText(apiResText);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{RET_PANEL});
        }
    }
}

