/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PluginUtil {
    public static boolean matchPattern(String patternStr, String value) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public static String getCacheKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getAccountId()).append('_');
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]).append('_');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static boolean isEmpty(ILocaleString value) {
        if (value == null || value.keySet().isEmpty()) {
            return true;
        }
        for (String key : value.keySet()) {
            if (!PluginUtil.isNotEmpty((String)value.get((Object)key))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(ILocaleString value) {
        return !PluginUtil.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() <= 0;
    }

    public static boolean isNotEmpty(String value) {
        return !PluginUtil.isEmpty(value);
    }

    public static void setComboForControl(Map<String, Object> items, ComboEdit operation) {
        ComboItem comboItem = null;
        LocaleString localeString = null;
        Set<Map.Entry<String, Object>> entrySet = items.entrySet();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(entrySet.size());
        for (Map.Entry<String, Object> entry : entrySet) {
            comboItem = new ComboItem();
            localeString = new LocaleString();
            localeString.setLocaleValue(entry.getKey());
            comboItem.setCaption(localeString);
            comboItem.setValue(entry.getValue().toString());
            comboItems.add(comboItem);
        }
        operation.setComboItems(comboItems);
    }

    public static boolean isJSONObject(Object object) {
        if (StringUtils.isNotBlank((Object)object)) {
            try {
                JSONObject.parseObject((String)object.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isEmptyString(Object value) {
        if (Objects.isNull(value)) {
            return Boolean.TRUE;
        }
        return PluginUtil.isEmpty(value.toString());
    }
}

