/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.DingdingMessageInfo;
import kd.bos.message.api.DingdingMsgOperateType;
import kd.bos.message.api.DingdingTodoInfo;
import kd.bos.message.api.DingdingTodoOperateType;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.api.IMessageService;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.message.api.WeixinqyMessageInfo;
import kd.bos.message.api.YzjMessageInfo;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.service.handler.DingdingHandler;
import kd.bos.message.service.handler.WeixinqyHandler;
import kd.bos.message.utils.MessageUtils;
import kd.bos.message.utils.SMSLicenseWhilteUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import org.apache.commons.beanutils.MethodUtils;

public class MessageServiceImpl
implements IMessageService {
    private static Log logger = LogFactory.getLog(MessageServiceImpl.class);

    public void sendYzjMessage(YzjMessageInfo yzjMessageInfo) {
        MessageInfo messageInfo = this.convertMessageInfo(yzjMessageInfo);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public void sendEmail(EmailInfo emailInfo) {
        if (!MessageChannelUtils.isEnable((String)"email")) {
            logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u670d\u52a1\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6\uff0c\u8bf7\u524d\u5f80\u7cfb\u7edf\u7ba1\u7406\u6d88\u606f\u5e73\u53f0\u914d\u7f6e");
            return;
        }
        MessageInfo messageInfo = this.convertMessageInfo(emailInfo);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public void sendShortMessage(ShortMessageInfo shortMessageInfo) {
        this.sendShortMessage(shortMessageInfo, Boolean.TRUE);
    }

    public void sendShortMessage(ShortMessageInfo shortMessageInfo, Boolean isCheckLicense) {
        if (!MessageChannelUtils.isEnable((String)"sms")) {
            logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u670d\u52a1\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1\uff0c\u8bf7\u524d\u5f80\u7cfb\u7edf\u7ba1\u7406\u6d88\u606f\u5e73\u53f0\u914d\u7f6e");
            return;
        }
        MessageInfo messageInfo = this.convertMessageInfo(shortMessageInfo);
        messageInfo.getParams().put("iscl", isCheckLicense != false ? Boolean.valueOf(SMSLicenseWhilteUtils.judgeLicense()) : isCheckLicense);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private MessageInfo convertMessageInfo(Object msg) {
        MessageInfo messageInfo = new MessageInfo();
        if (msg instanceof EmailInfo) {
            EmailInfo emailInfo = (EmailInfo)msg;
            messageInfo.setTitle(emailInfo.getTitle());
            messageInfo.setContent(emailInfo.getContent());
            if (emailInfo.getAttachmentNames() != null && emailInfo.getAttachments() != null && emailInfo.getAttachments().size() == emailInfo.getAttachmentNames().size()) {
                MessageAttachment attachment = new MessageAttachment();
                attachment.setAttachmentNames(emailInfo.getAttachmentNames());
                attachment.setAttachments(emailInfo.getAttachments());
                messageInfo.setAttachment(attachment);
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("email", emailInfo.getReceiver());
            param.put("emailCR", emailInfo.getCopyReceiver());
            param.put("emailSR", emailInfo.getSecretReceiver());
            param.put("bizDescprtion", "bizUseOldImpl");
            messageInfo.setParams(param);
            messageInfo.setNotifyType("email");
        } else if (msg instanceof ShortMessageInfo) {
            ShortMessageInfo smsInfo = (ShortMessageInfo)msg;
            messageInfo.setContent(smsInfo.getMessage());
            List<String> phoneList = new ArrayList();
            HashMap<String, Object> param = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)smsInfo.getCountryCode())) {
                String countryCode = smsInfo.getCountryCode();
                List ps = smsInfo.getPhone();
                for (int i = 0; i < ps.size(); ++i) {
                    String phoneNumber = (String)ps.get(i);
                    if (!phoneNumber.contains("-")) {
                        phoneNumber = countryCode + "-" + phoneNumber;
                    }
                    phoneList.add(phoneNumber);
                }
            } else {
                phoneList = smsInfo.getPhone();
            }
            param.put("phone", phoneList);
            param.put("bizDescprtion", "bizUseOldImpl");
            messageInfo.setParams(param);
            messageInfo.setNotifyType("sms");
        }
        return messageInfo;
    }

    public String getChannelsByMsgTypeNum(String msgTypeNumber) {
        String channelsOfType = "";
        Map typeInfo = MessageUtils.getMessageTypeInfo((String)msgTypeNumber);
        if (typeInfo != null && !typeInfo.isEmpty()) {
            channelsOfType = (String)typeInfo.get("channels");
        }
        return channelsOfType;
    }

    public String getHashTag(String accountId) {
        String hashTag = MessageChannelUtils.getMessageChannelHashTag((String)accountId);
        return hashTag;
    }

    public Map<String, Object> dingdingTodo(DingdingTodoInfo todoInfo) {
        Map<String, Object> operateResult = null;
        String todoType = todoInfo.getTodoType();
        if (DingdingTodoOperateType.CREATE.getNumber().equals(todoType)) {
            operateResult = DingdingHandler.createtodo(todoInfo);
        } else if (DingdingTodoOperateType.DEAL.getNumber().equals(todoType)) {
            String processInstanceId = todoInfo.getProcessInstanceId();
            Long taskId = todoInfo.getTaskId();
            operateResult = DingdingHandler.dealTodo(processInstanceId, taskId);
        } else if (DingdingTodoOperateType.DELETE.getNumber().equals(todoType)) {
            String processInstanceId = todoInfo.getProcessInstanceId();
            Long taskId = todoInfo.getTaskId();
            operateResult = DingdingHandler.deleteTodo(processInstanceId, taskId);
        }
        return operateResult;
    }

    public Map<String, Object> dingdingMessage(DingdingMessageInfo messageInfo) {
        Map<String, Object> operateResult = null;
        String messageType = messageInfo.getMessageType();
        if (DingdingMsgOperateType.CREATE.getNumber().equals(messageType)) {
            operateResult = DingdingHandler.sendMessage(messageInfo);
        } else if (DingdingMsgOperateType.CHECK.getNumber().equals(messageType)) {
            operateResult = DingdingHandler.checkMessageResult();
        } else if (DingdingMsgOperateType.RECALL.getNumber().equals(messageType)) {
            operateResult = DingdingHandler.recallMessage();
        }
        return operateResult;
    }

    public Map<String, Object> dingdingUpdateProcessInstanceState(String state, String dingProcessInstId) {
        return DingdingHandler.updateDingProcessInstanceState(state, dingProcessInstId);
    }

    public Map<String, Object> queryDDTask(String userId, long offSet, long count, long status) {
        return DingdingHandler.queryDDTask(userId, offSet, count, status);
    }

    public Map<String, Object> sendWeixinqyMessage(WeixinqyMessageInfo messageInfo) {
        return WeixinqyHandler.sendMessage(messageInfo);
    }

    public Object invokeMsgBizPlugin(String clazz, String method, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        logger.info(String.format("invoke biz plugin: %s %s", clazz, method));
        Object obj = TypesContainer.createInstance((String)clazz);
        Object result = false;
        try {
            result = MethodUtils.invokeMethod((Object)obj, (String)method, (Object[])args);
        }
        catch (Exception e) {
            logger.error(String.format("Invoke %s's %s Error! %s %s", obj, method, e.getMessage(), MessageUtils.getExceptionStacktrace((Throwable)e)));
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                throw new KDBizException(t, new ErrorCode("wf.invokeMsgBizPlugin", "%s"), new Object[]{t.getMessage()});
            }
            throw e;
        }
        return result;
    }
}

