/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.util.RevProxyUtil;

public class MessageSqlUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(MessageSqlUpgradeServiceImpl.class);
    private static final String FMOBILDAPPCONFIG = "fmobileappconfig";

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            boolean channelTableExist = DB.exitsTable((DBRoute)DBRoute.basedata, (String)"t_msg_channel");
            if (!channelTableExist) {
                return this.wrapResultMap(resultMap, true, "", "", "success");
            }
            DynamicObject yunzhjiaChannel = this.getChannel();
            if (yunzhjiaChannel != null) {
                String yunzhijiaDomain = MessageServiceProperties.yunzhijiaDomain;
                String yzjKingdeeDomain = MessageServiceProperties.yzjkingdeeDomain;
                String pubaccIcon = RevProxyUtil.addSlash((String)yunzhijiaDomain) + "appsys/download.action?filename=10669.png&type=1";
                String accreditUrl = RevProxyUtil.addSlash((String)yunzhijiaDomain) + "gateway/oauth2/token/getAccessToken";
                String pubaccApiUrl = RevProxyUtil.addSlash((String)yzjKingdeeDomain) + "pubacc/pubsend";
                String pubaccId = MessageServiceProperties.pubaccId;
                String pubaccKey = MessageServiceProperties.pubaccKey;
                String mobileAppConfig = yunzhjiaChannel.getString(FMOBILDAPPCONFIG);
                if (StringUtils.isNotBlank((CharSequence)mobileAppConfig) && mobileAppConfig.trim().endsWith("}") && mobileAppConfig.indexOf("systempubacc") == -1) {
                    JSONObject systempub = new JSONObject();
                    systempub.put("pubaccicon", (Object)pubaccIcon);
                    systempub.put("accrediturl", (Object)accreditUrl);
                    systempub.put("pubaccapiurl", (Object)pubaccApiUrl);
                    systempub.put("pubaccid", (Object)pubaccId);
                    systempub.put("pubacckey", (Object)pubaccKey);
                    systempub.put("pubaccname", (Object)ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u6d88\u606f\u52a9\u624b", (String)"MessageSqlUpgradeServiceImpl_0", (String)"bos-mservice-message", (Object[])new Object[0]));
                    systempub.put("pubaccnumber", (Object)"systempubacc");
                    JSONArray config = new JSONArray();
                    config.add((Object)systempub);
                    JSONObject preConfig = JSONObject.parseObject((String)mobileAppConfig);
                    preConfig.put("pubaccnumber", (Object)"flowassist");
                    config.add((Object)preConfig);
                    yunzhjiaChannel.set(FMOBILDAPPCONFIG, (Object)config.toJSONString());
                    yunzhjiaChannel.set("fmodifydate", (Object)System.currentTimeMillis());
                    this.saveChannel(yunzhjiaChannel);
                    logger.debug("MessageSqlUpgradeServiceImpl--upgrade msg yunzhijiconfig success");
                    MessageChannelUtils.updateMsgChannelTagKeyInCache();
                    MsgServiceCache.refreshMsgChannelCacheInfo((String)"yunzhijia", (boolean)false);
                    logger.debug("MessageSqlUpgradeServiceImpl--update yunzhijia cache success");
                    this.wrapResultMap(resultMap, true, "", "", "success");
                }
            }
        }
        catch (Exception e) {
            logger.debug("MessageSqlUpgradeServiceImpl--- upgrade is error:" + e.getMessage());
            this.wrapResultMap(resultMap, false, e.getMessage(), "", e.getMessage());
        }
        return resultMap;
    }

    private DynamicObject getChannel() {
        String sql = "select fid, fmobileappconfig, fmodifydate from t_msg_channel where fid = 475756772099906560;";
        DynamicObjectCollection col = null;
        DynamicObject channelObj = null;
        try (DataSet ds = DB.queryDataSet((String)"MessageCenter.MessageSqlUpgradeServiceImpl.getChannel", (DBRoute)DBRoute.basedata, (String)sql, null);){
            col = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        if (col != null && col.size() != 0) {
            channelObj = (DynamicObject)col.get(0);
        }
        return channelObj;
    }

    private void saveChannel(DynamicObject channelObj) {
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String datetime = tempDate.format(new Date());
        String d = "{ts '" + datetime + "'}";
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE t_msg_channel SET ");
        sb.append(FMOBILDAPPCONFIG).append(" = ").append("'").append(channelObj.getString(FMOBILDAPPCONFIG)).append("', ");
        sb.append("fmodifydate").append(" = ").append(d).append(" ");
        sb.append("WHERE fid = ").append(channelObj.getLong("fid")).append(";");
        DB.update((DBRoute)DBRoute.basedata, (String)sb.toString());
    }

    public Map<String, Object> afterExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        return null;
    }

    private Map<String, Object> wrapResultMap(Map<String, Object> resultMap, boolean success, String log, String el, String errorInfo) {
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", el);
        resultMap.put("errorInfo", errorInfo);
        return resultMap;
    }
}

