/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.handler;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiProcessWorkrecordTaskQueryRequest;
import com.dingtalk.api.response.OapiProcessWorkrecordTaskQueryResponse;
import com.taobao.api.TaobaoRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.DingdingMessageInfo;
import kd.bos.message.api.DingdingTodoInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.message.service.utils.AccessTokenUtils;
import kd.bos.message.service.utils.DingdingMessageUtils;
import kd.bos.message.service.utils.DingdingProcessInstanceUtils;
import kd.bos.message.service.utils.DingdingTemplateUtils;
import kd.bos.message.service.utils.DingdingTodoUtils;
import kd.bos.message.service.utils.MessageUtils;
import kd.bos.message.service.utils.TodoResult;
import kd.bos.message.service.utils.TodoStatus;
import kd.bos.util.RevProxyUtil;

public class DingdingHandler {
    private static Log logger = LogFactory.getLog(DingdingHandler.class);
    private static final String DINGDING = "dingding";
    private static final String DINGDINGHANDLER_0 = "DingdingHandler_0";
    private static final String TOKENISNULL = "accessToken is null, send messsgae is terminated";
    private static final String ERRORCODE = "errcode";
    private static final String ERRORMSG = "errmsg";
    private static final String RESULT = "result";
    private static final String SUCCESS = "success";

    private static String getStaticEntries() {
        return ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u9489\u9489\u670d\u52a1\uff0c\u8bf7\u5728\u7cfb\u7edf\u7ba1\u7406-\u6d88\u606f\u5e73\u53f0\u68c0\u67e5", (String)DINGDINGHANDLER_0, (String)"bos-mservice-message", (Object[])new Object[0]);
    }

    public static Map<String, Object> createtodo(DingdingTodoInfo todoInfo) {
        JSONObject todoResult;
        logger.info("DingdingHandler--createtodo--\u63a8\u9001\u4f01\u4e1a\u5f85\u529e\u4efb\u52a1" + todoInfo);
        MsgChannelInfo dingCacheInfo = MsgServiceCache.getMsgChannel((String)DINGDING);
        if (dingCacheInfo == null) {
            return MessageUtils.wrapResult(DingdingHandler.getStaticEntries());
        }
        DingdingHandler.wrapDingdingTaskUrl(todoInfo, dingCacheInfo);
        Long agentId = Long.valueOf(dingCacheInfo.getAgentid());
        String accessToken = AccessTokenUtils.getDinddingAccessToken(DINGDING, dingCacheInfo.getAppkey(), dingCacheInfo.getAppsecret(), null);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return MessageUtils.wrapResult(TOKENISNULL);
        }
        boolean ishasdingtpl = todoInfo.isHasDingTpl();
        String processCode = null;
        if (!ishasdingtpl) {
            JSONObject tplResult = DingdingTemplateUtils.createTemplate(agentId, accessToken, todoInfo);
            if (tplResult.getInteger(ERRORCODE) != 0) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u5ba1\u6279\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"DingdingHandler_1", (String)"bos-mservice-message", (Object[])new Object[0]), tplResult.getString(ERRORMSG)));
            }
            processCode = tplResult.getJSONObject(RESULT).getString("process_code");
            DingdingHandler.wrapTemplate(processCode, dingCacheInfo, todoInfo);
        }
        if (StringUtils.isBlank((CharSequence)todoInfo.getProcessInstanceId())) {
            JSONObject insatnceResult = DingdingProcessInstanceUtils.createProcessInstance(agentId, accessToken, todoInfo);
            logger.info("\u521b\u5efa\u5ba1\u6279\u5b9e\u4f8b\u8fd4\u56de\u4fe1\u606f" + insatnceResult.toString());
            if (insatnceResult.getInteger(ERRORCODE) != 0) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u5ba1\u6279\u5b9e\u4f8b\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"DingdingHandler_2", (String)"bos-mservice-message", (Object[])new Object[0]), insatnceResult.getString(ERRORMSG)));
            }
            String processInstanceId = insatnceResult.getJSONObject(RESULT).getString("process_instance_id");
            todoInfo.setProcessInstanceId(processInstanceId);
        }
        if ((todoResult = DingdingTodoUtils.createTodo(agentId, accessToken, todoInfo)).getInteger(ERRORCODE) != 0) {
            return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u5f85\u529e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"DingdingHandler_3", (String)"bos-mservice-message", (Object[])new Object[0]), todoResult.getString(ERRORMSG)));
        }
        logger.info("\u521b\u5efa\u9489\u9489\u5f85\u529e\u8fd4\u56de\u4fe1\u606f" + todoResult.toString());
        Map<String, Object> result = MessageUtils.wrapResult(SUCCESS);
        result.put("taskid", todoResult.getJSONArray("tasks").getJSONObject(0).getString("task_id"));
        result.put("processinstanceid", todoInfo.getProcessInstanceId());
        result.put("tplid", todoInfo.getTplProcessCode());
        return result;
    }

    public static Map<String, Object> dealTodo(String processInstanceId, Long taskId) {
        logger.info("DingdingHandler--dealTodo--\u5904\u7406\u5f85\u529e\u72b6\u6001 " + processInstanceId + " taskId: " + taskId);
        MsgChannelInfo dingCacheInfo = MsgServiceCache.getMsgChannel((String)DINGDING);
        if (dingCacheInfo == null) {
            return MessageUtils.wrapResult(DingdingHandler.getStaticEntries());
        }
        Long agentId = Long.valueOf(dingCacheInfo.getAgentid());
        String accessToken = AccessTokenUtils.getDinddingAccessToken(DINGDING, dingCacheInfo.getAppkey(), dingCacheInfo.getAppsecret(), null);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return MessageUtils.wrapResult(TOKENISNULL);
        }
        String status = TodoStatus.COMPLETED.getNumber();
        String result = TodoResult.AGREE.getNumber();
        JSONObject todoResult = DingdingTodoUtils.updateTodoStatus(agentId, accessToken, processInstanceId, taskId, status, result);
        logger.info("\u5904\u7406\u9489\u9489\u5f85\u529e\u8fd4\u56de\u4fe1\u606f" + todoResult.toString());
        if (todoResult.getInteger(ERRORCODE) != 0) {
            return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5f85\u529e\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"DingdingHandler_4", (String)"bos-mservice-message", (Object[])new Object[0]), todoResult.getString(ERRORMSG)));
        }
        return MessageUtils.wrapResult(SUCCESS);
    }

    public static Map<String, Object> deleteTodo(String processInstanceId, Long taskId) {
        logger.info("DingdingHandler--dealTodo--\u5904\u7406\u5f85\u529e\u72b6\u6001 " + processInstanceId + " taskId: " + taskId);
        MsgChannelInfo dingCacheInfo = MsgServiceCache.getMsgChannel((String)DINGDING);
        if (dingCacheInfo == null) {
            return MessageUtils.wrapResult(DingdingHandler.getStaticEntries());
        }
        Long agentId = Long.valueOf(dingCacheInfo.getAgentid());
        String accessToken = AccessTokenUtils.getDinddingAccessToken(DINGDING, dingCacheInfo.getAppkey(), dingCacheInfo.getAppsecret(), null);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return MessageUtils.wrapResult(TOKENISNULL);
        }
        String status = TodoStatus.TERMINATED.getNumber();
        String result = TodoResult.AGREE.getNumber();
        status = TodoStatus.CANCELED.getNumber();
        JSONObject todoResult = DingdingTodoUtils.updateTodoStatus(agentId, accessToken, processInstanceId, taskId, status, result);
        logger.info("\u5220\u9664\u9489\u9489\u5f85\u529e\u8fd4\u56de\u4fe1\u606f" + todoResult.toString());
        if (todoResult.getInteger(ERRORCODE) != 0) {
            return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5f85\u529e\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"DingdingHandler_4", (String)"bos-mservice-message", (Object[])new Object[0]), todoResult.getString(ERRORMSG)));
        }
        return MessageUtils.wrapResult(SUCCESS);
    }

    public static Map<String, Object> updateDingProcessInstanceState(String processInstState, String dingProcessInstanceId) {
        logger.info("DingdingHandler--dealTodo--update\u9489\u9489\u5b9e\u4f8b\u72b6\u6001 " + dingProcessInstanceId);
        MsgChannelInfo dingCacheInfo = MsgServiceCache.getMsgChannel((String)DINGDING);
        if (dingCacheInfo == null) {
            return MessageUtils.wrapResult(DingdingHandler.getStaticEntries());
        }
        if (StringUtils.isBlank((CharSequence)dingCacheInfo.getAgentid())) {
            return MessageUtils.wrapResult(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u9489\u9489\u8f7b\u5e94\u7528\u3002", (String)"DingdingHandler_7", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        Long agentId = Long.valueOf(dingCacheInfo.getAgentid());
        String accessToken = AccessTokenUtils.getDinddingAccessToken(DINGDING, dingCacheInfo.getAppkey(), dingCacheInfo.getAppsecret(), null);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return MessageUtils.wrapResult(TOKENISNULL);
        }
        String status = TodoStatus.COMPLETED.getNumber();
        String result = TodoResult.AGREE.getNumber();
        if (processInstState.equalsIgnoreCase("terminate")) {
            status = TodoStatus.TERMINATED.getNumber();
        }
        JSONObject processInstanceResult = DingdingProcessInstanceUtils.updateProcessInstanceStatus(agentId, accessToken, dingProcessInstanceId, status, result);
        logger.info("\u66f4\u65b0\u9489\u9489\u5b9e\u4f8b\u4fe1\u606f\u8fd4\u56de\u4fe1\u606f" + processInstanceResult.toString());
        if (processInstanceResult.getInteger(ERRORCODE) != 0) {
            return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5b9e\u4f8b\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"DingdingHandler_5", (String)"bos-mservice-message", (Object[])new Object[0]), processInstanceResult.getString(ERRORMSG)));
        }
        return MessageUtils.wrapResult(SUCCESS);
    }

    public static Map<String, Object> sendMessage(DingdingMessageInfo messageInfo) {
        logger.info("DingdingHandler--sendMessage--\u63a8\u9001\u4f01\u4e1a\u901a\u77e5" + messageInfo);
        MsgChannelInfo dingCacheInfo = MsgServiceCache.getMsgChannel((String)DINGDING);
        if (dingCacheInfo == null) {
            return MessageUtils.wrapResult(DingdingHandler.getStaticEntries());
        }
        if (messageInfo.isLinkMsg()) {
            DingdingHandler.wrapDingMsgUrl(messageInfo, dingCacheInfo);
            logger.info("DingdingHandler--sendMessage--\u9489\u9489\u6d88\u606f\u94fe\u63a5\uff1a" + messageInfo.getMsgUrl());
        }
        Map<Object, Object> rs = new HashMap();
        try {
            String accessToken = AccessTokenUtils.getDinddingAccessToken(DINGDING, dingCacheInfo.getAppkey(), dingCacheInfo.getAppsecret(), null);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                return MessageUtils.wrapResult(TOKENISNULL);
            }
            Long agentId = Long.valueOf(dingCacheInfo.getAgentid());
            JSONObject result = DingdingMessageUtils.sendMessage(agentId, accessToken, messageInfo);
            logger.info("\u53d1\u9001\u9489\u9489\u6d88\u606f\u8fd4\u56de\u4fe1\u606f" + result.toString());
            if (result.getInteger(ERRORCODE) != 0) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u53d1\u9001\u4f01\u4e1a\u901a\u77e5\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"DingdingHandler_6", (String)"bos-mservice-message", (Object[])new Object[0]), result.getString(ERRORMSG)));
            }
            logger.info("DingdingHandler--sendMessage--\u63a8\u9001\u4f01\u4e1a\u901a\u77e5success");
            rs = MessageUtils.wrapResult(SUCCESS);
            rs.put("msgid", result.getString("task_id"));
        }
        catch (Exception e) {
            rs = MessageUtils.wrapResult(e.getMessage());
        }
        return rs;
    }

    public static Map<String, Object> queryDDTask(String openId, long offSet, long count, long status) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        MsgChannelInfo dingCacheInfo = MsgServiceCache.getMsgChannel((String)DINGDING);
        if (dingCacheInfo == null) {
            return MessageUtils.wrapResult(DingdingHandler.getStaticEntries());
        }
        String accessToken = AccessTokenUtils.getDinddingAccessToken(DINGDING, dingCacheInfo.getAppkey(), dingCacheInfo.getAppsecret(), null);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return MessageUtils.wrapResult(TOKENISNULL);
        }
        OapiProcessWorkrecordTaskQueryRequest req = new OapiProcessWorkrecordTaskQueryRequest();
        req.setUserid(openId);
        req.setOffset(Long.valueOf(offSet));
        req.setCount(Long.valueOf(count));
        req.setStatus(Long.valueOf(status));
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/workrecord/task/query";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            OapiProcessWorkrecordTaskQueryResponse rsp = (OapiProcessWorkrecordTaskQueryResponse)client.execute((TaobaoRequest)req, accessToken);
            retMap.put(ERRORCODE, rsp.getErrcode());
            retMap.put(ERRORMSG, rsp.getErrmsg());
            ArrayList resultData = new ArrayList();
            OapiProcessWorkrecordTaskQueryResponse.PageResult result = rsp.getResult();
            if (null != result) {
                retMap.put("has_more", result.getHasMore());
                List formList = result.getList();
                if (null != formList && formList.size() > 0) {
                    for (OapiProcessWorkrecordTaskQueryResponse.WorkRecordVo f : formList) {
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("taskId", f.getTaskId());
                        m.put("instanceId", f.getInstanceId());
                        m.put("title", f.getTitle());
                        m.put("url", f.getUrl());
                        resultData.add(m);
                    }
                }
            }
            retMap.put(RESULT, resultData);
        }
        catch (Exception e) {
            MessageUtils.wrapResult(e.getMessage());
        }
        return retMap;
    }

    public static Map<String, Object> checkMessageResult() {
        return null;
    }

    public static Map<String, Object> recallMessage() {
        return null;
    }

    private static void wrapTemplate(String processCode, MsgChannelInfo dingCacheInfo, DingdingTodoInfo todoInfo) {
        todoInfo.setTplProcessCode(processCode);
        todoInfo.setHasDingTpl(true);
    }

    private static void wrapDingMsgUrl(DingdingMessageInfo messageInfo, MsgChannelInfo dingCacheInfo) {
        String messageUrl = messageInfo.getMsgUrl();
        String url1 = "&apptype=dd&corpid=" + dingCacheInfo.getCorpid() + "&appkey=" + dingCacheInfo.getAppkey() + "&agentid=" + dingCacheInfo.getAgentid() + "&appsecret=" + dingCacheInfo.getAppsecret();
        String urlPart = "?" + url1 + "&";
        messageUrl = messageUrl.replace("?", urlPart) + "&device=mob";
        String urlEncodeKey = "";
        try {
            urlEncodeKey = URLEncoder.encode(messageUrl, StandardCharsets.UTF_8.name());
            StringBuffer sb = new StringBuffer();
            sb.append("dingtalk://dingtalkclient/page/link?url=");
            sb.append(urlEncodeKey);
            sb.append("&pc_slide=");
            sb.append(messageInfo.isOpenInDing() ? "true" : "false");
            messageInfo.setMsgUrl(sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            logger.info("wrapDingMsgUrl--\u4f01\u4e1a\u901a\u77e5\u94fe\u63a5encode\u5f02\u5e38\uff0cmsg:" + e.getMessage());
        }
    }

    private static void wrapDingdingTaskUrl(DingdingTodoInfo todoInfo, MsgChannelInfo dingCacheInfo) {
        String todoUrl = todoInfo.getTodoUrl();
        todoInfo.setTodoUrl(DingdingHandler.handleUrl(todoUrl, dingCacheInfo));
        String processInstUrl = todoInfo.getInstanceUrl();
        if (processInstUrl != null && StringUtils.isNotBlank((CharSequence)processInstUrl)) {
            todoInfo.setInstanceUrl(DingdingHandler.handleUrl(processInstUrl, dingCacheInfo));
        }
    }

    private static String handleUrl(String originalUrl, MsgChannelInfo dingCacheInfo) {
        String url1 = "&apptype=dd&corpid=" + dingCacheInfo.getCorpid() + "&appkey=" + dingCacheInfo.getAppkey() + "&agentid=" + dingCacheInfo.getAgentid() + "&appsecret=" + dingCacheInfo.getAppsecret();
        String urlPart = "?" + url1 + "&";
        originalUrl = originalUrl.replace("?", urlPart);
        String[] todoUrlParam = originalUrl.split("&");
        StringBuilder sb = new StringBuilder();
        for (String up : todoUrlParam) {
            if (up.contains("appId=") || up.contains("formId=") || up.contains("pCaption=") || up.contains("fromyzj=")) {
                if (!up.contains("mb_formId")) continue;
                sb.append(up).append("&");
                continue;
            }
            sb.append(up).append("&");
        }
        sb.append("device=mob");
        String urlNew = sb.toString();
        return urlNew;
    }
}

