/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.WeixinqyMessageInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.utils.AccessTokenUtils;
import kd.bos.message.service.utils.MessageUtils;
import kd.bos.util.HttpClientUtils;

public class WeixinqyHandler {
    private static Log logger = LogFactory.getLog(WeixinqyHandler.class);
    private static final String WEIXINQY = "weixinqy";
    private static final String TODO = "todo";
    private static final String COMMON = "common";
    private static final String BTN_KEY = "key";
    private static final String BTN_NAME = "name";
    private static final String BTN_REPLACENAME = "replace_name";
    private static final String ERRORCODE = "errcode";
    private static final String TASK_ID = "task_id";
    private static final String WXQY_MSGTYPE_TASKCARD = "taskcard";
    private static final String WXQY_MSGTYPE_TEXTCARD = "textcard";

    public static Map<String, Object> sendMessage(WeixinqyMessageInfo messageInfo) {
        logger.info("WeixinqyHandler--sendMessage--\u63a8\u9001\u5fae\u4fe1\u6d88\u606f" + messageInfo);
        MsgChannelInfo weixinCacheInfo = MsgServiceCache.getMsgChannel((String)WEIXINQY);
        if (weixinCacheInfo == null) {
            return MessageUtils.wrapResult(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1\u670d\u52a1\uff0c\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u8bbe\u7f6e\u201d\u68c0\u67e5\u3002", (String)"WeixinqyHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        if (messageInfo.isLinkMsg()) {
            WeixinqyHandler.wrapWeixinqyMessageUrl(messageInfo, weixinCacheInfo);
            logger.debug("WeixinqyHandler--sendMessage--\u5fae\u4fe1\u6d88\u606f\u94fe\u63a5\uff1a" + messageInfo.getMsgUrl());
        }
        String corpId = weixinCacheInfo.getCorpid();
        String appId = weixinCacheInfo.getAgentid();
        String appSecret = weixinCacheInfo.getAppsecret();
        Map<Object, Object> rs = new HashMap();
        try {
            String accessToken = AccessTokenUtils.getDinddingAccessToken(WEIXINQY, appId, appSecret, corpId);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                return MessageUtils.wrapResult("accessToken is null, send messsgae is terminated");
            }
            JSONObject msgResult = WeixinqyHandler.pushMessage(messageInfo, accessToken, weixinCacheInfo);
            if (msgResult.getInteger(ERRORCODE) != 0 && msgResult.getInteger(ERRORCODE) != 42014) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WeixinqyHandler_1", (String)"bos-mservice-message", (Object[])new Object[0]), msgResult.getString("errmsg")));
            }
            String weixinqyMsgType = WeixinqyHandler.getMsgType(weixinCacheInfo);
            if (WXQY_MSGTYPE_TASKCARD.equalsIgnoreCase(weixinqyMsgType)) {
                String taskCardType = TODO.equals(messageInfo.getMsgType()) ? "todoBtn" : "unreadBtn";
                JSONObject updateBtnResult = WeixinqyHandler.updateMessage(messageInfo, accessToken, weixinCacheInfo, taskCardType);
                if (updateBtnResult.getInteger(ERRORCODE) != 0 && updateBtnResult.getInteger(ERRORCODE) != 42014) {
                    return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f-\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WeixinqyHandler_6", (String)"bos-mservice-message", (Object[])new Object[0]), updateBtnResult.getString("errmsg")));
                }
                logger.debug("sendMessage--\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606fsuccess");
                WeixinqyHandler.updateMessage(messageInfo, accessToken, weixinCacheInfo, taskCardType);
            }
            rs = MessageUtils.wrapResult("success");
            rs.put("msgid", messageInfo.getMsgId());
        }
        catch (Exception e) {
            rs = MessageUtils.wrapResult(e.getMessage());
        }
        return rs;
    }

    private static String getMsgType(MsgChannelInfo weixinCacheInfo) {
        if (weixinCacheInfo == null) {
            return WXQY_MSGTYPE_TASKCARD;
        }
        String config = weixinCacheInfo.getConfig();
        if (kd.bos.message.utils.MessageUtils.isEmpty((String)config)) {
            return WXQY_MSGTYPE_TASKCARD;
        }
        try {
            JSONObject jsonConfig = JSONObject.parseObject((String)weixinCacheInfo.getConfig());
            String msgType = jsonConfig.getString("msgType");
            if (msgType != null && WXQY_MSGTYPE_TEXTCARD.equalsIgnoreCase(msgType)) {
                return WXQY_MSGTYPE_TEXTCARD;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("getMsgType is error:[%s]", e.getMessage()));
        }
        return WXQY_MSGTYPE_TASKCARD;
    }

    private static JSONObject pushMessage(WeixinqyMessageInfo messageInfo, String accessToken, MsgChannelInfo weixinCacheInfo) {
        StringBuilder url = new StringBuilder();
        String domain = AccessTokenUtils.getWeiXinQyDomain(weixinCacheInfo);
        logger.info("pushMessage domain:" + domain);
        url.append(domain).append("cgi-bin/message/send?access_token=");
        url.append(accessToken);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Accept", "application/json;charset=UTF-8");
        header.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject messageBody = WeixinqyHandler.wrapMessageBodyJson(messageInfo, weixinCacheInfo);
        String result = "";
        JSONObject msgResult = new JSONObject();
        try {
            result = HttpClientUtils.postjson((String)url.toString(), header, (String)messageBody.toJSONString());
            msgResult = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            logger.warn("pushMessage--take exception by user weixin sendMessage api, msg:" + e.getMessage());
            msgResult.put(ERRORCODE, (Object)"101");
            msgResult.put("errmsg", (Object)e.getMessage());
        }
        return msgResult;
    }

    private static JSONObject wrapMessageBodyJson(WeixinqyMessageInfo messageInfo, MsgChannelInfo weixinCacheInfo) {
        JSONObject body = new JSONObject();
        body.put("touser", (Object)messageInfo.getUserIds());
        logger.info(String.format("wxqy-u-%s", messageInfo.getUserIds()));
        body.put("agentid", (Object)Long.valueOf(weixinCacheInfo.getAgentid()));
        body.put("enable_id_trans", (Object)"0");
        if (messageInfo.isLinkMsg()) {
            JSONObject textBody = new JSONObject();
            textBody.put("title", (Object)messageInfo.getTitle());
            textBody.put("description", (Object)messageInfo.getContent());
            textBody.put("url", (Object)messageInfo.getMsgUrl());
            String weixinqyMsgType = WeixinqyHandler.getMsgType(weixinCacheInfo);
            if (WXQY_MSGTYPE_TASKCARD.equalsIgnoreCase(weixinqyMsgType)) {
                if (messageInfo.getParams() != null && StringUtils.isNotBlank(messageInfo.getParams().get("uid"))) {
                    textBody.put(TASK_ID, (Object)(messageInfo.getMsgId() + String.valueOf(messageInfo.getParams().get("uid"))));
                } else {
                    textBody.put(TASK_ID, (Object)(messageInfo.getMsgId() + messageInfo.getUserIds()));
                }
                JSONArray btnBody = WeixinqyHandler.buildTaskCardBody(messageInfo.getMsgType());
                textBody.put("btn", (Object)btnBody);
                body.put(WXQY_MSGTYPE_TASKCARD, (Object)textBody);
                body.put("msgtype", (Object)WXQY_MSGTYPE_TASKCARD);
            } else if (WXQY_MSGTYPE_TEXTCARD.equalsIgnoreCase(weixinqyMsgType)) {
                textBody.put("btntxt", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"WeixinqyHandler_2", (String)"bos-mservice-message", (Object[])new Object[0]));
                body.put(WXQY_MSGTYPE_TEXTCARD, (Object)textBody);
                body.put("msgtype", (Object)WXQY_MSGTYPE_TEXTCARD);
            }
        } else {
            JSONObject textBody = new JSONObject();
            textBody.put("content", (Object)messageInfo.getContent());
            body.put("msgtype", (Object)"text");
            body.put("safe", (Object)"0");
            body.put("text", (Object)textBody);
        }
        return body;
    }

    private static JSONArray buildTaskCardBody(String type) {
        JSONArray btns = new JSONArray();
        if (TODO.equals(type)) {
            JSONObject todo = new JSONObject();
            todo.put(BTN_KEY, (Object)"todoBtn");
            todo.put(BTN_NAME, (Object)ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"WeixinqyHandler_7", (String)"bos-mservice-message", (Object[])new Object[0]));
            todo.put(BTN_REPLACENAME, (Object)ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"WeixinqyHandler_7", (String)"bos-mservice-message", (Object[])new Object[0]));
            JSONObject handled = new JSONObject();
            handled.put(BTN_KEY, (Object)"handledBtn");
            handled.put(BTN_NAME, (Object)ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"WeixinqyHandler_3", (String)"bos-mservice-message", (Object[])new Object[0]));
            handled.put(BTN_REPLACENAME, (Object)ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"WeixinqyHandler_3", (String)"bos-mservice-message", (Object[])new Object[0]));
            btns.add((Object)todo);
            btns.add((Object)handled);
        } else {
            JSONObject read = new JSONObject();
            read.put(BTN_KEY, (Object)"unreadBtn");
            read.put(BTN_NAME, (Object)ResManager.loadKDString((String)"\u672a\u8bfb", (String)"WeixinqyHandler_4", (String)"bos-mservice-message", (Object[])new Object[0]));
            read.put(BTN_REPLACENAME, (Object)ResManager.loadKDString((String)"\u672a\u8bfb", (String)"WeixinqyHandler_4", (String)"bos-mservice-message", (Object[])new Object[0]));
            JSONObject unread = new JSONObject();
            unread.put(BTN_KEY, (Object)"readBtn");
            unread.put(BTN_NAME, (Object)ResManager.loadKDString((String)"\u5df2\u8bfb", (String)"WeixinqyHandler_5", (String)"bos-mservice-message", (Object[])new Object[0]));
            unread.put(BTN_REPLACENAME, (Object)ResManager.loadKDString((String)"\u5df2\u8bfb", (String)"WeixinqyHandler_5", (String)"bos-mservice-message", (Object[])new Object[0]));
            btns.add((Object)read);
            btns.add((Object)unread);
        }
        return btns;
    }

    private static void wrapWeixinqyMessageUrl(WeixinqyMessageInfo messageInfo, MsgChannelInfo weixinCacheInfo) {
        String msgUrl = messageInfo.getMsgUrl();
        int index = msgUrl.indexOf(63);
        String msgUrlPart1 = msgUrl.substring(0, index + 1);
        String msgUrlPart2 = msgUrl.substring(index + 1);
        String[] msgUrlParts = msgUrlPart2.split("&");
        StringBuilder sb = new StringBuilder(msgUrlPart1);
        for (String up : msgUrlParts) {
            if ((up.contains("appId=") || up.contains("formId=") || up.contains("pCaption=")) && !"formId=msg_openmessageurl".equals(up)) {
                if (!up.contains("mb_formId")) continue;
                sb.append(up).append("&");
                continue;
            }
            sb.append(up).append("&");
        }
        sb.append("device=mob");
        if (WeixinqyHandler.isReplaceAppModel()) {
            sb.append("&").append("wxqyhMode=thirdPartyMode");
        }
        msgUrl = sb.toString();
        String url1 = "apptype=wxqyh&corpid=" + weixinCacheInfo.getCorpid() + "&agentid=" + weixinCacheInfo.getAgentid();
        String urlPart = "?" + url1 + "&";
        String originalUrl = msgUrl.replace("?", urlPart);
        logger.info("wrapWeixinqyMessageUrl: " + msgUrl);
        String urlEncodeKey = "";
        try {
            urlEncodeKey = URLEncoder.encode(originalUrl, StandardCharsets.UTF_8.name());
            StringBuilder afterEncodeUrl = new StringBuilder();
            afterEncodeUrl.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=");
            afterEncodeUrl.append(weixinCacheInfo.getCorpid());
            afterEncodeUrl.append("&redirect_uri=");
            afterEncodeUrl.append(urlEncodeKey);
            afterEncodeUrl.append("&response_type=code&scope=snsapi_base&state=STATE#wechat_redirect");
            messageInfo.setMsgUrl(afterEncodeUrl.toString());
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("wrapWeixinqyMessageUrl--\u4f01\u4e1a\u5fae\u4fe1\u94fe\u63a5encode\u5f02\u5e38\uff0cmsg:" + e.getMessage());
        }
    }

    private static boolean isReplaceAppModel() {
        boolean isReplaceApp = false;
        try {
            MsgChannelInfo weixinCacheInfo = MsgServiceCache.getMsgChannel((String)WEIXINQY);
            String mobileappconfig = weixinCacheInfo.getMobileappconfig();
            if (kd.bos.message.utils.MessageUtils.isNotEmpty((String)mobileappconfig)) {
                JSONObject config = JSONObject.parseObject((String)mobileappconfig);
                isReplaceApp = config.getBooleanValue("isreplaceapp");
            }
        }
        catch (Exception e) {
            logger.error(String.format("WeixinqyServiceHandler-error:%s", kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e)));
        }
        return isReplaceApp;
    }

    public static Map<String, Object> dealTodo(WeixinqyMessageInfo messageInfo) {
        logger.info("WeixinqyHandler--sendMessage--\u6d88\u606f\u5361\u7247\u72b6\u6001\u66f4\u65b0" + messageInfo.toString());
        MsgChannelInfo weixinCacheInfo = MsgServiceCache.getMsgChannel((String)WEIXINQY);
        if (weixinCacheInfo == null) {
            return MessageUtils.wrapResult(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1\u670d\u52a1\uff0c\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u8bbe\u7f6e\u201d\u68c0\u67e5\u3002", (String)"WeixinqyHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        Map<Object, Object> rs = new HashMap();
        try {
            String msgType = WeixinqyHandler.getMsgType(weixinCacheInfo);
            if (WXQY_MSGTYPE_TASKCARD.equalsIgnoreCase(msgType)) {
                String appSecret;
                String corpId = weixinCacheInfo.getCorpid();
                String appId = weixinCacheInfo.getAgentid();
                String accessToken = AccessTokenUtils.getDinddingAccessToken(WEIXINQY, appId, appSecret = weixinCacheInfo.getAppsecret(), corpId);
                if (StringUtils.isBlank((CharSequence)accessToken)) {
                    return MessageUtils.wrapResult("accessToken is null, send messsgae is terminated");
                }
                String clickedKey = TODO.equals(messageInfo.getMsgType()) ? "handledBtn" : "readBtn";
                JSONObject msgResult = WeixinqyHandler.updateMessage(messageInfo, accessToken, weixinCacheInfo, clickedKey);
                if (msgResult.getInteger(ERRORCODE) != 0) {
                    return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WeixinqyHandler_1", (String)"bos-mservice-message", (Object[])new Object[0]), msgResult.getString("errmsg")));
                }
                logger.debug("dealtodo-- \u4f01\u5fae\u4efb\u52a1\u5361\u7247\u66f4\u65b0\u6210\u529f");
                WeixinqyHandler.updateMessage(messageInfo, accessToken, weixinCacheInfo, clickedKey);
            }
            rs = MessageUtils.wrapResult("success");
            rs.put("msgid", messageInfo.getMsgId());
        }
        catch (Exception e) {
            rs = MessageUtils.wrapResult(e.getMessage());
        }
        return rs;
    }

    private static JSONObject updateMessage(WeixinqyMessageInfo messageInfo, String accessToken, MsgChannelInfo weixinCacheInfo, String clickedKey) {
        logger.debug("update taskcard start ,type is " + messageInfo.getMsgType());
        StringBuilder url = new StringBuilder();
        String domain = AccessTokenUtils.getWeiXinQyDomain(weixinCacheInfo);
        logger.debug("updateMessage domain:" + domain);
        url.append(domain).append("cgi-bin/message/update_taskcard?access_token=");
        url.append(accessToken);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Accept", "application/json;charset=UTF-8");
        header.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject messageBody = new JSONObject();
        messageBody.put("agentid", (Object)weixinCacheInfo.getAgentid());
        if (messageInfo.getParams() != null && StringUtils.isNotBlank(messageInfo.getParams().get("uid"))) {
            messageBody.put(TASK_ID, (Object)(messageInfo.getMsgId() + String.valueOf(messageInfo.getParams().get("uid"))));
        } else {
            messageBody.put(TASK_ID, (Object)(messageInfo.getMsgId() + messageInfo.getUserIds()));
        }
        ArrayList<String> userArray = new ArrayList<String>();
        userArray.add(messageInfo.getUserIds());
        messageBody.put("userids", userArray);
        messageBody.put("clicked_key", (Object)clickedKey);
        JSONObject msgResult = new JSONObject();
        try {
            logger.info("updateMessage-- messageinfo is :" + messageBody.toJSONString());
            String result = HttpClientUtils.postjson((String)url.toString(), header, (String)messageBody.toJSONString());
            logger.debug("updateMessage-- update taskcard get post result is :" + result);
            msgResult = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            logger.warn("updateMessage taskcard is wrong, error info is: " + e.getMessage());
            msgResult.put(ERRORCODE, (Object)"101");
            msgResult.put("errmsg", (Object)e.getMessage());
        }
        return msgResult;
    }
}

