/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.WeixinqyMessageInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.message.service.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang.RandomStringUtils;

public class WeixinqyPublicHandler {
    private static Log logger = LogFactory.getLog(WeixinqyPublicHandler.class);
    private static final String TODO = "todo";
    private static final String BTN_KEY = "key";
    private static final String BTN_NAME = "name";
    private static final String BTN_REPLACENAME = "replace_name";
    private static final String DOMAIN = "https://api.kingdee.com/kcclightservice";

    public static Map<String, Object> sendMessage(WeixinqyMessageInfo messageInfo) {
        logger.info("WeixinqyPublicHandler--sendMessage--\u63a8\u9001\u5fae\u4fe1\u6d88\u606f" + messageInfo);
        MsgChannelInfo weixinCacheInfo = MsgServiceCache.getMsgChannel((String)"kingdee_sky");
        if (weixinCacheInfo == null) {
            return MessageUtils.wrapResult(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1\u670d\u52a1\uff0c\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u8bbe\u7f6e\u201d\u68c0\u67e5\u3002", (String)"WeixinqyHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        if (messageInfo.isLinkMsg()) {
            WeixinqyPublicHandler.wrapWeixinqyMessageUrl(messageInfo);
            logger.debug("WeixinqyPublicHandler--sendMessage--\u5fae\u4fe1\u6d88\u606f\u94fe\u63a5\uff1a" + messageInfo.getMsgUrl());
        }
        Map<Object, Object> rs = new HashMap();
        try {
            String taskCardType;
            JSONObject updateBtnResult;
            String accessToken = WeixinqyPublicHandler.getAccessToken(weixinCacheInfo);
            if (accessToken == null) {
                return MessageUtils.wrapResult("accessToken is null, send messsgae is terminated");
            }
            JSONObject msgResult = WeixinqyPublicHandler.pushMessage(messageInfo, accessToken, weixinCacheInfo);
            if (!msgResult.getBooleanValue("success")) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5931\u8d25\uff1a\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u3002", (String)"WeixinqyPublicHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]), msgResult.get((Object)"errorCode"), msgResult.getString("message")));
            }
            if (messageInfo.isLinkMsg && !(updateBtnResult = WeixinqyPublicHandler.updateMessage(messageInfo, accessToken, weixinCacheInfo, taskCardType = TODO.equals(messageInfo.getMsgType()) ? "todoBtn" : "unreadBtn")).getBooleanValue("success")) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f-\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff1a\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u3002", (String)"WeixinqyPublicHandler_1", (String)"bos-mservice-message", (Object[])new Object[0]), updateBtnResult.get((Object)"errorCode"), updateBtnResult.getString("message")));
            }
            logger.debug("sendMessage--\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606fsuccess");
            rs = MessageUtils.wrapResult("success");
            rs.put("msgid", messageInfo.getMsgId());
        }
        catch (Exception e) {
            rs = MessageUtils.wrapResult(e.getMessage());
        }
        return rs;
    }

    public static Map<String, Object> dealMessage(WeixinqyMessageInfo messageInfo) {
        logger.debug("WeixinqyPublicHandler--sendMessage--\u6d88\u606f\u5361\u7247\u72b6\u6001\u66f4\u65b0" + messageInfo.toString());
        MsgChannelInfo weixinCacheInfo = MsgServiceCache.getMsgChannel((String)"kingdee_sky");
        if (weixinCacheInfo == null) {
            return MessageUtils.wrapResult(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1\u670d\u52a1\uff0c\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u8bbe\u7f6e\u201d\u68c0\u67e5\u3002", (String)"WeixinqyHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        Map<Object, Object> rs = new HashMap();
        try {
            String accessToken = WeixinqyPublicHandler.getAccessToken(weixinCacheInfo);
            if (accessToken == null) {
                return MessageUtils.wrapResult("accessToken is null, send messsgae is terminated");
            }
            String clickedKey = TODO.equals(messageInfo.getMsgType()) ? "handledBtn" : "readBtn";
            JSONObject msgResult = WeixinqyPublicHandler.updateMessage(messageInfo, accessToken, weixinCacheInfo, clickedKey);
            if (!msgResult.getBooleanValue("success")) {
                return MessageUtils.wrapResult(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f-\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff1a\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u3002", (String)"WeixinqyPublicHandler_1", (String)"bos-mservice-message", (Object[])new Object[0]), msgResult.get((Object)"errorCode"), msgResult.getString("message")));
            }
            logger.debug("dealMessage-- \u4f01\u5fae\u4efb\u52a1\u5361\u7247\u66f4\u65b0\u6210\u529f");
            rs = MessageUtils.wrapResult("success");
            rs.put("msgid", messageInfo.getMsgId());
        }
        catch (Exception e) {
            rs = MessageUtils.wrapResult(e.getMessage());
        }
        return rs;
    }

    private static String getDomain() {
        String domain = DOMAIN;
        try {
            QFilter qs = new QFilter(BTN_KEY, "=", (Object)"msg.kingdee_sky.domain");
            DynamicObject ret = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_confcenter", (String)"value", (QFilter[])new QFilter[]{qs});
            if (ret != null) {
                domain = ret.getString("value");
            }
        }
        catch (Exception e) {
            logger.warn("msg.kingdee_sky.domain has exception:" + kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e));
        }
        return domain;
    }

    private static String getAccessToken(MsgChannelInfo weixinCacheInfo) {
        String mobileAppConfig = weixinCacheInfo.getMobileappconfig();
        if (!kd.bos.message.utils.MessageUtils.isNotEmpty((String)mobileAppConfig)) {
            return null;
        }
        String wxqyPublicToken = MsgServiceCacheHelper.getWxqyPublicToken();
        if (kd.bos.message.utils.MessageUtils.isNotEmpty((String)wxqyPublicToken)) {
            return wxqyPublicToken;
        }
        JSONObject config = JSONObject.parseObject((String)mobileAppConfig);
        StringBuilder url = new StringBuilder();
        url.append(WeixinqyPublicHandler.getDomain()).append("/").append("connect/getAccessToken");
        url.append("?client_id=").append(WeixinqyPublicHandler.getCloudClientId());
        url.append("&client_secret=").append(WeixinqyPublicHandler.getClientSecret());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Accept", "application/json;charset=UTF-8");
        header.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject body = new JSONObject();
        body.put("eid", (Object)config.getString("eid"));
        body.put("entryRole", (Object)1);
        body.put("accountId", (Object)config.getString("accountId"));
        body.put("secret", (Object)config.getString("secret"));
        body.put("erpRole", (Object)1);
        body.put("timestamp", (Object)System.currentTimeMillis());
        JSONObject msgResult = new JSONObject();
        try {
            String result = HttpClientUtils.postjson((String)url.toString(), header, (String)body.toJSONString());
            logger.debug(String.format("wxqyPublic gettoken [%s]", result));
            msgResult = JSONObject.parseObject((String)result);
            if (msgResult.getBooleanValue("success")) {
                JSONObject data = msgResult.getJSONObject("data");
                if (data != null) {
                    String accessToken = data.getString("accessToken");
                    Integer expireIn = data.getInteger("expireIn");
                    MsgServiceCacheHelper.putWxqyPublicTokenCache((String)accessToken, (int)expireIn);
                    return accessToken;
                }
            } else {
                logger.debug(String.format("wxqyPublic gettoken is error [%s], [%s]", msgResult.get((Object)"errorCode"), msgResult.getString("message")));
            }
        }
        catch (Exception e) {
            logger.warn(String.format("wxqyPublic gettoken is error [%s]", kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e)));
        }
        return null;
    }

    private static JSONObject pushMessage(WeixinqyMessageInfo messageInfo, String accessToken, MsgChannelInfo weixinCacheInfo) {
        StringBuilder url = new StringBuilder();
        url.append(WeixinqyPublicHandler.getDomain()).append("/").append("connect/sendNoticeMessage");
        url.append("?client_id=").append(WeixinqyPublicHandler.getCloudClientId());
        url.append("&client_secret=").append(WeixinqyPublicHandler.getClientSecret());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Accept", "application/json;charset=UTF-8");
        header.put("Content-Type", "application/json;charset=UTF-8");
        header.put("Authorization", "Bearer " + accessToken);
        JSONObject messageBody = WeixinqyPublicHandler.wrapMessageBodyJson(messageInfo, weixinCacheInfo);
        JSONObject msgResult = new JSONObject();
        try {
            String result = HttpClientUtils.postjson((String)url.toString(), header, (String)messageBody.toJSONString());
            logger.debug(String.format("pushMessage--res[%s]", result));
            msgResult = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            logger.warn("pushMessage--take exception by user weixin sendMessage api, msg:" + kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e));
        }
        return msgResult;
    }

    private static JSONObject updateMessage(WeixinqyMessageInfo messageInfo, String accessToken, MsgChannelInfo weixinCacheInfo, String clickedKey) {
        logger.debug("update taskcard start ,type is " + messageInfo.getMsgType());
        StringBuilder url = new StringBuilder();
        url.append(WeixinqyPublicHandler.getDomain()).append("/").append("connect/updateNoticeMessage");
        url.append("?client_id=").append(WeixinqyPublicHandler.getCloudClientId());
        url.append("&client_secret=").append(WeixinqyPublicHandler.getClientSecret());
        logger.info("updateMessage-- url is :" + url);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Accept", "application/json;charset=UTF-8");
        header.put("Content-Type", "application/json;charset=UTF-8");
        header.put("Authorization", "Bearer " + accessToken);
        JSONObject body = new JSONObject();
        if (messageInfo.getParams() != null && StringUtils.isNotBlank(messageInfo.getParams().get("uid"))) {
            body.put("bizId", (Object)(messageInfo.getMsgId() + String.valueOf(messageInfo.getParams().get("uid"))));
        } else {
            body.put("bizId", (Object)(messageInfo.getMsgId() + messageInfo.getUserIds()));
        }
        body.put("appId", (Object)weixinCacheInfo.getAgentid());
        body.put("status", (Object)3);
        body.put("toUser", (Object)messageInfo.getUserIds());
        body.put("timestamp", (Object)System.currentTimeMillis());
        body.put("nonce", (Object)RandomStringUtils.randomAlphanumeric((int)32));
        JSONObject details = new JSONObject();
        details.put("cardButton", (Object)clickedKey);
        JSONObject option = new JSONObject();
        option.put("msgType", (Object)5);
        option.put("details", (Object)details);
        body.put("option", (Object)option);
        JSONObject msgResult = new JSONObject();
        try {
            logger.info("updateMessage-- messageinfo is :" + body.toJSONString());
            String result = HttpClientUtils.postjson((String)url.toString(), header, (String)body.toJSONString());
            logger.debug("updateMessage-- update taskcard get post result is :" + result);
            body.put("timestamp", (Object)System.currentTimeMillis());
            body.put("nonce", (Object)RandomStringUtils.randomAlphanumeric((int)32));
            result = HttpClientUtils.postjson((String)url.toString(), header, (String)body.toJSONString());
            logger.debug("updateMessage-- update two");
            msgResult = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            logger.warn("updateMessage taskcard is wrong, error info is: " + kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e));
        }
        return msgResult;
    }

    private static JSONArray buildTaskCardBody(String type) {
        JSONArray btns = new JSONArray();
        if (TODO.equals(type)) {
            JSONObject todo = new JSONObject();
            todo.put(BTN_KEY, (Object)"todoBtn");
            todo.put(BTN_NAME, (Object)ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"WeixinqyHandler_7", (String)"bos-mservice-message", (Object[])new Object[0]));
            todo.put(BTN_REPLACENAME, (Object)ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"WeixinqyHandler_7", (String)"bos-mservice-message", (Object[])new Object[0]));
            JSONObject handled = new JSONObject();
            handled.put(BTN_KEY, (Object)"handledBtn");
            handled.put(BTN_NAME, (Object)ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"WeixinqyHandler_3", (String)"bos-mservice-message", (Object[])new Object[0]));
            handled.put(BTN_REPLACENAME, (Object)ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"WeixinqyHandler_3", (String)"bos-mservice-message", (Object[])new Object[0]));
            btns.add((Object)todo);
            btns.add((Object)handled);
        } else {
            JSONObject read = new JSONObject();
            read.put(BTN_KEY, (Object)"unreadBtn");
            read.put(BTN_NAME, (Object)ResManager.loadKDString((String)"\u672a\u8bfb", (String)"WeixinqyHandler_4", (String)"bos-mservice-message", (Object[])new Object[0]));
            read.put(BTN_REPLACENAME, (Object)ResManager.loadKDString((String)"\u672a\u8bfb", (String)"WeixinqyHandler_4", (String)"bos-mservice-message", (Object[])new Object[0]));
            JSONObject unread = new JSONObject();
            unread.put(BTN_KEY, (Object)"readBtn");
            unread.put(BTN_NAME, (Object)ResManager.loadKDString((String)"\u5df2\u8bfb", (String)"WeixinqyHandler_5", (String)"bos-mservice-message", (Object[])new Object[0]));
            unread.put(BTN_REPLACENAME, (Object)ResManager.loadKDString((String)"\u5df2\u8bfb", (String)"WeixinqyHandler_5", (String)"bos-mservice-message", (Object[])new Object[0]));
            btns.add((Object)read);
            btns.add((Object)unread);
        }
        return btns;
    }

    private static void wrapWeixinqyMessageUrl(WeixinqyMessageInfo messageInfo) {
        String msgUrl = messageInfo.getMsgUrl();
        int index = msgUrl.indexOf(63);
        String msgUrlPart1 = msgUrl.substring(0, index + 1);
        String msgUrlPart2 = msgUrl.substring(index + 1);
        String[] msgUrlParts = msgUrlPart2.split("&");
        StringBuilder sb = new StringBuilder(msgUrlPart1);
        for (String up : msgUrlParts) {
            if ((up.contains("appId=") || up.contains("formId=") || up.contains("pCaption=")) && !"formId=msg_openmessageurl".equals(up)) {
                if (!up.contains("mb_formId")) continue;
                sb.append(up).append("&");
                continue;
            }
            sb.append(up).append("&");
        }
        sb.append("device=mob&ado=view");
        messageInfo.setMsgUrl(sb.toString());
    }

    private static JSONObject wrapMessageBodyJson(WeixinqyMessageInfo messageInfo, MsgChannelInfo weixinCacheInfo) {
        if (weixinCacheInfo == null) {
            return null;
        }
        JSONObject body = new JSONObject();
        body.put("appId", (Object)weixinCacheInfo.getAgentid());
        body.put("nonce", (Object)RandomStringUtils.randomAlphanumeric((int)32));
        body.put("timestamp", (Object)System.currentTimeMillis());
        body.put("option", (Object)new JSONObject());
        body.put("toUser", (Object)messageInfo.getUserIds());
        JSONObject textBody = new JSONObject();
        if (messageInfo.getParams() != null && StringUtils.isNotBlank(messageInfo.getParams().get("uid"))) {
            textBody.put("bizId", (Object)(messageInfo.getMsgId() + String.valueOf(messageInfo.getParams().get("uid"))));
        } else {
            textBody.put("bizId", (Object)(messageInfo.getMsgId() + messageInfo.getUserIds()));
        }
        textBody.put("content", (Object)messageInfo.getContent());
        textBody.put("title", (Object)messageInfo.getTitle());
        if (messageInfo.isLinkMsg()) {
            textBody.put("msgType", (Object)5);
            JSONArray btnBody = WeixinqyPublicHandler.buildTaskCardBody(messageInfo.getMsgType());
            JSONObject option = new JSONObject();
            option.put("cardButton", (Object)btnBody);
            textBody.put("option", (Object)option);
            JSONObject link = new JSONObject();
            link.put("query", (Object)WeixinqyPublicHandler.getUrlPartBody(messageInfo));
            link.put("parameter", (Object)Base64.getEncoder().encodeToString(messageInfo.getMsgUrl().getBytes()));
            link.put("islink", (Object)true);
            textBody.put("link", (Object)link);
        } else {
            textBody.put("msgType", (Object)1);
            textBody.put("option", null);
            textBody.put("link", null);
        }
        body.put("content", (Object)textBody);
        logger.info("updateMessage-- messageinfo is :" + body.toJSONString());
        return body;
    }

    private static String getCloudClientId() {
        String cloudId = System.getProperty("clientId");
        if (StringUtils.isEmpty((CharSequence)cloudId)) {
            cloudId = MessageServiceProperties.weixinqyCloudId;
        }
        return cloudId;
    }

    private static String getClientSecret() {
        String clientSecret = System.getProperty("clientSecret");
        if (StringUtils.isEmpty((CharSequence)clientSecret)) {
            clientSecret = MessageServiceProperties.weixinqyClientSecret;
        }
        return clientSecret;
    }

    private static String getUrlPartBody(WeixinqyMessageInfo messageInfo) {
        String url = messageInfo.getMsgUrl();
        String domain = UrlService.getDomainContextUrl();
        Map params = messageInfo.getParams();
        if (params != null && params.containsKey("domain")) {
            domain = (String)params.get("domain");
        }
        return url.substring(domain.length() + 1, url.length());
    }
}

