/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.pa.api;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.message.service.pa.api.IMessageAdapter;
import kd.bos.message.service.pa.api.IMessageSection;
import org.apache.log4j.Logger;

public abstract class AbstractMessage
implements IMessageSection {
    private static Logger logger = Logger.getLogger((String)AbstractMessage.class.getName());
    protected IMessageSection head = null;
    protected IMessageSection body = null;

    public AbstractMessage(IMessageAdapter adapter, String pubAcctCode) throws NullPointerException {
    }

    @Override
    public void makeContent(Map<String, Object> fields) {
        try {
            this.head = (IMessageSection)fields.get("head");
            this.body = (IMessageSection)fields.get("body");
        }
        catch (ClassCastException e) {
            logger.error((Object)("message content object cast error:" + e.getMessage()));
        }
    }

    @Override
    public Map<String, Object> getContent() {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.putAll(this.head.getContent());
        content.putAll(this.body.getContent());
        return content;
    }

    @Override
    public boolean hasReady() {
        if (this.head == null || this.body == null) {
            return false;
        }
        return this.head.hasReady() && this.body.hasReady();
    }

    @Override
    public boolean isSupportMultiEntries() {
        return this.body.isSupportMultiEntries();
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int indentFactor) {
        String msg = null;
        if (this.hasReady()) {
            JSONObject message = new JSONObject(this.getContent());
            try {
                msg = message.toString();
                logger.info((Object)"push content has been built complete");
            }
            catch (JSONException e) {
                logger.error((Object)"error message", (Throwable)e);
            }
        }
        return msg;
    }
}

