/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.pa.api;

import java.nio.charset.Charset;
import kd.bos.message.service.pa.api.AbstractMessage;
import kd.bos.message.service.pa.api.ITalkTransfer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public abstract class AbstractTransfer
implements ITalkTransfer {
    private static Logger logger = Logger.getLogger((String)AbstractTransfer.class.getName());
    private static final int HTTP_STATUS_OK = 200;
    private static final int CONNECTIONTIMEOUT = 5000;
    private static final int READTIMEOUT = 10000;
    private String response = null;
    private boolean status = false;
    private AbstractMessage message = null;

    public AbstractTransfer(AbstractMessage message) {
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushMessage() {
        if (this.message != null && this.message.hasReady()) {
            this.status = false;
            String url = this.getConnectServerURL();
            CloseableHttpClient http = HttpClients.createSystem();
            HttpParams httpParams = http.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)10000);
            HttpPost post = new HttpPost(url);
            try {
                post = new HttpPost(url);
                post.setHeader("Content-Type", this.getConnectContentType());
                StringEntity entity = new StringEntity(this.message.toString(), Charset.forName("UTF-8"));
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                post.setEntity((HttpEntity)entity);
                logger.info((Object)("starting push message to XT, push address is :" + url));
                logger.info((Object)("starting push message to XT, push message.toString() is :" + this.message.toString()));
                HttpResponse response = http.execute((HttpUriRequest)post);
                if (200 == response.getStatusLine().getStatusCode()) {
                    this.status = true;
                }
                post.releaseConnection();
            }
            catch (Throwable e) {
                logger.error((Object)"error message", e);
                this.status = false;
                this.response = "send exception:" + e.getMessage();
            }
            finally {
                post.releaseConnection();
            }
        } else {
            this.status = false;
            this.response = this.message == null ? "message object was not initialized" : "message object was not ready";
        }
        return this.response;
    }

    @Override
    public boolean isSucceed() {
        return this.status;
    }

    public void setMessage(AbstractMessage message) {
        this.message = message;
    }

    public AbstractMessage getMessage() {
        return this.message;
    }

    protected abstract String getConnectServerURL();

    protected abstract String getConnectContentType();
}

