/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.pa.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.MessageModelEnum;
import kd.bos.message.service.pa.MessageTypeEnum;
import kd.bos.message.service.pa.api.AbstractMessage;
import kd.bos.message.service.pa.api.IMessageAdapter;
import kd.bos.message.service.pa.common.MessageSectionFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CommonMessage
extends AbstractMessage {
    private static Log logger = LogFactory.getLog(CommonMessage.class);
    private static String PUSH_ALL_USERS = "PUSH_ALL_USERS";

    public CommonMessage(String eid, IMessageAdapter msg, String pubAcctCode, String pubacckey, String code, boolean toAllUser) throws NullPointerException {
        super(msg, pubAcctCode);
        if (msg == null) {
            throw new NullPointerException("adapter is null");
        }
        MessageTypeEnum type = null;
        MessageModelEnum model = null;
        HashMap<String, Object> headPackage = null;
        HashMap<String, Object> bodyPackage = null;
        String signTime = null;
        List<String> userList = null;
        ArrayList<Map<String, Object>> bodyList = new ArrayList<Map<String, Object>>();
        if (msg.isNeedSendXT()) {
            type = msg.getType();
            model = msg.getModel();
            signTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(msg.getUpdateTime());
            Map<String, Object> m = msg.getContent();
            if (m != null) {
                bodyList.add(m);
            }
            logger.debug("CommonMessage === msg.getUsers()" + msg.getUsers().size());
            for (int i = 0; i < msg.getUsers().size(); ++i) {
                logger.debug("CommonMessage === msg.getUsers().get(" + i + ")" + msg.getUsers().get(i));
            }
            List<String> xtList = this.transferUserIdToXtId(msg.getUsers());
            logger.debug("CommonMessage === xtList" + xtList.size());
            for (int j = 0; j < xtList.size(); ++j) {
                logger.debug("CommonMessage === xtList.get(" + j + ")" + xtList.get(j));
            }
            userList = this.mergeUsers(userList, xtList, toAllUser);
            logger.debug("CommonMessage === userList" + (userList == null ? 0 : userList.size()));
            if (userList != null && userList.size() > 0) {
                for (int k = 0; k < userList.size(); ++k) {
                    logger.debug("CommonMessage === xtList.get(" + k + ")" + userList.get(k));
                }
            } else {
                logger.debug("userList is null");
                return;
            }
        }
        try {
            if (bodyList.size() > 0) {
                this.head = MessageSectionFactory.getInstance().getMessageHead("common", eid);
                headPackage = new HashMap<String, Object>();
                headPackage.put("account", pubAcctCode);
                headPackage.put("signtime", signTime);
                headPackage.put("users", userList);
                headPackage.put("pubacckey", pubacckey);
                headPackage.put("code", code);
                this.head.makeContent(headPackage);
                this.body = MessageSectionFactory.getInstance().getMessageBody(type, model);
                bodyPackage = new HashMap();
                if (this.body.isSupportMultiEntries()) {
                    if (bodyList.size() > 1) {
                        model = MessageModelEnum.MULTIGRAPHIC;
                    }
                    bodyPackage.put("list", bodyList);
                } else {
                    bodyPackage = msg.getContent();
                }
                this.body.makeContent(bodyPackage);
            } else {
                logger.debug("has found 1 adapter messages,but no message need push");
            }
        }
        catch (ClassNotFoundException e) {
            logger.warn("message type is error:" + e.getMessage());
        }
        catch (NullPointerException e) {
            throw e;
        }
    }

    private List<String> transferUserIdToXtId(List<Long> userIdList) {
        ArrayList<String> yzjList = new ArrayList<String>();
        String entityName = "bos_user";
        String selectFields = "useropenid";
        QFilter idsFilter = new QFilter("id", "in", userIdList);
        QFilter[] filters = new QFilter[]{idsFilter};
        DynamicObjectCollection userCollection = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        for (DynamicObject user : userCollection) {
            yzjList.add(user.getString("useropenid"));
        }
        return yzjList;
    }

    private List<String> mergeUsers(List<String> firstList, List<String> secondList, boolean toAllUser) {
        List<Object> list;
        block5: {
            list = null;
            if (!toAllUser) {
                try {
                    if (firstList == null) {
                        list = secondList;
                        break block5;
                    }
                    list = new ArrayList();
                    list.addAll(firstList);
                    secondList.removeAll(list);
                    list.addAll(secondList);
                }
                catch (Exception e) {
                    logger.warn("the list of user has error:" + e.getMessage());
                }
            } else {
                list = new ArrayList();
                list.add(PUSH_ALL_USERS);
                logger.debug("push to all user switch has enabled");
            }
        }
        return list;
    }
}

