/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.pa.common;

import kd.bos.message.service.pa.MessageModelEnum;
import kd.bos.message.service.pa.MessageTypeEnum;
import kd.bos.message.service.pa.api.IMessageSection;
import kd.bos.message.service.pa.common.CommonMessageHead;
import kd.bos.message.service.pa.common.messagebody.ImageMessageBody;
import kd.bos.message.service.pa.common.messagebody.LinkMessageBody;
import kd.bos.message.service.pa.common.messagebody.MultiGraphicMessageBody;
import kd.bos.message.service.pa.common.messagebody.SingleGraphicMessageBody;
import kd.bos.message.service.pa.common.messagebody.TextGraphicMessageBody;
import kd.bos.message.service.pa.common.messagebody.TextMessageBody;

public class MessageSectionFactory {
    private static MessageSectionFactory instance = new MessageSectionFactory();
    private static final String NOTFOUND = "has not found.";

    protected MessageSectionFactory() {
    }

    public static MessageSectionFactory getInstance() {
        return instance;
    }

    public IMessageSection getMessageHead(String type, String eid) throws ClassNotFoundException {
        if (type != null && type.equalsIgnoreCase("common")) {
            return new CommonMessageHead(eid);
        }
        throw new ClassNotFoundException("the class of message head type :" + type + NOTFOUND);
    }

    public IMessageSection getMessageBody(MessageTypeEnum type, MessageModelEnum model) throws ClassNotFoundException {
        if (type != null) {
            if (type == MessageTypeEnum.TEXT) {
                return new TextMessageBody();
            }
            if (type == MessageTypeEnum.IMAGE) {
                return new ImageMessageBody();
            }
            if (type == MessageTypeEnum.LINK) {
                return new LinkMessageBody();
            }
            if (type == MessageTypeEnum.GRAPHIC) {
                if (model != null) {
                    if (model == MessageModelEnum.SINGLETEXT) {
                        return new TextGraphicMessageBody();
                    }
                    if (model == MessageModelEnum.SINGLEGRAPHIC) {
                        return new SingleGraphicMessageBody();
                    }
                    if (model == MessageModelEnum.MULTIGRAPHIC) {
                        return new MultiGraphicMessageBody();
                    }
                    throw new ClassNotFoundException("the class of message body model :" + model.toString() + NOTFOUND);
                }
                throw new ClassNotFoundException("the model is null,message body object can not be created");
            }
            throw new ClassNotFoundException("the class of message body type :" + type.toString() + NOTFOUND);
        }
        throw new ClassNotFoundException("the type is null,message body object can not be created");
    }
}

