/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.pa.common.messagebody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.message.service.pa.MessageModelEnum;
import kd.bos.message.service.pa.MessageTypeEnum;
import kd.bos.message.service.pa.ThumbnailTypeEnum;
import kd.bos.message.service.pa.api.IMessageSection;
import kd.bos.message.service.pa.util.StringUtil;
import org.apache.log4j.Logger;

public class SingleGraphicMessageBody
implements IMessageSection {
    private static Logger logger = Logger.getLogger((String)SingleGraphicMessageBody.class.getName());
    private Map<String, Object> content = null;
    private static final String TITLE = "title";
    private static final String[] FIELDARR = new String[]{"date", "title", "text", "name", "pic"};

    @Override
    public Map<String, Object> getContent() {
        return this.content;
    }

    @Override
    public void makeContent(Map<String, Object> content) {
        List list = (List)content.get("list");
        if (list != null && (content = (Map)list.get(0)) != null) {
            boolean isAddToList = true;
            for (int i = 0; i < FIELDARR.length; ++i) {
                if (content.containsKey(FIELDARR[i])) continue;
                isAddToList = false;
                break;
            }
            if (isAddToList) {
                HashMap part = new HashMap();
                part.put("date", content.get("date"));
                part.put(TITLE, content.get(TITLE));
                part.put("text", content.get("text"));
                part.put("zip", content.get("zip"));
                part.put("url", content.get("url"));
                part.put("appid", content.get("appid"));
                part.put("name", content.get("name"));
                part.put("pic", this.getMsgThumbnail(content.get("pic").toString(), ThumbnailTypeEnum.BIG, SingleGraphicMessageBody.getExtension(content.get("name").toString())));
                ArrayList partList = new ArrayList();
                partList.add(part);
                HashMap<String, Serializable> msg = new HashMap<String, Serializable>();
                msg.put("model", Integer.valueOf(MessageModelEnum.SINGLEGRAPHIC.value()));
                msg.put("list", partList);
                this.content = new HashMap<String, Object>();
                this.content.put("type", MessageTypeEnum.GRAPHIC.value());
                this.content.put("msg", msg);
            }
        }
    }

    private static String getExtension(String filename) {
        int i;
        if (StringUtil.isNotEmpty(filename) && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    @Override
    public boolean hasReady() {
        if (this.content == null) {
            logger.debug((Object)"message body object is null");
            return false;
        }
        if (!this.content.containsKey("type") || !this.content.containsKey("msg")) {
            logger.debug((Object)"message body fields has not ready");
            return false;
        }
        return true;
    }

    private String getMsgThumbnail(String data, ThumbnailTypeEnum type, String ext) {
        byte[] out = null;
        String base64 = null;
        base64 = StringUtil.getBase64FromByte(out);
        return base64;
    }

    @Override
    public boolean isSupportMultiEntries() {
        return true;
    }
}

