/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.pa.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SignUtil {
    private static Logger logger = Logger.getLogger((String)SignUtil.class.getName());

    private SignUtil() {
    }

    public static PrivateKey getPrivateKey(String eID, String keyPath) throws Exception {
        PrivateKey privateKey = null;
        String fileName = keyPath + "/" + eID + ".key";
        try {
            privateKey = SignUtil.restorePrivateKey(SignUtil.readFile(fileName));
        }
        catch (Exception e) {
            logger.error((Object)String.format("error message:private key file[%s] format error!", fileName));
            throw new Exception(ResManager.loadKDString((String)"\u89e3\u91ca\u4f01\u4e1a\u5ba2\u6237\u7684\u79c1\u94a5\u6587\u4ef6\u51fa\u9519\u3002", (String)"SignUtil_2", (String)"bos-mservice-message", (Object[])new Object[0]), e);
        }
        return privateKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFile(String filePath) {
        try (RandomAccessFile rfile = new RandomAccessFile(new File(FilenameUtils.getName((String)filePath)), "r");){
            byte[] classBytes = new byte[(int)rfile.length()];
            rfile.read(classBytes);
            byte[] byArray = classBytes;
            return byArray;
        }
        catch (IOException ex) {
            return new byte[0];
        }
    }

    private static PrivateKey restorePrivateKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(pkcs);
    }

    public static String getPubtoken(String eid, String openid, String pubacckey, String nonce, String timestamp) {
        Object[] data = new String[]{eid, openid, pubacckey, nonce, timestamp};
        Arrays.sort(data);
        String pubtoken = DigestUtils.sha256Hex((String)StringUtils.join((Object[])data));
        return pubtoken;
    }
}

