/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.utils;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.message.service.utils.DingdingMessageUtils;
import kd.bos.message.utils.MessageUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.RevProxyUtil;

public class AccessTokenUtils {
    private static Log logger = LogFactory.getLog(AccessTokenUtils.class);
    private static final String BS_MESSAGE_SERVICE_REGION = "MESSAGE_SERVICE";
    private static final int REDISTIMEOUT = 1800;
    private static DistributeSessionlessCache messageCache = null;
    private static final String DINGACCESSTOKEN = "dingAccessToken";
    private static final String WEIXINACCESSTOKEN = "weixinqyAccessToken";
    private static final String DINGDING = "dingding";
    private static final String WEIXINQY = "weixinqy";
    private static final String ERRORCODE = "errcode";
    private static final String ERRORMSG = "errmsg";

    private static DistributeSessionlessCache getDisCache() {
        if (messageCache == null) {
            messageCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(BS_MESSAGE_SERVICE_REGION, new DistributeCacheHAPolicy());
        }
        return messageCache;
    }

    public static String getDinddingAccessToken(String type, String appKey, String appSecret, String corpId) {
        String cacheSign = DINGDING.equals(type) ? DINGACCESSTOKEN : WEIXINACCESSTOKEN;
        String cacheKey = AccessTokenUtils.getWholeKey(appKey, cacheSign);
        String accessToken = (String)AccessTokenUtils.getDisCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            accessToken = AccessTokenUtils.updateAccessTokenInCache(type, appKey, appSecret, corpId, cacheKey);
        }
        return accessToken;
    }

    private static String updateAccessTokenInCache(String type, String appKey, String appSecret, String corpId, String cacheKey) {
        JSONObject tokenResult = null;
        tokenResult = DINGDING.equals(type) ? AccessTokenUtils.getDingdingAccessToken(appKey, appSecret) : AccessTokenUtils.getWeixinqyAccessToekn(corpId, appSecret);
        if (tokenResult.getInteger(ERRORCODE) != 0) {
            logger.info("AccessTokenUtils--\u83b7\u53d6token\u5931\u8d25\uff1a" + tokenResult.getString(ERRORMSG));
            return "";
        }
        String accessToken = tokenResult.getString("access_token");
        AccessTokenUtils.getDisCache().put(cacheKey, (Object)accessToken, 1800);
        return accessToken;
    }

    public static JSONObject getDingdingAccessToken(String appKey, String appSecret) {
        OapiGettokenRequest request = new OapiGettokenRequest();
        request.setAppkey(appKey);
        request.setAppsecret(appSecret);
        request.setHttpMethod("GET");
        OapiGettokenResponse response = null;
        JSONObject tokenResult = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "gettoken";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
            tokenResult = JSONObject.parseObject((String)response.getBody());
        }
        catch (ApiException e) {
            String message = e.getMessage();
            if (message.contains("appkey") && message.contains("appsecret")) {
                message = "";
            }
            logger.info("AccessTokenUtils--\u8c03\u7528\u63a5\u53e3\u83b7\u53d6accessToken\u629b\u51fa\u5f02\u5e38\uff0c msg:" + message);
            tokenResult.put(ERRORCODE, (Object)"101");
            tokenResult.put(ERRORMSG, (Object)message);
        }
        return tokenResult;
    }

    public static String getWeiXinQyDomain(MsgChannelInfo weixinCacheInfo) {
        String domain = "https://qyapi.weixin.qq.com/";
        try {
            if (weixinCacheInfo == null || MessageUtils.isEmpty((String)weixinCacheInfo.getConfig())) {
                return domain;
            }
            JSONObject jsonConfig = JSONObject.parseObject((String)weixinCacheInfo.getConfig());
            String privateDomain = jsonConfig.getString("privateDomain");
            if (StringUtils.isNotBlank((CharSequence)privateDomain) && !(domain = privateDomain).trim().endsWith("/")) {
                domain = domain + "/";
            }
        }
        catch (Exception e) {
            logger.info("setWeiXinQyDomain is error,errorinfo is :" + e.getMessage());
        }
        return domain;
    }

    private static JSONObject getWeixinqyAccessToekn(String corpId, String appSecret) {
        StringBuilder url = new StringBuilder();
        MsgChannelInfo weixinCacheInfo = MsgServiceCache.getMsgChannel((String)WEIXINQY);
        String domain = AccessTokenUtils.getWeiXinQyDomain(weixinCacheInfo);
        logger.info("getWeixinqyAccessToken domain:" + domain);
        url.append(domain).append("cgi-bin/gettoken?corpid=");
        url.append(corpId);
        url.append("&corpsecret=");
        url.append(appSecret);
        JSONObject tokenResult = new JSONObject();
        String result = "";
        try {
            result = HttpClientUtils.get((String)url.toString());
            tokenResult = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            logger.info("AccessTokenUtils--\u8c03\u7528\u63a5\u53e3\u83b7\u53d6accessToken\u629b\u51fa\u5f02\u5e38\uff0c msg:" + e.getMessage());
            tokenResult.put(ERRORCODE, (Object)"101");
            tokenResult.put(ERRORMSG, (Object)e.getMessage());
        }
        return tokenResult;
    }

    private static String getWholeKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getAccountId()).append(".msg.");
        return AccessTokenUtils.strAppend(sb.toString(), ".", args);
    }

    private static String strAppend(String pref, String split, String[] args) {
        StringBuilder sb = new StringBuilder(pref);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                sb.append(arg).append(split);
            }
        }
        return sb.substring(0, sb.length() - 1);
    }
}

