/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.utils;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.request.OapiMessageCorpconversationGetsendresultRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationRecallRequest;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.dingtalk.api.response.OapiMessageCorpconversationGetsendresultResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationRecallResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.DingdingMessageInfo;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.util.RevProxyUtil;

public class DingdingMessageUtils {
    private static Log logger = LogFactory.getLog(DingdingMessageUtils.class);
    private static final String LINK = "link";
    private static final String TEXT = "text";
    private static final String ERRORCODE = "errcode";
    private static final String ERRORMSG = "errmsg";

    public static JSONObject sendMessage(Long agentId, String accessToken, DingdingMessageInfo messageInfo) {
        logger.debug("DingdingMessageUtils--sendMessage--\u5f00\u59cb\u8c03\u7528api\u63a8\u9001\u4f01\u4e1a\u901a\u77e5");
        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        boolean isLinkMsg = messageInfo.isLinkMsg();
        if (isLinkMsg) {
            msg.setMsgtype(LINK);
            msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
            msg.getLink().setTitle(messageInfo.getTitle());
            msg.getLink().setText(messageInfo.getContent());
            msg.getLink().setMessageUrl(messageInfo.getMsgUrl());
            msg.getLink().setPicUrl("@lALOACZwe2Rk");
        } else {
            msg.setMsgtype(TEXT);
            msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
            msg.getText().setContent(messageInfo.getContent());
        }
        OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
        request.setUseridList(messageInfo.getUserIds());
        request.setAgentId(agentId);
        request.setToAllUser(Boolean.valueOf(false));
        request.setMsg(msg);
        JSONObject resultJson = new JSONObject();
        OapiMessageCorpconversationAsyncsendV2Response response = null;
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/message/corpconversation/asyncsend_v2";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            response = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)request, accessToken);
            logger.debug("DingdingMessageUtils--sendMessage--\u8c03\u7528api\u63a8\u9001\u4f01\u4e1a\u901a\u77e5\u6210\u529f");
            resultJson = JSONObject.parseObject((String)response.getBody());
        }
        catch (ApiException e) {
            logger.warn("DingdingMessageUtils--sendMessage--\u8c03\u7528api\u63a8\u9001\u4f01\u4e1a\u901a\u77e5\u629b\u51fa\u5f02\u5e38\uff0cmsg:" + e.getMessage());
            resultJson.put(ERRORCODE, (Object)"101");
            resultJson.put(ERRORMSG, (Object)e.getMessage());
        }
        return resultJson;
    }

    public static JSONObject recallMessage(Long agentId, String accessToken, Long msgId) {
        logger.debug("DingdingMessageUtils--recallMessage--\u5f00\u59cb\u8c03\u7528api\u64a4\u56de\u6d88\u606f");
        OapiMessageCorpconversationRecallRequest request = new OapiMessageCorpconversationRecallRequest();
        request.setAgentId(agentId);
        request.setMsgTaskId(msgId);
        OapiMessageCorpconversationRecallResponse response = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/message/corpconversation/recall";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            response = (OapiMessageCorpconversationRecallResponse)client.execute((TaobaoRequest)request, accessToken);
            resultJson = JSONObject.parseObject((String)response.getBody());
            logger.debug("DingdingMessageUtils--recallMessage--\u8c03\u7528api\u64a4\u56de\u6d88\u606f\u6210\u529f");
        }
        catch (ApiException e) {
            logger.warn("DingdingMessageUtils--recallMessage--\u8c03\u7528api\u64a4\u56de\u6d88\u606f\u629b\u51fa\u5f02\u5e38\uff0cmsg:" + e.getMessage());
            resultJson.put(ERRORCODE, (Object)"101");
            resultJson.put(ERRORMSG, (Object)e.getMessage());
        }
        return resultJson;
    }

    public static JSONObject checkMessageResult(Long agentId, String accessToken, Long msgId) {
        logger.debug("DingdingMessageUtils--checkMessageResult--\u5f00\u59cb\u8c03\u7528api\u67e5\u770b\u53d1\u9001\u6d88\u606f\u7ed3\u679c");
        OapiMessageCorpconversationGetsendresultRequest request = new OapiMessageCorpconversationGetsendresultRequest();
        request.setAgentId(agentId);
        request.setTaskId(msgId);
        OapiMessageCorpconversationGetsendresultResponse response = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/message/corpconversation/getsendresult";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            response = (OapiMessageCorpconversationGetsendresultResponse)client.execute((TaobaoRequest)request, accessToken);
            resultJson = JSONObject.parseObject((String)response.getBody());
            logger.debug("DingdingMessageUtils--checkMessageResult--\u67e5\u770b\u53d1\u9001\u6d88\u606f\u7ed3\u679c\u6210\u529f");
        }
        catch (ApiException e) {
            logger.warn("DingdingMessageUtils--checkMessageResult--\u67e5\u770b\u53d1\u9001\u6d88\u606f\u7ed3\u679c\u629b\u51fa\u5f02\u5e38\uff0cmsg:" + e.getMessage());
            resultJson.put(ERRORCODE, (Object)"101");
            resultJson.put(ERRORMSG, (Object)e.getMessage());
        }
        return resultJson;
    }

    public static String wrapDingdingUrl(String url) {
        String tenant = RequestContext.get().getTenantCode();
        logger.debug("DingdingMessageUtils--wrapDingdingUrl:" + tenant);
        String host = System.getProperty(tenant + "_dingding_host");
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            String apiHost = MessageServiceProperties.ddDomain;
            String domainSuffix = url.substring(apiHost.length() + 1);
            url = RevProxyUtil.addSlash((String)host) + domainSuffix;
        }
        return url;
    }
}

