/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.utils;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiProcessWorkrecordCreateRequest;
import com.dingtalk.api.request.OapiProcessWorkrecordUpdateRequest;
import com.dingtalk.api.response.OapiProcessWorkrecordCreateResponse;
import com.dingtalk.api.response.OapiProcessWorkrecordUpdateResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.DingdingTodoInfo;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.message.service.utils.DingdingMessageUtils;
import kd.bos.util.RevProxyUtil;

public class DingdingProcessInstanceUtils {
    private static Log logger = LogFactory.getLog(DingdingProcessInstanceUtils.class);

    public static JSONObject createProcessInstance(Long agentId, String accessToken, DingdingTodoInfo todoInfo) {
        logger.debug("DingdingProcessInstanceUtils--createProcessInstance--\u521b\u5efa\u5ba1\u6279\u5b9e\u4f8bbegin");
        OapiProcessWorkrecordCreateRequest.FormComponentValueVo obj4 = new OapiProcessWorkrecordCreateRequest.FormComponentValueVo();
        obj4.setName(ResManager.loadKDString((String)"\u5ba1\u6279\u5185\u5bb9", (String)"DingdingProcessInstanceUtils_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        obj4.setValue(todoInfo.getContent());
        ArrayList<OapiProcessWorkrecordCreateRequest.FormComponentValueVo> list3 = new ArrayList<OapiProcessWorkrecordCreateRequest.FormComponentValueVo>();
        list3.add(obj4);
        OapiProcessWorkrecordCreateRequest.SaveFakeProcessInstanceRequest obj1 = new OapiProcessWorkrecordCreateRequest.SaveFakeProcessInstanceRequest();
        obj1.setAgentid(agentId);
        obj1.setProcessCode(todoInfo.getTplProcessCode());
        obj1.setOriginatorUserId(todoInfo.getOriginatorUserId());
        obj1.setFormComponentValues(list3);
        obj1.setTitle(todoInfo.getTitle());
        obj1.setUrl(todoInfo.getInstanceUrl());
        OapiProcessWorkrecordCreateRequest req = new OapiProcessWorkrecordCreateRequest();
        req.setRequest(obj1);
        OapiProcessWorkrecordCreateResponse rsp = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/workrecord/create";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            rsp = (OapiProcessWorkrecordCreateResponse)client.execute((TaobaoRequest)req, accessToken);
            logger.debug("DingdingProcessInstanceUtils--createProcessInstance--\u521b\u5efa\u5ba1\u6279\u5b9e\u4f8bsuccess");
            resultJson = JSONObject.parseObject((String)rsp.getBody());
        }
        catch (ApiException e) {
            logger.warn("DingdingProcessInstanceUtils--createProcessInstance--\u521b\u5efa\u5ba1\u6279\u5b9e\u4f8b\u5f02\u5e38 msg:" + e.getMessage());
            resultJson.put("errcode", (Object)"101");
            resultJson.put("errmsg", (Object)e.getMessage());
        }
        return resultJson;
    }

    public static JSONObject updateProcessInstanceStatus(Long agentId, String accessToken, String processInstanceId, String status, String result) {
        logger.debug("DingdingProcessInstanceUtils--updateProcessInstanceStatus--\u66f4\u65b0\u5b9e\u4f8b\u72b6\u6001begin");
        OapiProcessWorkrecordUpdateRequest req = new OapiProcessWorkrecordUpdateRequest();
        OapiProcessWorkrecordUpdateRequest.UpdateProcessInstanceRequest obj1 = new OapiProcessWorkrecordUpdateRequest.UpdateProcessInstanceRequest();
        obj1.setAgentid(agentId);
        obj1.setProcessInstanceId(processInstanceId);
        obj1.setStatus(status);
        obj1.setResult(result);
        obj1.setCancelRunningTask(Boolean.valueOf(true));
        req.setRequest(obj1);
        OapiProcessWorkrecordUpdateResponse rsp = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/workrecord/update";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            rsp = (OapiProcessWorkrecordUpdateResponse)client.execute((TaobaoRequest)req, accessToken);
            logger.debug("DingdingProcessInstanceUtils--updateProcessInstanceStatus--\u66f4\u65b0\u5b9e\u4f8b\u72b6\u6001success");
            resultJson = JSONObject.parseObject((String)rsp.getBody());
        }
        catch (ApiException e) {
            logger.warn("DingdingProcessInstanceUtils--updateProcessInstanceStatus--\u66f4\u65b0\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 msg:" + e.getMessage());
            resultJson.put("errcode", (Object)"101");
            resultJson.put("errmsg", (Object)e.getMessage());
        }
        return resultJson;
    }
}

